/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax;

import avrora.syntax.ASTNode;
import avrora.syntax.Context;
import cck.parser.AbstractToken;
import cck.text.StringUtil;
import cck.util.Util;

public abstract class Expr
extends ASTNode {
    public abstract int evaluate(int var1, Context var2);

    private static int asInt(boolean b) {
        return b ? 1 : 0;
    }

    private static boolean asBool(int i) {
        return i != 0;
    }

    public static class RelativeAddress
    extends Expr {
        public final AbstractToken dot;
        public final AbstractToken op;
        public final AbstractToken num;

        public RelativeAddress(AbstractToken d, AbstractToken o, AbstractToken n) {
            this.dot = d;
            this.op = o;
            this.num = n;
        }

        public AbstractToken getLeftMostToken() {
            return this.dot;
        }

        public AbstractToken getRightMostToken() {
            return this.num;
        }

        public String toString() {
            return '.' + this.op.image + this.num.image;
        }

        public int evaluate(int currentByteAddress, Context c) {
            int offset = StringUtil.evaluateIntegerLiteral(this.num.image);
            if ("+".equals(this.op.image)) {
                return currentByteAddress + offset;
            }
            if ("-".equals(this.op.image)) {
                return currentByteAddress - offset;
            }
            throw Util.failure("unknown operation in relative computation: " + this.op.image);
        }
    }

    public static class StringLiteral
    extends Term {
        public final String value;

        public StringLiteral(AbstractToken tok) {
            super(tok);
            try {
                this.value = StringUtil.evaluateStringLiteral(tok.image);
            }
            catch (Exception e) {
                throw Util.unexpected(e);
            }
        }

        public int evaluate(int currentByteAddress, Context c) {
            throw Util.failure("cannot evaluate a string to an integer");
        }
    }

    public static class Constant
    extends Term {
        public final int value;

        public Constant(AbstractToken tok) {
            super(tok);
            this.value = Constant.evaluateLiteral(tok.image);
        }

        public int evaluate(int currentByteAddress, Context c) {
            return this.value;
        }

        private static int evaluateLiteral(String val) {
            if (val.charAt(0) == '$') {
                return Integer.parseInt(val.substring(1), 16);
            }
            try {
                return StringUtil.evaluateIntegerLiteral(val);
            }
            catch (Exception e) {
                throw Util.unexpected(e);
            }
        }
    }

    public static class Variable
    extends Term {
        public Variable(AbstractToken n) {
            super(n);
        }

        public int evaluate(int currentByteAddress, Context c) {
            return c.getVariable(this.token);
        }
    }

    public static abstract class Term
    extends Expr {
        public final AbstractToken token;

        protected Term(AbstractToken tok) {
            this.token = tok;
        }

        public AbstractToken getLeftMostToken() {
            return this.token;
        }

        public AbstractToken getRightMostToken() {
            return this.token;
        }

        public String toString() {
            return this.token.image;
        }
    }

    public static class Func
    extends Expr {
        public final AbstractToken func;
        public final Expr argument;
        public final AbstractToken last;

        public Func(AbstractToken tok, Expr arg, AbstractToken l) {
            this.func = tok;
            this.argument = arg;
            this.last = l;
        }

        public int evaluate(int currentByteAddress, Context c) {
            int aval = this.argument.evaluate(currentByteAddress, c);
            String f = this.func.image;
            if ("byte".equalsIgnoreCase(f)) {
                return aval & 0xFF;
            }
            if ("low".equalsIgnoreCase(f) || "lo8".equals(f)) {
                return aval & 0xFF;
            }
            if ("high".equalsIgnoreCase(f) || "hi8".equals(f)) {
                return aval >>> 8 & 0xFF;
            }
            if ("byte2".equalsIgnoreCase(f)) {
                return aval >>> 8 & 0xFF;
            }
            if ("byte3".equalsIgnoreCase(f)) {
                return aval >>> 16 & 0xFF;
            }
            if ("byte4".equalsIgnoreCase(f)) {
                return aval >>> 24 & 0xFF;
            }
            if ("lwrd".equalsIgnoreCase(f)) {
                return aval & 0xFFFF;
            }
            if ("hwrd".equalsIgnoreCase(f)) {
                return aval >>> 16 & 0xFFFF;
            }
            if ("page".equalsIgnoreCase(f)) {
                return aval >>> 16 & 0x3F;
            }
            if ("exp2".equalsIgnoreCase(f)) {
                return 1 << aval;
            }
            if ("log2".equalsIgnoreCase(f)) {
                return this.log(aval);
            }
            throw Util.failure("unknown function: " + this.func);
        }

        private int log(int val) {
            int log = 1;
            if ((val & 0xFFFF0000) != 0) {
                log += 16;
                val >>= 16;
            }
            if ((val & 0xFFFF00) != 0) {
                log += 8;
                val >>= 8;
            }
            if ((val & 0xFFFF0) != 0) {
                log += 4;
                val >>= 4;
            }
            if ((val & 0xFFFFC) != 0) {
                log += 2;
                val >>= 2;
            }
            if ((val & 0xFFFFE) != 0) {
                ++log;
            }
            return log;
        }

        public AbstractToken getLeftMostToken() {
            return this.func;
        }

        public AbstractToken getRightMostToken() {
            return this.last;
        }

        public String toString() {
            return StringUtil.embed(this.func.image, this.argument);
        }
    }

    public static class UnOp
    extends Expr {
        public final AbstractToken op;
        public final Expr operand;

        public UnOp(AbstractToken tok, Expr oper) {
            this.op = tok;
            this.operand = oper;
        }

        public int evaluate(int currentByteAddress, Context c) {
            int oval = this.operand.evaluate(currentByteAddress, c);
            String o = this.op.image;
            if ("!".equals(o)) {
                return Expr.asInt(!Expr.asBool(oval));
            }
            if ("~".equals(o)) {
                return ~oval;
            }
            if ("-".equals(o)) {
                return -oval;
            }
            throw Util.failure("unknown unary operator: " + this.op);
        }

        public AbstractToken getLeftMostToken() {
            return this.op;
        }

        public AbstractToken getRightMostToken() {
            return this.operand.getRightMostToken();
        }

        public String toString() {
            return StringUtil.embed(this.op.image, this.operand);
        }
    }

    public static class BinOp
    extends Expr {
        public final AbstractToken op;
        public final Expr left;
        public final Expr right;

        public BinOp(AbstractToken tok, Expr l, Expr r) {
            this.op = tok;
            this.left = l;
            this.right = r;
        }

        public int evaluate(int currentByteAddress, Context c) {
            int lval = this.left.evaluate(currentByteAddress, c);
            int rval = this.right.evaluate(currentByteAddress, c);
            String o = this.op.image;
            if ("*".equals(o)) {
                return lval * rval;
            }
            if ("/".equals(o)) {
                return lval / rval;
            }
            if ("-".equals(o)) {
                return lval - rval;
            }
            if ("+".equals(o)) {
                return lval + rval;
            }
            if ("<<".equals(o)) {
                return lval << rval;
            }
            if (">>".equals(o)) {
                return lval >> rval;
            }
            if ("<".equals(o)) {
                return Expr.asInt(lval < rval);
            }
            if (">".equals(o)) {
                return Expr.asInt(lval > rval);
            }
            if ("<=".equals(o)) {
                return Expr.asInt(lval <= rval);
            }
            if (">=".equals(o)) {
                return Expr.asInt(lval >= rval);
            }
            if ("==".equals(o)) {
                return Expr.asInt(lval == rval);
            }
            if ("!=".equals(o)) {
                return Expr.asInt(lval != rval);
            }
            if ("&".equals(o)) {
                return lval & rval;
            }
            if ("^".equals(o)) {
                return lval ^ rval;
            }
            if ("|".equals(o)) {
                return lval | rval;
            }
            if ("&&".equals(o)) {
                return Expr.asInt(Expr.asBool(lval) && Expr.asBool(rval));
            }
            if ("||".equals(o)) {
                return Expr.asInt(Expr.asBool(lval) || Expr.asBool(rval));
            }
            throw Util.failure("unknown binary operator: " + this.op);
        }

        public AbstractToken getLeftMostToken() {
            return this.left.getLeftMostToken();
        }

        public AbstractToken getRightMostToken() {
            return this.right.getRightMostToken();
        }

        public String toString() {
            return StringUtil.embed(this.op.image, this.left, this.right);
        }
    }
}

