/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax;

import avrora.arch.legacy.LegacyRegister;
import avrora.syntax.ASTNode;
import avrora.syntax.SyntacticOperand;
import cck.parser.AbstractToken;
import cck.parser.ErrorReporter;
import cck.parser.SourcePoint;
import cck.text.StringUtil;

public class AVRErrorReporter
extends ErrorReporter {
    private SourcePoint point(AbstractToken t) {
        return new SourcePoint(t.file, t.beginLine, t.beginColumn, t.endColumn);
    }

    private SourcePoint point(ASTNode n) {
        AbstractToken l = n.getLeftMostToken();
        AbstractToken r = n.getRightMostToken();
        return new SourcePoint(l.file, l.beginLine, l.beginColumn, r.endColumn);
    }

    public void UnknownRegister(AbstractToken reg) {
        String report = "unknown register " + StringUtil.quote(reg);
        this.error("UnknownRegister", this.point(reg), report);
    }

    public void InstructionCannotBeInSegment(String seg, AbstractToken instr) {
        String report = "instructions cannot be declared in " + seg + " cseg";
        this.error("InstructionCannotBeInSegment", this.point(instr), report);
    }

    public void RegisterExpected(SyntacticOperand o) {
        String report = "register expected";
        this.error("RegisterExpected", this.point(o), report);
    }

    public void IncorrectRegister(SyntacticOperand o, LegacyRegister reg, String expect) {
        String report = "incorrected register " + StringUtil.quote(reg) + ", expected one of " + expect;
        this.error("IncorrectRegister", this.point(o), report);
    }

    public void ConstantExpected(SyntacticOperand o) {
        String report = "constant expected";
        this.error("ConstantExpected", this.point(o), report);
    }

    public void ConstantOutOfRange(SyntacticOperand o, int value, String range) {
        String report = "constant " + StringUtil.quote("" + value) + " out of expected range " + range;
        this.error("ConstantOutOfRange", this.point(o), report, "" + value);
    }

    public void WrongNumberOfOperands(AbstractToken instr, int seen, int expected) {
        String report = "wrong number of operands to instruction " + StringUtil.quote(instr) + ", expected " + expected + " and found " + seen;
        this.error("WrongNumberOfOperands", this.point(instr), report);
    }

    public void UnknownVariable(AbstractToken name) {
        String report = "unknown variable or label " + StringUtil.quote(name.image);
        this.error("UnknownVariable", this.point(name), report, name.image);
    }

    public void DataCannotBeInSegment(String seg, ASTNode loc) {
        String report = "initialized data cannot be in " + seg + " segment";
        this.error("DataCannotBeInSegment", this.point(loc), report, seg);
    }

    public void IncludeFileNotFound(AbstractToken tok) {
        String report = "include file not found " + tok;
        this.error("IncludeFileNotFound", this.point(tok), report);
    }
}

