/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack.isea;

import avrora.arch.legacy.LegacyRegister;

public class ISEValue {
    public static final byte UNKNOWN = -1;
    public static final byte SREG = 33;
    public static final byte EIMSK = 34;
    public static final byte TIMSK = 35;
    public static final byte R0 = 0;
    public static final byte R1 = 1;
    public static final byte R2 = 2;
    public static final byte R3 = 3;
    public static final byte R4 = 4;
    public static final byte R5 = 5;
    public static final byte R6 = 6;
    public static final byte R7 = 7;
    public static final byte R8 = 8;
    public static final byte R9 = 9;
    public static final byte R10 = 10;
    public static final byte R11 = 11;
    public static final byte R12 = 12;
    public static final byte R13 = 13;
    public static final byte R14 = 14;
    public static final byte R15 = 15;
    public static final byte R16 = 16;
    public static final byte R17 = 17;
    public static final byte R18 = 18;
    public static final byte R19 = 19;
    public static final byte R20 = 20;
    public static final byte R21 = 21;
    public static final byte R22 = 22;
    public static final byte R23 = 23;
    public static final byte R24 = 24;
    public static final byte R25 = 25;
    public static final byte R26 = 26;
    public static final byte R27 = 27;
    public static final byte R28 = 28;
    public static final byte R29 = 29;
    public static final byte R30 = 30;
    public static final byte R31 = 31;

    public static byte merge(byte b1, byte b2) {
        if (b1 == b2) {
            return b1;
        }
        return -1;
    }

    public static String toString(byte b1) {
        if (b1 == -1) {
            return "---";
        }
        if (b1 == 33) {
            return "SR";
        }
        if (b1 == 35) {
            return "TM";
        }
        if (b1 == 34) {
            return "EM";
        }
        if (b1 < 32 && b1 >= 0) {
            return "R" + b1;
        }
        return "???";
    }

    public static LegacyRegister asRegister(byte val) {
        if (val >= 0 && val <= 31) {
            return LegacyRegister.getRegisterByNumber(val - 0);
        }
        return null;
    }

    public static int asIORegister(byte val) {
        switch (val) {
            case 33: {
                return 63;
            }
            case 34: {
                return 57;
            }
            case 35: {
                return 55;
            }
        }
        return -1;
    }
}

