/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack.isea;

import avrora.arch.legacy.LegacyRegister;
import avrora.stack.isea.ISEAbstractState;
import cck.util.Util;

public class ISEState
extends ISEAbstractState {
    public static final int NUM_REGISTERS = 32;
    public static final int SREG_NUM = 63;
    public static final int EIMSK_NUM = 57;
    public static final int TIMSK_NUM = 55;
    public static final int SREG_OFF = 32;
    public static final int EIMSK_OFF = 33;
    public static final int TIMSK_OFF = 34;
    public static final int MAX_STACK = 40;
    protected static final ISEAbstractState.Element[] defaultElements = new ISEAbstractState.Element[35];
    protected static final byte[] defaultStack;

    public ISEState() {
        super(defaultElements, defaultStack, 0);
    }

    public ISEState(ISEState r) {
        super(r.elements, r.stack, r.depth);
    }

    public byte readRegister(LegacyRegister r) {
        byte value = this.getElement(r.getNumber());
        int off = this.getElemOffset(value);
        if (off != -1) {
            this.elements[off].read = true;
        }
        return value;
    }

    public byte getRegister(LegacyRegister r) {
        return this.getElement(r.getNumber());
    }

    public void writeRegister(LegacyRegister r, byte val) {
        this.writeElement(r.getNumber(), val);
    }

    public boolean isRegisterRead(LegacyRegister reg) {
        return this.elements[reg.getNumber()].read;
    }

    public byte readIORegister(int reg) {
        switch (reg) {
            case 63: {
                return this.readElement(32);
            }
            case 57: {
                return this.readElement(33);
            }
            case 55: {
                return this.readElement(34);
            }
        }
        return -1;
    }

    public boolean isIORegisterRead(int ior) {
        switch (ior) {
            case 63: {
                return this.elements[32].read;
            }
            case 57: {
                return this.elements[33].read;
            }
            case 55: {
                return this.elements[34].read;
            }
        }
        return true;
    }

    public void writeIORegister(int reg, byte val) {
        switch (reg) {
            case 63: {
                this.writeElement(32, val);
                break;
            }
            case 57: {
                this.writeElement(33, val);
                break;
            }
            case 55: {
                this.writeElement(34, val);
            }
        }
    }

    public byte getSREG() {
        return this.readElement(32);
    }

    public void writeSREG(byte val) {
        this.writeElement(32, val);
    }

    public void mergeWithCaller(ISEState caller) {
        int cntr;
        for (cntr = 0; cntr < this.elements.length; ++cntr) {
            this.elements[cntr].value = this.computeValue(cntr, caller);
        }
        for (cntr = 0; cntr < this.elements.length; ++cntr) {
            if (this.elements[cntr].read) continue;
            this.elements[cntr].read = this.computeNewRead(cntr, caller);
        }
        if (this.depth != 0) {
            throw Util.failure("return with nonzero stack height");
        }
        System.arraycopy(caller.stack, 0, this.stack, 0, caller.depth);
        this.depth = caller.depth;
    }

    private byte computeValue(int elem, ISEState caller) {
        ISEAbstractState.Element relem = this.elements[elem];
        int origElem = this.getElemOffset(relem.value);
        if (origElem >= 0) {
            ISEAbstractState.Element oelem = caller.elements[origElem];
            return oelem.value;
        }
        return relem.value;
    }

    private boolean computeNewRead(int elem, ISEState caller) {
        ISEAbstractState.Element relem = this.elements[elem];
        int origElem = this.getElemOffset(relem.value);
        if (origElem >= 0) {
            ISEAbstractState.Element oelem = caller.elements[origElem];
            return oelem.read;
        }
        return false;
    }

    private int getElemOffset(byte value) {
        int off = -1;
        if (value >= 0 && value <= 31) {
            off = value - 0;
        } else {
            switch (value) {
                case 33: {
                    off = 32;
                    break;
                }
                case 34: {
                    off = 33;
                    break;
                }
                case 35: {
                    off = 34;
                }
            }
        }
        return off;
    }

    public ISEState dup() {
        return new ISEState(this);
    }

    static {
        for (int cntr = 0; cntr < 32; ++cntr) {
            ISEState.defaultElements[cntr] = new ISEAbstractState.Element("R" + cntr, (byte)(0 + cntr), false);
        }
        ISEState.defaultElements[32] = new ISEAbstractState.Element("SR", 33, false);
        ISEState.defaultElements[33] = new ISEAbstractState.Element("EM", 34, false);
        ISEState.defaultElements[34] = new ISEAbstractState.Element("TM", 35, false);
        defaultStack = new byte[40];
    }
}

