/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack.isea;

import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyInstrVisitor;
import avrora.arch.legacy.LegacyRegister;
import avrora.core.Program;
import avrora.stack.isea.ISEState;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.text.Verbose;
import cck.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ISEInterpreter
implements LegacyInstrVisitor {
    protected final Verbose.Printer printer = Verbose.getVerbosePrinter("analysis.isea.interpreter");
    protected final Program program;
    protected int pc;
    protected int nextPC;
    protected ISEState state;
    protected ISEState returnState;
    Item head;
    Item tail;
    protected HashMap states;
    protected final SummaryCache cache;

    protected byte readRegister(LegacyRegister r) {
        return this.state.readRegister(r);
    }

    protected byte getRegister(LegacyRegister r) {
        return this.state.getRegister(r);
    }

    protected void writeRegister(LegacyRegister r, byte val) {
        this.state.writeRegister(r, val);
    }

    protected byte getSREG() {
        return this.state.getSREG();
    }

    protected void writeSREG(byte val) {
        this.state.writeSREG(val);
    }

    protected byte readIORegister(int ioreg) {
        return this.state.readIORegister(ioreg);
    }

    protected void writeIORegister(int ioreg, byte val) {
        this.state.writeIORegister(ioreg, val);
    }

    protected int relative(int offset) {
        return this.pc + 2 + 2 * offset;
    }

    protected int absolute(int offset) {
        return 2 * offset;
    }

    protected void branch(int addr) {
        this.addToWorkList("BRANCH", addr, this.state.dup());
    }

    protected void jump(int addr) {
        this.nextPC = addr;
    }

    protected ISEState processReturnState(ISEState caller, ISEState ret) {
        ISEState fs = ret.dup();
        fs.mergeWithCaller(caller);
        return fs;
    }

    protected void postReturn(ISEState state) {
        if (this.returnState == null) {
            this.returnState = state.dup();
        } else {
            this.returnState.merge(state);
        }
        this.cache.recordReturnSummary(this.nextPC, state);
    }

    protected void postReturnFromInterrupt(ISEState state) {
        if (this.returnState == null) {
            this.returnState = state.dup();
        } else {
            this.returnState.merge(state);
        }
        this.cache.recordReturnSummary(this.nextPC, state);
    }

    protected void skip() {
        this.branch(this.program.getNextPC(this.nextPC));
    }

    protected byte popByte() {
        return this.state.pop();
    }

    void pushByte(byte val) {
        this.state.push(val);
    }

    protected void addToWorkList(String str, int pc, ISEState s) {
        this.printAdd(str, s, pc);
        s = this.mergeState(pc, s);
        if (s == null) {
            return;
        }
        Item i = new Item(pc, s);
        if (this.head == null) {
            this.head = this.tail = i;
        } else {
            this.tail.next = i;
            this.tail = i;
        }
    }

    private void printAdd(String str, ISEState s, int pc) {
        if (!this.printer.enabled) {
            return;
        }
        Terminal.printBrightGreen(str);
        Terminal.println(":");
        this.printState(s, pc);
    }

    private void printState(ISEState s, int pc) {
        if (!this.printer.enabled) {
            return;
        }
        s.print(pc);
    }

    private ISEState mergeState(int pc, ISEState s) {
        ISEState es = (ISEState)this.states.get(new Integer(pc));
        if (es != null) {
            if (es.equals(s)) {
                this.printSeen();
                return null;
            }
            this.printMerge(es, pc);
            es.merge(s);
            s = es;
            this.printState(s, pc);
        } else {
            this.states.put(new Integer(pc), s);
        }
        return s;
    }

    private void printMerge(ISEState es, int pc) {
        if (!this.printer.enabled) {
            return;
        }
        Terminal.printRed("MERGE WITH");
        Terminal.nextln();
        this.printState(es, pc);
        Terminal.printRed("RESULT");
        Terminal.nextln();
    }

    private void printSeen() {
        if (!this.printer.enabled) {
            return;
        }
        Terminal.printRed("SEEN");
        Terminal.nextln();
    }

    public ISEInterpreter(Program p, SummaryCache cs) {
        this.program = p;
        this.states = new HashMap();
        this.cache = cs;
    }

    public ISEState analyze(int begin_addr) {
        this.addToWorkList("START", begin_addr, new ISEState());
        this.run();
        return this.returnState;
    }

    protected void run() {
        while (this.head != null) {
            int npc;
            Item i = this.head;
            this.head = this.head.next;
            this.pc = i.pc;
            this.state = i.state.dup();
            LegacyInstr instr = (LegacyInstr)this.program.readInstr(i.pc);
            this.printItem(instr);
            this.nextPC = npc = this.program.getNextPC(i.pc);
            instr.accept(this);
            if (this.nextPC < 0) continue;
            String str = npc == this.nextPC ? "FALLTHROUGH" : "JUMP";
            this.addToWorkList(str, this.nextPC, this.state);
        }
    }

    private void printItem(LegacyInstr instr) {
        if (!this.printer.enabled) {
            return;
        }
        TermUtil.printSeparator();
        this.printState(this.state, this.pc);
        Terminal.printBrightBlue(instr.getVariant());
        Terminal.println(" " + instr.getOperands());
        TermUtil.printThinSeparator(78);
    }

    private void mult(LegacyRegister r1, LegacyRegister r2) {
        this.readRegister(r1);
        this.readRegister(r2);
        this.writeSREG((byte)-1);
        this.writeRegister(LegacyRegister.R0, (byte)-1);
        this.writeRegister(LegacyRegister.R1, (byte)-1);
    }

    void binop(LegacyRegister r1, LegacyRegister r2) {
        this.readRegister(r1);
        this.readRegister(r2);
        this.writeSREG((byte)-1);
        this.writeRegister(r1, (byte)-1);
    }

    void unop(LegacyRegister r1) {
        this.readRegister(r1);
        this.writeSREG((byte)-1);
        this.writeRegister(r1, (byte)-1);
    }

    public void visit(LegacyInstr.ADC i) {
        this.binop(i.r1, i.r2);
    }

    public void visit(LegacyInstr.ADD i) {
        this.binop(i.r1, i.r2);
    }

    public void visit(LegacyInstr.ADIW i) {
        this.readRegister(i.r1);
        this.readRegister(i.r1.nextRegister());
        this.writeSREG((byte)-1);
        this.writeRegister(i.r1, (byte)-1);
        this.writeRegister(i.r1.nextRegister(), (byte)-1);
    }

    public void visit(LegacyInstr.AND i) {
        this.binop(i.r1, i.r2);
    }

    public void visit(LegacyInstr.ANDI i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.ASR i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.BCLR i) {
        this.writeIORegister(i.imm1, (byte)-1);
    }

    public void visit(LegacyInstr.BLD i) {
        this.readRegister(i.r1);
        this.writeRegister(i.r1, (byte)-1);
    }

    public void visit(LegacyInstr.BRBC i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRBS i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRCC i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRCS i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BREAK i) {
        this.end();
    }

    public void visit(LegacyInstr.BREQ i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRGE i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRHC i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRHS i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRID i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRIE i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRLO i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRLT i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRMI i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRNE i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRPL i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRSH i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRTC i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRTS i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRVC i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BRVS i) {
        this.branch(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.BSET i) {
        this.writeIORegister(i.imm1, (byte)-1);
    }

    public void visit(LegacyInstr.BST i) {
        byte tmp0 = this.readRegister(i.r1);
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CALL i) {
        int target = this.absolute(i.imm1);
        ISEState rs = this.cache.getProcedureSummary(target);
        ISEState fs = this.processReturnState(this.state, rs);
        this.addToWorkList("RET", this.nextPC, fs);
        this.end();
    }

    public void visit(LegacyInstr.CBI i) {
        this.writeIORegister(i.imm1, (byte)-1);
    }

    public void visit(LegacyInstr.CBR i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.CLC i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CLH i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CLI i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CLN i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CLR i) {
        this.writeSREG((byte)-1);
        this.writeRegister(i.r1, (byte)-1);
    }

    public void visit(LegacyInstr.CLS i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CLT i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CLV i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CLZ i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.COM i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.CP i) {
        this.readRegister(i.r1);
        this.readRegister(i.r2);
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CPC i) {
        this.readRegister(i.r1);
        this.readRegister(i.r2);
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CPI i) {
        this.readRegister(i.r1);
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.CPSE i) {
        this.readRegister(i.r1);
        this.readRegister(i.r2);
        this.writeSREG((byte)-1);
        this.skip();
    }

    public void visit(LegacyInstr.DEC i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.EICALL i) {
        throw Util.unimplemented();
    }

    public void visit(LegacyInstr.EIJMP i) {
        throw Util.unimplemented();
    }

    public void visit(LegacyInstr.ELPM i) {
        this.readRegister(LegacyRegister.Z);
        this.readRegister(LegacyRegister.Z.nextRegister());
        this.writeRegister(LegacyRegister.R0, (byte)-1);
    }

    public void visit(LegacyInstr.ELPMD i) {
        this.readRegister(LegacyRegister.Z);
        this.readRegister(LegacyRegister.Z.nextRegister());
        this.writeRegister(i.r1, (byte)-1);
    }

    public void visit(LegacyInstr.ELPMPI i) {
        this.readRegister(LegacyRegister.Z);
        this.readRegister(LegacyRegister.Z.nextRegister());
        this.writeRegister(i.r1, (byte)-1);
        this.writeRegister(LegacyRegister.Z, (byte)-1);
        this.writeRegister(LegacyRegister.Z.nextRegister(), (byte)-1);
    }

    public void visit(LegacyInstr.EOR i) {
        if (i.r1 == i.r2) {
            this.writeSREG((byte)-1);
            this.writeRegister(i.r1, (byte)-1);
        } else {
            this.binop(i.r1, i.r2);
        }
    }

    public void visit(LegacyInstr.FMUL i) {
        this.mult(i.r1, i.r2);
    }

    public void visit(LegacyInstr.FMULS i) {
        this.mult(i.r1, i.r2);
    }

    public void visit(LegacyInstr.FMULSU i) {
        this.mult(i.r1, i.r2);
    }

    public void visit(LegacyInstr.ICALL i) {
        List iedges = this.program.getIndirectEdges(this.pc);
        if (iedges == null) {
            throw Util.failure("No control flow information for indirect call at: " + StringUtil.addrToString(this.pc));
        }
        Iterator it = iedges.iterator();
        while (it.hasNext()) {
            int target_address = (Integer)it.next();
            ISEState rs = this.cache.getProcedureSummary(target_address);
            ISEState fs = this.processReturnState(this.state, rs);
            this.addToWorkList("RET", this.nextPC, fs);
        }
        this.end();
    }

    public void visit(LegacyInstr.IJMP i) {
        List iedges = this.program.getIndirectEdges(this.pc);
        if (iedges == null) {
            throw Util.failure("No control flow information for indirect call at: " + StringUtil.addrToString(this.pc));
        }
        Iterator it = iedges.iterator();
        while (it.hasNext()) {
            int target_address = (Integer)it.next();
            this.jump(target_address);
        }
    }

    public void visit(LegacyInstr.IN i) {
        this.writeRegister(i.r1, this.readIORegister(i.imm1));
    }

    public void visit(LegacyInstr.INC i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.JMP i) {
        this.jump(this.absolute(i.imm1));
    }

    public void visit(LegacyInstr.LD i) {
        this.writeRegister(i.r1, (byte)-1);
    }

    public void visit(LegacyInstr.LDD i) {
        this.writeRegister(i.r1, (byte)-1);
    }

    public void visit(LegacyInstr.LDI i) {
        this.writeRegister(i.r1, (byte)-1);
    }

    public void visit(LegacyInstr.LDPD i) {
        this.writeRegister(i.r1, (byte)-1);
        this.writeRegister(i.r2, (byte)-1);
        this.writeRegister(i.r2.nextRegister(), (byte)-1);
    }

    public void visit(LegacyInstr.LDPI i) {
        this.writeRegister(i.r1, (byte)-1);
        this.writeRegister(i.r2, (byte)-1);
        this.writeRegister(i.r2.nextRegister(), (byte)-1);
    }

    public void visit(LegacyInstr.LDS i) {
        this.writeRegister(i.r1, (byte)-1);
    }

    public void visit(LegacyInstr.LPM i) {
        this.readRegister(LegacyRegister.Z);
        this.readRegister(LegacyRegister.Z.nextRegister());
        this.writeRegister(LegacyRegister.R0, (byte)-1);
    }

    public void visit(LegacyInstr.LPMD i) {
        this.readRegister(LegacyRegister.Z);
        this.readRegister(LegacyRegister.Z.nextRegister());
        this.writeRegister(i.r1, (byte)-1);
    }

    public void visit(LegacyInstr.LPMPI i) {
        this.readRegister(LegacyRegister.Z);
        this.readRegister(LegacyRegister.Z.nextRegister());
        this.writeRegister(i.r1, (byte)-1);
        this.writeRegister(LegacyRegister.Z, (byte)-1);
        this.writeRegister(LegacyRegister.Z.nextRegister(), (byte)-1);
    }

    public void visit(LegacyInstr.LSL i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.LSR i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.MOV i) {
        this.writeRegister(i.r1, this.getRegister(i.r2));
    }

    public void visit(LegacyInstr.MOVW i) {
        this.writeRegister(i.r1, this.getRegister(i.r2));
        this.writeRegister(i.r1.nextRegister(), this.getRegister(i.r2.nextRegister()));
    }

    public void visit(LegacyInstr.MUL i) {
        this.mult(i.r1, i.r2);
    }

    public void visit(LegacyInstr.MULS i) {
        this.mult(i.r1, i.r2);
    }

    public void visit(LegacyInstr.MULSU i) {
        this.mult(i.r1, i.r2);
    }

    public void visit(LegacyInstr.NEG i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.NOP i) {
    }

    public void visit(LegacyInstr.OR i) {
        this.binop(i.r1, i.r2);
    }

    public void visit(LegacyInstr.ORI i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.OUT i) {
        this.writeIORegister(i.imm1, this.readRegister(i.r1));
    }

    public void visit(LegacyInstr.POP i) {
        this.writeRegister(i.r1, this.popByte());
    }

    public void visit(LegacyInstr.PUSH i) {
        this.pushByte(this.getRegister(i.r1));
    }

    public void visit(LegacyInstr.RCALL i) {
        int target = this.relative(i.imm1);
        ISEState rs = this.cache.getProcedureSummary(target);
        ISEState fs = this.processReturnState(this.state, rs);
        this.addToWorkList("RET", this.nextPC, fs);
        this.end();
    }

    private void end() {
        this.nextPC = -1;
    }

    public void visit(LegacyInstr.RET i) {
        this.postReturn(this.state);
        this.end();
    }

    public void visit(LegacyInstr.RETI i) {
        this.postReturnFromInterrupt(this.state);
        this.end();
    }

    public void visit(LegacyInstr.RJMP i) {
        this.jump(this.relative(i.imm1));
    }

    public void visit(LegacyInstr.ROL i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.ROR i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.SBC i) {
        this.binop(i.r1, i.r2);
    }

    public void visit(LegacyInstr.SBCI i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.SBI i) {
        this.writeIORegister(i.imm1, (byte)-1);
    }

    public void visit(LegacyInstr.SBIC i) {
        this.readIORegister(i.imm1);
        this.skip();
    }

    public void visit(LegacyInstr.SBIS i) {
        this.readIORegister(i.imm1);
        this.skip();
    }

    public void visit(LegacyInstr.SBIW i) {
        this.readRegister(i.r1);
        this.readRegister(i.r1.nextRegister());
        this.writeSREG((byte)-1);
        this.writeRegister(i.r1, (byte)-1);
        this.writeRegister(i.r1.nextRegister(), (byte)-1);
    }

    public void visit(LegacyInstr.SBR i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.SBRC i) {
        this.readRegister(i.r1);
        this.skip();
    }

    public void visit(LegacyInstr.SBRS i) {
        this.readRegister(i.r1);
        this.skip();
    }

    public void visit(LegacyInstr.SEC i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.SEH i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.SEI i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.SEN i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.SER i) {
        this.writeRegister(i.r1, (byte)-1);
    }

    public void visit(LegacyInstr.SES i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.SET i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.SEV i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.SEZ i) {
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.SLEEP i) {
    }

    public void visit(LegacyInstr.SPM i) {
        this.readRegister(LegacyRegister.R0);
        this.readRegister(LegacyRegister.R1);
        this.readRegister(LegacyRegister.Z);
        this.readRegister(LegacyRegister.Z.nextRegister());
    }

    public void visit(LegacyInstr.ST i) {
        this.readRegister(i.r1);
        this.readRegister(i.r1.nextRegister());
        this.readRegister(i.r2);
    }

    public void visit(LegacyInstr.STD i) {
        this.readRegister(i.r1);
        this.readRegister(i.r1.nextRegister());
        this.readRegister(i.r2);
    }

    public void visit(LegacyInstr.STPD i) {
        this.readRegister(i.r1);
        this.readRegister(i.r1.nextRegister());
        this.readRegister(i.r2);
        this.writeRegister(i.r1, (byte)-1);
        this.writeRegister(i.r1.nextRegister(), (byte)-1);
    }

    public void visit(LegacyInstr.STPI i) {
        this.readRegister(i.r1);
        this.readRegister(i.r1.nextRegister());
        this.readRegister(i.r2);
        this.writeRegister(i.r1, (byte)-1);
        this.writeRegister(i.r1.nextRegister(), (byte)-1);
    }

    public void visit(LegacyInstr.STS i) {
        this.readRegister(i.r1);
    }

    public void visit(LegacyInstr.SUB i) {
        this.binop(i.r1, i.r2);
    }

    public void visit(LegacyInstr.SUBI i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.SWAP i) {
        this.unop(i.r1);
    }

    public void visit(LegacyInstr.TST i) {
        this.readRegister(i.r1);
        this.writeSREG((byte)-1);
    }

    public void visit(LegacyInstr.WDR i) {
    }

    class Item {
        final int pc;
        final ISEState state;
        Item next;

        Item(int pc, ISEState s) {
            this.pc = pc;
            this.state = s;
        }
    }

    public static interface SummaryCache {
        public ISEState getProcedureSummary(int var1);

        public void recordReturnSummary(int var1, ISEState var2);
    }
}

