/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack.isea;

import avrora.core.ControlFlowGraph;
import avrora.core.ProcedureMap;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.stack.isea.ISEInterpreter;
import avrora.stack.isea.ISEState;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.text.Verbose;
import cck.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ISEAnalyzer
implements ISEInterpreter.SummaryCache {
    protected final Program program;
    protected final SourceMapping smap;
    protected final ControlFlowGraph cfg;
    protected final ProcedureMap pmap;
    protected final HashMap procedureSummaries;
    protected final HashMap returnSummaries;
    protected final Stack stack;
    protected final Verbose.Printer printer = Verbose.getVerbosePrinter("analysis.isea");

    public ISEAnalyzer(Program p) {
        this.program = p;
        this.smap = p.getSourceMapping();
        this.cfg = this.program.getCFG();
        this.pmap = this.cfg.getProcedureMap();
        this.procedureSummaries = new HashMap();
        this.returnSummaries = new HashMap();
        this.stack = new Stack();
    }

    public ISEState getProcedureSummary(int start) {
        ControlFlowGraph.Block block = this.cfg.getBlockStartingAt(start);
        if (block == null) {
            throw Util.failure("cannot get procedure summary for address: " + StringUtil.addrToString(start));
        }
        this.analyzeProcedure(block);
        return (ISEState)this.procedureSummaries.get(block);
    }

    public void recordReturnSummary(int retaddr, ISEState rs) {
        ISEState ors = this.getReturnSummary(retaddr);
        if (ors == null) {
            ors = rs.dup();
            this.returnSummaries.put(new Integer(retaddr), ors);
        } else {
            ors.merge(rs);
        }
    }

    public ISEState getReturnSummary(int retaddr) {
        return (ISEState)this.returnSummaries.get(new Integer(retaddr));
    }

    public void analyze() {
        Item head;
        HashSet<ControlFlowGraph.Block> seen = new HashSet<ControlFlowGraph.Block>();
        Item tail = head = new Item(this.cfg.getBlockStartingAt(0));
        while (head != null) {
            ControlFlowGraph.Block block = head.block;
            if (this.printer.enabled) {
                Terminal.println("looking at block " + this.getBlockName(block));
            }
            seen.add(block);
            if (this.pmap.getProcedureEntrypoints().contains(block)) {
                this.analyzeProcedure(block);
            } else {
                Iterator i = block.getEdgeIterator();
                while (i.hasNext()) {
                    ControlFlowGraph.Edge e = (ControlFlowGraph.Edge)i.next();
                    ControlFlowGraph.Block target = e.getTarget();
                    tail = this.addToWorkList(seen, target, tail);
                }
                int lastAddr = block.getLastAddress();
                List list = this.program.getIndirectEdges(lastAddr);
                if (list != null) {
                    Iterator iei = list.iterator();
                    while (iei.hasNext()) {
                        int taddr = (Integer)iei.next();
                        tail = this.addToWorkList(seen, this.cfg.getBlockStartingAt(taddr), tail);
                    }
                }
            }
            head = head.next;
        }
    }

    private Item addToWorkList(HashSet seen, ControlFlowGraph.Block target, Item tail) {
        if (target == null) {
            return tail;
        }
        if (!seen.contains(target)) {
            tail = tail.next = new Item(target);
        }
        return tail;
    }

    public void analyzeProcedure(ControlFlowGraph.Block start) {
        if (this.procedureSummaries.containsKey(start)) {
            return;
        }
        if (this.printer.enabled) {
            this.printStart(start);
        }
        if (this.stack.contains(start)) {
            throw Util.failure("program contains recursion");
        }
        this.stack.push(start);
        ISEState rs = new ISEInterpreter(this.program, this).analyze(start.getAddress());
        this.procedureSummaries.put(start, rs);
        this.stack.pop();
    }

    private void printStart(ControlFlowGraph.Block start) {
        int size = this.stack.size();
        String indent = StringUtil.dup('=', 4 * size + 3);
        Terminal.print(13, indent + ">");
        Terminal.print(5, " ISE: Analyzing procedure ");
        Terminal.printBrightCyan(this.getBlockName(start));
        Terminal.nextln();
    }

    private String getBlockName(ControlFlowGraph.Block start) {
        int address = start.getAddress();
        return "(" + this.smap.getName(address) + ": " + StringUtil.addrToString(address) + ")";
    }

    public void analyze(int loc) {
        ISEState s = new ISEInterpreter(this.program, this).analyze(loc);
        TermUtil.printSeparator();
        if (s != null) {
            Terminal.printRed("RETURN STATE");
            Terminal.nextln();
            s.print(loc);
        } else {
            Terminal.printRed("PROCEDURE DOES NOT RETURN");
            Terminal.nextln();
        }
    }

    class Item {
        ControlFlowGraph.Block block;
        Item next;

        Item(ControlFlowGraph.Block b) {
            this.block = b;
        }
    }
}

