/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack.isea;

import avrora.stack.isea.ISEValue;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Util;

public class ISEAbstractState {
    final Element[] elements;
    final byte[] stack;
    int depth;

    public void merge(ISEAbstractState s) {
        int cntr;
        if (this.depth != s.depth) {
            throw Util.failure("stack height mismatch");
        }
        for (cntr = 0; cntr < this.elements.length; ++cntr) {
            this.elements[cntr].read = this.elements[cntr].read || s.elements[cntr].read;
            this.elements[cntr].value = ISEValue.merge(this.elements[cntr].value, s.elements[cntr].value);
        }
        for (cntr = 0; cntr < this.depth; ++cntr) {
            this.stack[cntr] = ISEValue.merge(this.stack[cntr], s.stack[cntr]);
        }
    }

    public boolean equals(Object o) {
        int cntr;
        if (!(o instanceof ISEAbstractState)) {
            return false;
        }
        ISEAbstractState s = (ISEAbstractState)o;
        if (this.depth != s.depth) {
            return false;
        }
        for (cntr = 0; cntr < this.elements.length; ++cntr) {
            if (this.elements[cntr].read != s.elements[cntr].read) {
                return false;
            }
            if (this.elements[cntr].value == s.elements[cntr].value) continue;
            return false;
        }
        for (cntr = 0; cntr < this.depth; ++cntr) {
            if (this.stack[cntr] == s.stack[cntr]) continue;
            return false;
        }
        return true;
    }

    public ISEAbstractState copy() {
        return new ISEAbstractState(this.elements, this.stack, this.depth);
    }

    public void push(byte val) {
        this.stack[this.depth++] = val;
    }

    public byte pop() {
        return this.stack[--this.depth];
    }

    public void print(int pc) {
        int cntr;
        Terminal.print(StringUtil.addrToString(pc) + ": ");
        for (cntr = 0; cntr < this.elements.length; ++cntr) {
            Element e = this.elements[cntr];
            String star = e.read ? "*" : "";
            String str = star + ISEValue.toString(e.value);
            Terminal.print(StringUtil.rightJustify(str, 4));
            if (cntr % 16 != 15) continue;
            this.nextln();
        }
        this.nextln();
        Terminal.print("(");
        for (cntr = this.depth; cntr > 0; --cntr) {
            Terminal.print(ISEValue.toString(this.stack[cntr - 1]));
            if (cntr <= 1) continue;
            Terminal.print(", ");
        }
        Terminal.print(")");
        Terminal.nextln();
    }

    protected void nextln() {
        Terminal.print("\n        ");
    }

    public byte readElement(int element) {
        this.elements[element].read = true;
        return this.elements[element].value;
    }

    public byte getElement(int element) {
        return this.elements[element].value;
    }

    public void writeElement(int element, byte val) {
        this.elements[element].value = val;
    }

    public boolean isRead(int element) {
        return this.elements[element].read;
    }

    public ISEAbstractState(Element[] e, byte[] nstack, int ndepth) {
        this.elements = new Element[e.length];
        for (int cntr = 0; cntr < e.length; ++cntr) {
            Element et = e[cntr];
            this.elements[cntr] = new Element(et.name, et.value, et.read);
        }
        this.stack = new byte[nstack.length];
        System.arraycopy(nstack, 0, this.stack, 0, ndepth);
        this.depth = ndepth;
    }

    public static class Element {
        public final String name;
        boolean read;
        byte value;

        public Element(String n, byte val, boolean r) {
            this.name = n;
            this.value = val;
            this.read = r;
        }

        public Element copy() {
            return new Element(this.name, this.value, this.read);
        }
    }
}

