/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack;

import avrora.core.Program;
import avrora.stack.AbstractArithmetic;
import avrora.stack.AbstractInterpreter;
import avrora.stack.Analyzer;
import avrora.stack.MutableState;
import avrora.stack.StateCache;
import cck.text.Printer;
import cck.text.StringUtil;
import cck.util.Util;
import java.util.Iterator;

public class StateTransitionGraph {
    private StateList frontierList;
    private StateCache cache;
    private long edgeCount;
    private long frontierCount;
    private long exploredCount;
    private final StateCache.State edenState;

    public StateTransitionGraph(Program p) {
        this.cache = new StateCache(p);
        this.edenState = this.cache.getEdenState();
        this.edenState.info = new StateInfo(this.edenState);
        this.addFrontierState(this.edenState);
    }

    public StateCache.State getCachedState(MutableState s) {
        StateCache.State ns = this.cache.getStateFor(s);
        if (ns.info == null) {
            ns.info = new StateInfo(ns);
        }
        return ns;
    }

    public Edge addEdge(StateCache.State s, int type, int weight, StateCache.State t) {
        if (s.info == null) {
            throw Util.failure("No edge info for: " + s.getUniqueName());
        }
        if (t.info == null) {
            throw Util.failure("No edge info for: " + t.getUniqueName());
        }
        ++this.edgeCount;
        return s.info.addEdge(type, weight, t);
    }

    public StateCache.State getNextFrontierState() {
        if (this.frontierList == null) {
            return null;
        }
        StateList l = this.frontierList;
        this.frontierList = this.frontierList.next;
        StateCache.State state = l.state;
        if (state.info == null) {
            throw Util.failure("LegacyState on frontier has no edge info: " + state.getUniqueName());
        }
        state.onFrontier = false;
        --this.frontierCount;
        return state;
    }

    public void addFrontierState(StateCache.State s) {
        if (this.isExplored(s)) {
            throw Util.failure("Attempt to re-add state to frontier: " + s.getUniqueName());
        }
        if (!this.isFrontier(s)) {
            this.frontierList = new StateList(s, this.frontierList);
            s.onFrontier = true;
            ++this.frontierCount;
        }
    }

    public boolean isExplored(StateCache.State s) {
        return s.isExplored;
    }

    public void setExplored(StateCache.State s) {
        if (this.isFrontier(s)) {
            throw Util.failure("state cannot be on frontier and explored: " + s.getUniqueName());
        }
        if (!this.isExplored(s)) {
            s.isExplored = true;
            ++this.exploredCount;
        }
    }

    public boolean isFrontier(StateCache.State s) {
        return s.onFrontier;
    }

    public StateCache getStateCache() {
        return this.cache;
    }

    public StateCache.State getEdenState() {
        return this.edenState;
    }

    public long getFrontierCount() {
        return this.frontierCount;
    }

    public long getEdgeCount() {
        return this.edgeCount;
    }

    public long getExploredCount() {
        return this.exploredCount;
    }

    public StateCache.Set newSet() {
        return this.cache.newSet();
    }

    public void deleteStateSets() {
        Iterator i = this.cache.getStateIterator();
        while (i.hasNext()) {
            StateCache.State state = (StateCache.State)i.next();
            state.info.stateSet = null;
        }
    }

    public void dump(Printer p) {
        StateCache.State state;
        Iterator i = this.cache.getStateIterator();
        while (i.hasNext()) {
            state = (StateCache.State)i.next();
            StringBuffer buf = this.dumpToBuffer(state);
            p.println(buf.toString());
        }
        i = this.cache.getStateIterator();
        while (i.hasNext()) {
            state = (StateCache.State)i.next();
            Edge e = state.info.forwardEdges;
            while (e != null) {
                StringBuffer buf = this.dumpToBuffer(e);
                p.println(buf.toString());
                e = e.forwardLink;
            }
        }
    }

    private StringBuffer dumpToBuffer(Edge e) {
        StringBuffer buf = new StringBuffer(32);
        buf.append('[');
        buf.append(e.source.getUniqueName());
        buf.append("] --(");
        buf.append(Analyzer.EDGE_NAMES[e.type]);
        buf.append(',');
        buf.append(e.weight);
        buf.append(")--> [");
        buf.append(e.target.getUniqueName());
        buf.append(']');
        return buf;
    }

    private StringBuffer dumpToBuffer(StateCache.State state) {
        StringBuffer buf = new StringBuffer(300);
        buf.append('[');
        buf.append(state.getUniqueName());
        buf.append(':');
        buf.append(state.getType());
        buf.append("] PC=");
        buf.append(StringUtil.addrToString(state.getPC()));
        buf.append(" SREG=");
        buf.append(AbstractArithmetic.toString(state.getSREG()));
        buf.append(" EIMSK=");
        buf.append(AbstractArithmetic.toString(state.getIORegisterAV(57)));
        buf.append(" TIMSK=");
        buf.append(AbstractArithmetic.toString(state.getIORegisterAV(55)));
        for (int cntr = 0; cntr < 32; ++cntr) {
            buf.append(' ');
            buf.append(AbstractInterpreter.toShortString(state.getRegisterAV(cntr)));
        }
        return buf;
    }

    public static class StateInfo {
        public final StateCache.State state;
        public StateCache.Set stateSet;
        public Edge forwardEdges;
        public Edge backwardEdges;

        StateInfo(StateCache.State s) {
            this.state = s;
        }

        public Edge addEdge(int type, int weight, StateCache.State target) {
            Edge nedge;
            this.forwardEdges = nedge = new Edge(this.state, target, this.forwardEdges, target.info.backwardEdges, type, weight);
            target.info.backwardEdges = nedge;
            return nedge;
        }
    }

    public static class Edge {
        public final StateCache.State source;
        public final StateCache.State target;
        public final Edge forwardLink;
        public final Edge backwardLink;
        public final int type;
        public final int weight;

        Edge(StateCache.State source, StateCache.State target, Edge fl, Edge bl, int type, int weight) {
            this.source = source;
            this.target = target;
            this.forwardLink = fl;
            this.backwardLink = bl;
            this.type = type;
            this.weight = weight;
        }
    }

    public static class EdgeList {
        public final Edge edge;
        public final EdgeList next;

        EdgeList(Edge tar, EdgeList n) {
            this.edge = tar;
            this.next = n;
        }
    }

    public static class StateList {
        public final StateCache.State state;
        public final StateList next;

        StateList(StateCache.State tar, StateList n) {
            this.state = tar;
            this.next = n;
        }
    }
}

