/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack;

import avrora.stack.AbstractArithmetic;
import avrora.stack.Analyzer;
import avrora.stack.StateCache;
import cck.text.StringUtil;
import cck.text.Terminal;

public class StatePrinter {
    public static void printEdge(StateCache.State s, int type, int weight, StateCache.State t) {
        StatePrinter.printStateName(s);
        Terminal.print(" --(");
        Terminal.print(Analyzer.EDGE_NAMES[type]);
        if (weight > 0) {
            Terminal.print("+");
        }
        Terminal.print(weight + ")--> ");
        StatePrinter.printStateName(t);
        Terminal.nextln();
    }

    public static void printEdge(int type, int weight, StateCache.State t) {
        Terminal.print("--(");
        Terminal.print(Analyzer.EDGE_NAMES[type]);
        if (weight > 0) {
            Terminal.print("+");
        }
        Terminal.print(weight + ")--> ");
        StatePrinter.printStateName(t);
        Terminal.nextln();
    }

    public static void printStateName(StateCache.State t) {
        Terminal.print("[");
        Terminal.printBrightGreen(StringUtil.toHex(t.getPC(), 4));
        Terminal.print("|");
        Terminal.printBrightCyan(t.getUniqueName());
        Terminal.print("] ");
    }

    public static void printState(String beg, StateCache.State s) {
        Terminal.printBrightRed(beg);
        StatePrinter.printStateName(s);
        for (int cntr = 0; cntr < 8; ++cntr) {
            Terminal.print(StatePrinter.toString(s.getRegisterAV(cntr)));
            Terminal.print(" ");
        }
        Terminal.nextln();
        StatePrinter.printStateLine(s, "SREG", 63, 8);
        StatePrinter.printStateLine(s, "EIMSK", 57, 16);
        StatePrinter.printStateLine(s, "TIMSK", 55, 24);
    }

    public static void printStateLine(StateCache.State s, String ior_name, int ior_num, int cntr) {
        int max = cntr + 8;
        StatePrinter.printIOReg(ior_name, s.getIORegisterAV(ior_num));
        while (cntr < max) {
            Terminal.print(StatePrinter.toString(s.getRegisterAV(cntr)));
            Terminal.print(" ");
            ++cntr;
        }
        Terminal.nextln();
    }

    public static void printIOReg(String name, char val) {
        String l = StringUtil.rightJustify("[", 21 - name.length());
        Terminal.print(l);
        Terminal.printBrightGreen(name);
        Terminal.print(":");
        Terminal.print(AbstractArithmetic.toString(val));
        Terminal.print("] ");
    }

    public static String toString(char av) {
        if (av == '\uff00') {
            return "       0";
        }
        if (av == '\u0000') {
            return "       .";
        }
        return AbstractArithmetic.toString(av);
    }
}

