/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack;

import avrora.core.Program;
import avrora.stack.AbstractState;
import avrora.stack.IORegisterConstants;
import avrora.stack.MutableState;
import avrora.stack.StateTransitionGraph;
import cck.text.StringUtil;
import cck.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class StateCache {
    private long uidCount;
    private HashMap stateMap;
    private final State edenState;
    private final Program program;
    private long totalStateCount;

    public StateCache(Program p) {
        this.stateMap = new HashMap(p.program_end * 5);
        this.edenState = this.getStateFor(new MutableState());
        this.program = p;
    }

    public State getEdenState() {
        return this.edenState;
    }

    public State getStateFor(MutableState s) {
        State is = new State(s);
        State cs = (State)this.stateMap.get(is);
        if (cs != null) {
            return cs;
        }
        ++this.totalStateCount;
        this.stateMap.put(is, is);
        return is;
    }

    public long getTotalStateCount() {
        return this.totalStateCount;
    }

    public Iterator getStateIterator() {
        return this.stateMap.values().iterator();
    }

    public Set newSet() {
        return new Set();
    }

    public class Set {
        private State oneState;
        private HashSet delegate;
        private boolean delegating = false;
        private boolean empty = true;

        public int size() {
            if (this.delegating) {
                return this.delegate.size();
            }
            return this.oneState == null ? 0 : 1;
        }

        public boolean isEmpty() {
            if (this.delegating) {
                return false;
            }
            return this.oneState != null;
        }

        public boolean contains(Object o) {
            if (this.delegating) {
                return this.delegate.contains(o);
            }
            return this.oneState == o;
        }

        public Iterator iterator() {
            if (this.delegating) {
                return this.delegate.iterator();
            }
            return new OptionalIterator();
        }

        public boolean add(State ns) {
            this.empty = false;
            if (this.delegating) {
                return this.delegate.add(ns);
            }
            if (this.oneState == null) {
                this.oneState = ns;
                return false;
            }
            if (ns == this.oneState) {
                return true;
            }
            this.beginDelegation();
            return this.delegate.add(ns);
        }

        private void beginDelegation() {
            this.delegate = new HashSet();
            if (this.oneState != null) {
                this.delegate.add(this.oneState);
            } else {
                this.oneState = null;
            }
            this.delegating = true;
        }

        public boolean containsAll(Set oset) {
            if (oset.empty) {
                return true;
            }
            if (this.empty) {
                return false;
            }
            if (this.delegating) {
                if (oset.delegating) {
                    return this.delegate.containsAll(oset.delegate);
                }
                return this.delegate.contains(oset.oneState);
            }
            if (oset.delegating) {
                return false;
            }
            return this.oneState == oset.oneState || oset.oneState == null;
        }

        public boolean addAll(Set oset) {
            if (oset.empty) {
                return true;
            }
            this.empty = false;
            if (this.delegating) {
                if (oset.delegating) {
                    return this.delegate.addAll(oset.delegate);
                }
                return this.delegate.add(oset.oneState);
            }
            this.beginDelegation();
            if (oset.delegating) {
                return this.delegate.addAll(oset.delegate);
            }
            return this.delegate.add(oset.oneState);
        }

        private class OptionalIterator
        implements Iterator {
            boolean done;

            private OptionalIterator() {
            }

            public boolean hasNext() {
                return !this.done && Set.this.oneState != null;
            }

            public Object next() {
                this.done = true;
                return Set.this.oneState;
            }

            public void remove() {
                throw Util.unimplemented();
            }
        }
    }

    public class State
    extends AbstractState
    implements IORegisterConstants {
        private final int hashCode;
        private int type;
        public final long UID;
        boolean isExplored;
        boolean onFrontier;
        public Object mark;
        public StateTransitionGraph.StateInfo info;

        State(MutableState s) {
            this.pc = s.pc;
            this.av_SREG = s.av_SREG;
            this.av_EIMSK = s.av_EIMSK;
            this.av_TIMSK = s.av_TIMSK;
            this.av_REGISTERS = new char[32];
            System.arraycopy(s.av_REGISTERS, 0, this.av_REGISTERS, 0, 32);
            this.hashCode = this.computeHashCode();
            this.UID = StateCache.this.uidCount++;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            return this.deepCompare((State)o);
        }

        public String getUniqueName() {
            return StringUtil.toHex(this.UID, 10);
        }

        public void setType(int t) {
            this.type = t;
        }

        public int getType() {
            return this.type;
        }
    }
}

