/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack;

import avrora.arch.legacy.LegacyRegister;
import avrora.stack.AbstractArithmetic;
import avrora.stack.AbstractState;
import avrora.stack.IORegisterConstants;
import cck.util.Util;

public class MutableState
extends AbstractState
implements IORegisterConstants {
    public MutableState() {
        this.av_SREG = (char)65280;
        this.av_EIMSK = (char)65280;
        this.av_TIMSK = (char)65280;
        for (int cntr = 0; cntr < 32; ++cntr) {
            this.av_REGISTERS[cntr] = 65280;
        }
    }

    public MutableState(int npc, char nSREG, char nEIMSK, char nTIMSK, char[] nregs) {
        this.av_REGISTERS = new char[32];
        System.arraycopy(nregs, 0, this.av_REGISTERS, 0, 32);
        this.pc = npc;
        this.av_SREG = nSREG;
        this.av_EIMSK = nEIMSK;
        this.av_TIMSK = nTIMSK;
    }

    public MutableState merge(MutableState s) {
        if (this.pc != s.pc) {
            throw Util.failure("cannot merge abstract states with different program counters");
        }
        MutableState n = this.copy();
        n.av_SREG = AbstractArithmetic.merge(this.av_SREG, s.av_SREG);
        for (int cntr = 0; cntr < 32; ++cntr) {
            n.av_REGISTERS[cntr] = AbstractArithmetic.merge(this.av_REGISTERS[cntr], s.av_REGISTERS[cntr]);
        }
        return n;
    }

    public int hashCode() {
        throw Util.failure("cannot compute hash code of MutableState");
    }

    public boolean equals(Object o) {
        throw Util.failure("cannot perform .equals() on MutableState");
    }

    public void setPC(int npc) {
        this.pc = npc;
    }

    public void writeSREG(char val) {
        this.av_SREG = AbstractArithmetic.canon(val);
    }

    public void setSREG_bit(int bit, char val) {
        this.av_SREG = AbstractArithmetic.setBit(this.av_SREG, bit, val);
    }

    public void setFlag_I(char val) {
        this.setSREG_bit(7, val);
    }

    public void setFlag_T(char val) {
        this.setSREG_bit(6, val);
    }

    public void setFlag_H(char val) {
        this.setSREG_bit(5, val);
    }

    public void setFlag_S(char val) {
        this.setSREG_bit(4, val);
    }

    public void setFlag_V(char val) {
        this.setSREG_bit(3, val);
    }

    public void setFlag_N(char val) {
        this.setSREG_bit(2, val);
    }

    public void setFlag_Z(char val) {
        this.setSREG_bit(1, val);
    }

    public void setFlag_C(char val) {
        this.setSREG_bit(0, val);
    }

    public void setIORegisterAV(int num, char val) {
        if (num == 63) {
            this.av_SREG = val;
        }
        if (num == 57) {
            this.av_EIMSK = val;
        }
        if (num == 55) {
            this.av_TIMSK = val;
        }
    }

    public void setRegisterAV(LegacyRegister r, char val) {
        this.av_REGISTERS[r.getNumber()] = AbstractArithmetic.canon(val);
    }
}

