/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack;

import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyRegister;
import avrora.core.Program;
import avrora.stack.AbstractInterpreter;
import avrora.stack.AnalyzerPolicy;
import avrora.stack.MutableState;
import avrora.stack.StateCache;
import avrora.stack.StatePrinter;
import avrora.stack.StateTransitionGraph;
import avrora.stack.isea.ISEAnalyzer;
import avrora.stack.isea.ISEState;
import avrora.stack.isea.ISEValue;
import cck.stat.Distribution;
import cck.text.Printer;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.text.Verbose;
import cck.util.TimeUtil;
import cck.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Analyzer {
    public static boolean MONITOR_STATES;
    public static boolean TRACE_SUMMARY;
    public static boolean USE_ISEA;
    public static boolean SHOW_PATH;
    protected final Verbose.Printer printer = Verbose.getVerbosePrinter("analyzer.stack");
    protected final Program program;
    protected final StateTransitionGraph graph;
    final ContextSensitivePolicy policy;
    final AbstractInterpreter interpreter;
    protected int retCount;
    protected int retiCount;
    protected int newRetCount;
    protected int newEdgeCount;
    protected StateTransitionGraph.StateList newReturnStates;
    protected StateTransitionGraph.EdgeList newEdges;
    long buildTime;
    long traverseTime;
    boolean unbounded;
    Path maximalPath;
    ISEAnalyzer isea;
    public static final int NORMAL_EDGE = 0;
    public static final int PUSH_EDGE = 1;
    public static final int POP_EDGE = 2;
    public static final int CALL_EDGE = 3;
    public static final int INT_EDGE = 4;
    public static final int RET_EDGE = 5;
    public static final int RETI_EDGE = 6;
    public static final int SPECIAL_EDGE = 7;
    public static final int NORMAL_STATE = 0;
    public static final int RET_STATE = 1;
    public static final int RETI_STATE = 2;
    public static final String[] EDGE_NAMES;
    public static final int[] EDGE_DELTA;
    public static boolean TRACE;
    public static boolean running;
    public static byte[] reserve;
    private long numSets;
    private long numElems;

    public Analyzer(Program p) {
        this.program = p;
        this.graph = new StateTransitionGraph(p);
        this.policy = new ContextSensitivePolicy();
        this.interpreter = new AbstractInterpreter(this.program, this.policy);
        if (USE_ISEA) {
            this.isea = new ISEAnalyzer(this.program);
            this.isea.analyze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        running = true;
        MonitorThread t = null;
        if (MONITOR_STATES) {
            t = new MonitorThread();
            t.start();
        }
        long start = System.currentTimeMillis();
        try {
            this.buildReachableStateSpace();
            long check = System.currentTimeMillis();
            this.buildTime = check - start;
            this.findMaximalPath();
            this.traverseTime = System.currentTimeMillis() - check;
        }
        catch (OutOfMemoryError ome) {
            reserve = null;
            long check = System.currentTimeMillis();
            this.buildTime = check - start;
            this.outOfMemory();
            this.graph.deleteStateSets();
        }
        finally {
            running = false;
        }
    }

    private void outOfMemory() {
        running = false;
        Terminal.nextln();
        Terminal.printRed("Stack Analyzer Error");
        Terminal.println(": out of memory");
        this.printStatHeader();
        this.printStats();
        this.analyzeAggregationPoints();
        this.analyzeStates();
    }

    private void analyzeAggregationPoints() {
        Iterator i = this.graph.getStateCache().getStateIterator();
        Distribution sizeDist = new Distribution("Set Size Statistics", "Number of sets", "Aggregate size", "Distribution of Set Size");
        while (i.hasNext()) {
            StateCache.State state = (StateCache.State)i.next();
            StateCache.Set stateSet = state.info.stateSet;
            int size = stateSet == null ? 0 : stateSet.size();
            sizeDist.record(size);
        }
        sizeDist.process();
        sizeDist.print(this.printer);
    }

    private void analyzeStates() {
        Iterator i = this.graph.getStateCache().getStateIterator();
        Distribution pcDist = new Distribution("Distribution of program states over PC", "Number of unique instructions", null, "Distribution");
        while (i.hasNext()) {
            StateCache.State s = (StateCache.State)i.next();
            pcDist.record(s.getPC());
        }
        pcDist.process();
        pcDist.print(this.printer);
    }

    private void printStats() {
        this.print_just_9(this.graph.getFrontierCount());
        this.print_just_9(this.graph.getExploredCount());
        this.print_just_9(this.graph.getEdgeCount());
        this.countAggregElems();
        this.print_just_9(this.numSets);
        this.print_just_12(this.numElems);
        String s = Long.toString(this.retCount) + '/' + Long.toString(this.retiCount);
        Terminal.print(StringUtil.rightJustify(s, 12));
        this.print_just_9(this.newRetCount);
        this.print_just_9(this.newEdgeCount);
        Terminal.nextln();
    }

    private void countAggregElems() {
        this.numElems = 0L;
        this.numSets = 0L;
    }

    private void printStatHeader() {
        Terminal.printBrightGreen(" Frontier Explored    Edges   Aggreg       Elems      ret(i)   Pend-R   Pend-E");
        Terminal.nextln();
        TermUtil.printSeparator(88);
    }

    private void print_just_9(long val) {
        String s = StringUtil.rightJustify(val, 9);
        Terminal.print(s);
    }

    private void print_just_12(long val) {
        String s = StringUtil.rightJustify(val, 12);
        Terminal.print(s);
    }

    protected void buildReachableStateSpace() {
        StateCache.State s = this.graph.getNextFrontierState();
        while (true) {
            if (s != null) {
                this.processFrontierState(s);
            } else if (this.newReturnStates != null) {
                this.processNewReturns();
            } else {
                if (this.newEdges == null) break;
                this.processNewEdges();
            }
            s = this.graph.getNextFrontierState();
        }
    }

    protected void processNewReturns() {
        while (this.newReturnStates != null) {
            StateCache.State state = this.newReturnStates.state;
            this.propagateOneBackwards(state, state, state.copy(), new Object());
            this.newReturnStates = this.newReturnStates.next;
            --this.newRetCount;
        }
    }

    protected void processNewEdges() {
        while (this.newEdges != null) {
            StateTransitionGraph.Edge edge = this.newEdges.edge;
            this.newEdges = this.newEdges.next;
            StateCache.Set set = edge.target.info.stateSet;
            if (set != null && !set.isEmpty()) {
                this.propagateSetBackwards(edge.source, edge.target.info.stateSet, new Object());
            }
            --this.newEdgeCount;
        }
    }

    private void propagateOneBackwards(StateCache.State t, StateCache.State rt, MutableState copy, Object mark) {
        if (t.mark == mark) {
            return;
        }
        t.mark = mark;
        StateTransitionGraph.StateInfo info = t.info;
        if (info.stateSet == null) {
            info.stateSet = this.graph.newSet();
        } else if (info.stateSet.contains(rt)) {
            return;
        }
        info.stateSet.add(rt);
        StateTransitionGraph.Edge edge = info.backwardEdges;
        while (edge != null) {
            if (edge.type == 3) {
                this.insertReturnEdge(edge.source, copy, rt.getType() == 2);
            } else {
                this.propagateOneBackwards(edge.source, rt, copy, mark);
            }
            edge = edge.backwardLink;
        }
    }

    private void propagateSetBackwards(StateCache.State t, StateCache.Set rset, Object mark) {
        if (t.mark == mark) {
            return;
        }
        t.mark = mark;
        StateTransitionGraph.StateInfo info = t.info;
        if (info.stateSet == null) {
            info.stateSet = this.graph.newSet();
        } else if (info.stateSet.containsAll(rset)) {
            return;
        }
        StateTransitionGraph.Edge edge = info.backwardEdges;
        while (edge != null) {
            if (edge.type == 3) {
                this.insertReturnEdges(edge.source, edge.target.info.stateSet, rset);
            } else {
                this.propagateSetBackwards(edge.source, rset, mark);
            }
            edge = edge.backwardLink;
        }
        info.stateSet.addAll(rset);
    }

    private void insertReturnEdges(StateCache.State caller, StateCache.Set prev, StateCache.Set rset) {
        Iterator i = rset.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (prev.contains(o)) continue;
            StateCache.State rs = (StateCache.State)o;
            this.insertReturnEdge(caller, rs.copy(), rs.getType() == 2);
        }
    }

    private void insertReturnEdge(StateCache.State caller, MutableState rstate, boolean reti) {
        int npc;
        ISEState rs;
        int cpc = caller.getPC();
        if (this.isea != null && (rs = this.isea.getReturnSummary(rstate.getPC())) != null) {
            this.mergeReturnStateIntoCaller(caller, rstate, rs);
        }
        if (reti) {
            npc = cpc;
            rstate.setFlag_I('\u0101');
        } else {
            npc = this.program.getNextPC(cpc);
        }
        rstate.setPC(npc);
        int type = reti ? 6 : 5;
        this.policy.addEdge(caller, type, rstate);
    }

    private void mergeReturnStateIntoCaller(StateCache.State caller, MutableState rstate, ISEState rs) {
        for (int cntr = 0; cntr < 32; ++cntr) {
            LegacyRegister reg = LegacyRegister.getRegisterByNumber(cntr);
            char retval = rstate.getRegisterAV(reg);
            char av = this.interpret(caller, rs.getRegister(reg), retval);
            rstate.setRegisterAV(reg, av);
        }
        this.mergeReturnIORegister(63, caller, rstate, rs);
        this.mergeReturnIORegister(57, caller, rstate, rs);
        this.mergeReturnIORegister(55, caller, rstate, rs);
    }

    private void mergeReturnIORegister(int ior, StateCache.State caller, MutableState rstate, ISEState rs) {
        char retval = rstate.getIORegisterAV(ior);
        char av = this.interpret(caller, rs.readIORegister(ior), retval);
        rstate.setIORegisterAV(ior, av);
    }

    private char interpret(StateCache.State caller, byte rsval, char defval) {
        LegacyRegister reg = ISEValue.asRegister(rsval);
        if (reg != null) {
            return caller.getRegisterAV(reg);
        }
        int ior = ISEValue.asIORegister(rsval);
        if (ior > 0) {
            return caller.getIORegisterAV(ior);
        }
        return defval;
    }

    private void postNewEdge(StateTransitionGraph.Edge edge) {
        this.newEdges = new StateTransitionGraph.EdgeList(edge, this.newEdges);
        ++this.newEdgeCount;
    }

    private void processFrontierState(StateCache.State s) {
        this.traceState(s);
        this.policy.frontierState = s;
        this.policy.edgeType = 0;
        this.graph.setExplored(s);
        this.interpreter.computeNextStates(s);
    }

    private void findMaximalPath() {
        HashMap stack = new HashMap(1000);
        StateCache.State state = this.graph.getEdenState();
        try {
            this.maximalPath = this.findMaximalPath(state, stack, 0);
        }
        catch (UnboundedStackException e) {
            this.unbounded = true;
            this.maximalPath = e.path;
        }
    }

    protected Path findMaximalPath(StateCache.State s, HashMap stack, int depth) throws UnboundedStackException {
        stack.put(s, new Integer(depth));
        int maxdepth = 0;
        int minlength = Integer.MAX_VALUE;
        Path maxtail = null;
        StateTransitionGraph.Edge maxedge = null;
        StateTransitionGraph.Edge edge = s.info.forwardEdges;
        while (edge != null) {
            StateCache.State t = edge.target;
            if (stack.containsKey(t)) {
                int prevdepth = (Integer)stack.get(t);
                if (depth + edge.weight != prevdepth) {
                    stack.remove(s);
                    throw new UnboundedStackException(new Path(depth + edge.weight, edge, null));
                }
            } else {
                Path tail;
                if (edge.target.mark instanceof Path) {
                    tail = (Path)edge.target.mark;
                } else {
                    try {
                        tail = this.findMaximalPath(edge.target, stack, depth + edge.weight);
                    }
                    catch (UnboundedStackException e) {
                        e.path = new Path(depth + edge.weight, edge, e.path);
                        stack.remove(s);
                        throw e;
                    }
                }
                int extra = edge.weight + tail.depth;
                if (extra > maxdepth || tail.length < minlength && extra == maxdepth) {
                    maxdepth = extra;
                    maxtail = tail;
                    maxedge = edge;
                    minlength = tail.length;
                }
            }
            edge = edge.forwardLink;
        }
        stack.remove(s);
        Path maxpath = new Path(maxdepth, maxedge, maxtail);
        s.mark = maxpath;
        return maxpath;
    }

    public void report() {
        this.printStatHeader();
        this.printStats();
        this.printQuantity("Time to build graph   ", TimeUtil.milliToSecs(this.buildTime));
        if (this.maximalPath == null) {
            Terminal.printRed("No maximal path data.");
            Terminal.nextln();
            return;
        }
        this.printQuantity("Time to traverse graph", TimeUtil.milliToSecs(this.traverseTime));
        if (this.unbounded) {
            this.printQuantity("Maximum stack depth   ", "unbounded");
        } else {
            this.printQuantity("Maximum stack depth   ", "" + this.maximalPath.depth + " bytes");
        }
        if (SHOW_PATH) {
            this.printPath(this.maximalPath);
        }
    }

    public void dump() {
        this.graph.dump(Printer.STDOUT);
    }

    /*
     * Unable to fully structure code
     */
    private void printPath(Path p) {
        depth = 0;
        cntr = 1;
        path = p;
        while (path != null && path.edge != null) {
            edge = path.edge;
            if (cntr <= true || !Analyzer.TRACE_SUMMARY || edge.weight != 0) ** GOTO lbl-1000
            pc = edge.source.getPC();
            if (edge.target.getPC() == this.program.getNextPC(pc)) {
                ++cntr;
            } else lbl-1000:
            // 2 sources

            {
                this.printFullState("[" + cntr + "] Depth: " + depth, edge.source);
                Terminal.print("    ");
                StatePrinter.printEdge(edge.type, edge.weight, edge.target);
                depth += edge.weight;
                ++cntr;
            }
            path = path.tail;
        }
    }

    private void printQuantity(String q, String v) {
        Terminal.printBrightGreen(q);
        Terminal.println(": " + v);
    }

    private void postReturnState(StateCache.State rs) {
        this.newReturnStates = new StateTransitionGraph.StateList(rs, this.newReturnStates);
        ++this.newRetCount;
    }

    private void maskIrrelevantState(MutableState s, ISEState rs) {
        for (int cntr = 0; cntr < 32; ++cntr) {
            LegacyRegister reg = LegacyRegister.getRegisterByNumber(cntr);
            if (rs.isRegisterRead(reg)) continue;
            s.setRegisterAV(reg, '\u0000');
        }
    }

    private void maskIORegister(int ior, MutableState s, ISEState rs) {
        if (!rs.isIORegisterRead(ior)) {
            s.setIORegisterAV(ior, '\u0000');
        }
    }

    private void traceState(StateCache.State s) {
        if (TRACE) {
            this.printFullState("Exploring", s);
        }
    }

    private void printFullState(String head, StateCache.State s) {
        Terminal.print(head + ' ');
        StatePrinter.printStateName(s);
        Terminal.nextln();
        LegacyInstr instr = (LegacyInstr)this.program.readInstr(s.getPC());
        String str = StringUtil.leftJustify(instr.toString(), 14);
        StatePrinter.printState(str, s);
    }

    private void traceProducedState(StateCache.State s) {
        if (TRACE) {
            String str = this.graph.isExplored(s) ? "        E ==> " : (this.graph.isFrontier(s) ? "        F ==> " : "        N ==> ");
            StatePrinter.printState(str, s);
        }
    }

    public static void traceEdge(int type, StateCache.State s, StateCache.State t, int weight) {
        if (!TRACE) {
            return;
        }
        Terminal.print("adding edge ");
        StatePrinter.printEdge(s, type, weight, t);
    }

    static {
        EDGE_NAMES = new String[]{"", "PUSH", "POP", "CALL", "INT", "RET", "RETI", "SPECIAL"};
        EDGE_DELTA = new int[]{0, 1, -1, 2, 2, 0, 0, 0};
    }

    public class ContextSensitivePolicy
    implements AnalyzerPolicy {
        public StateCache.State frontierState;
        protected int edgeType;

        public MutableState call(MutableState s, int target_address) {
            ISEState rs;
            if (Analyzer.this.isea != null && (rs = Analyzer.this.isea.getProcedureSummary(target_address)) != null) {
                Analyzer.this.maskIrrelevantState(s, rs);
            }
            s.setPC(target_address);
            this.addEdge(this.frontierState, 3, s);
            return null;
        }

        public MutableState interrupt(MutableState s, int num) {
            s.setFlag_I('\u0100');
            s.setPC((num - 1) * 4);
            this.addEdge(this.frontierState, 4, s);
            return null;
        }

        public MutableState ret(MutableState s) {
            this.frontierState.setType(1);
            Analyzer.this.postReturnState(this.frontierState);
            ++Analyzer.this.retCount;
            return null;
        }

        public MutableState reti(MutableState s) {
            this.frontierState.setType(2);
            Analyzer.this.postReturnState(this.frontierState);
            ++Analyzer.this.retiCount;
            return null;
        }

        public MutableState indirectCall(MutableState s, char addr_low, char addr_hi) {
            int callsite = s.pc;
            List iedges = Analyzer.this.program.getIndirectEdges(callsite);
            if (iedges == null) {
                throw Util.failure("No control flow information for indirect call at: " + StringUtil.addrToString(callsite));
            }
            Iterator i = iedges.iterator();
            while (i.hasNext()) {
                int target_address = (Integer)i.next();
                this.call(s, target_address);
            }
            return null;
        }

        public MutableState indirectJump(MutableState s, char addr_low, char addr_hi) {
            int callsite = s.pc;
            List iedges = Analyzer.this.program.getIndirectEdges(callsite);
            if (iedges == null) {
                throw Util.failure("No control flow information for indirect jump at: " + StringUtil.addrToString(callsite));
            }
            Iterator i = iedges.iterator();
            while (i.hasNext()) {
                int target_address = (Integer)i.next();
                s.setPC(target_address);
                this.pushState(s);
            }
            return null;
        }

        public MutableState indirectCall(MutableState s, char addr_low, char addr_hi, char ext) {
            throw new Error("extended indirect calls not supported");
        }

        public MutableState indirectJump(MutableState s, char addr_low, char addr_hi, char ext) {
            throw new Error("extended indirect jumps not supported");
        }

        public void push(MutableState s, char val) {
            this.edgeType = 1;
        }

        public char pop(MutableState s) {
            this.edgeType = 2;
            return '\u0000';
        }

        public void pushState(MutableState newState) {
            this.addEdge(this.frontierState, this.edgeType, newState);
        }

        private void addEdge(StateCache.State from, int type, MutableState to) {
            StateCache.State t = Analyzer.this.graph.getCachedState(to);
            Analyzer.this.traceProducedState(t);
            this.addEdge(type, from, t, EDGE_DELTA[type]);
            this.pushFrontier(t);
        }

        private void pushFrontier(StateCache.State t) {
            if (t == this.frontierState) {
                return;
            }
            if (!Analyzer.this.graph.isExplored(t) && !Analyzer.this.graph.isFrontier(t)) {
                Analyzer.this.graph.addFrontierState(t);
            }
        }

        private void addEdge(int type, StateCache.State s, StateCache.State t, int weight) {
            Analyzer.traceEdge(type, s, t, weight);
            StateTransitionGraph.Edge edge = Analyzer.this.graph.addEdge(s, type, weight, t);
            if (Analyzer.this.graph.isExplored(t)) {
                Analyzer.this.postNewEdge(edge);
            }
        }
    }

    private class UnboundedStackException
    extends Exception {
        Path path;

        UnboundedStackException(Path p) {
            this.path = p;
        }
    }

    private class Path {
        final int depth;
        final int length;
        final StateTransitionGraph.Edge edge;
        final Path tail;

        Path(int d, StateTransitionGraph.Edge e, Path p) {
            this.depth = d;
            this.edge = e;
            this.tail = p;
            this.length = p == null ? 1 : 1 + p.length;
        }
    }

    protected class MonitorThread
    extends Thread {
        protected MonitorThread() {
        }

        public void run() {
            int cntr = 0;
            try {
                while (running) {
                    MonitorThread.sleep(5000L);
                    if (running) {
                        if (cntr % 10 == 0) {
                            Analyzer.this.printStatHeader();
                        }
                        Analyzer.this.printStats();
                        ++cntr;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                throw Util.unexpected(e);
            }
        }
    }
}

