/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack;

import avrora.arch.legacy.LegacyRegister;
import avrora.stack.AbstractArithmetic;
import avrora.stack.IORegisterConstants;
import avrora.stack.MutableState;
import avrora.stack.StateCache;
import cck.text.StringUtil;

public abstract class AbstractState
implements IORegisterConstants {
    protected int pc;
    protected char av_SREG;
    protected char av_EIMSK;
    protected char av_TIMSK;
    protected char[] av_REGISTERS = new char[32];
    public static final int[] primes = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137};

    AbstractState() {
    }

    protected int computeHashCode() {
        int hash = this.pc;
        hash += this.av_SREG;
        hash += this.av_EIMSK;
        hash += this.av_TIMSK;
        for (int cntr = 0; cntr < 32; ++cntr) {
            hash += this.av_REGISTERS[cntr] * primes[cntr];
        }
        return hash;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public int getPC() {
        return this.pc;
    }

    public char getSREG() {
        return this.av_SREG;
    }

    public char getFlag_I() {
        return AbstractArithmetic.getBit(this.av_SREG, 7);
    }

    public char getFlag_T() {
        return AbstractArithmetic.getBit(this.av_SREG, 6);
    }

    public char getFlag_H() {
        return AbstractArithmetic.getBit(this.av_SREG, 5);
    }

    public char getFlag_S() {
        return AbstractArithmetic.getBit(this.av_SREG, 4);
    }

    public char getFlag_V() {
        return AbstractArithmetic.getBit(this.av_SREG, 3);
    }

    public char getFlag_N() {
        return AbstractArithmetic.getBit(this.av_SREG, 2);
    }

    public char getFlag_Z() {
        return AbstractArithmetic.getBit(this.av_SREG, 1);
    }

    public char getFlag_C() {
        return AbstractArithmetic.getBit(this.av_SREG, 0);
    }

    public char getIORegisterAV(int num) {
        if (num == 63) {
            return this.av_SREG;
        }
        if (num == 57) {
            return this.av_EIMSK;
        }
        if (num == 55) {
            return this.av_TIMSK;
        }
        return '\u0000';
    }

    public char getRegisterAV(LegacyRegister r) {
        return this.av_REGISTERS[r.getNumber()];
    }

    public char getRegisterAV(int num) {
        return this.av_REGISTERS[num];
    }

    public MutableState copy() {
        return new MutableState(this.pc, this.av_SREG, this.av_EIMSK, this.av_TIMSK, this.av_REGISTERS);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("PC: ");
        buf.append(StringUtil.toHex(this.pc, 4));
        this.appendBit('I', this.getFlag_I(), buf);
        this.appendBit('T', this.getFlag_T(), buf);
        this.appendBit('H', this.getFlag_H(), buf);
        this.appendBit('S', this.getFlag_S(), buf);
        this.appendBit('V', this.getFlag_V(), buf);
        this.appendBit('N', this.getFlag_N(), buf);
        this.appendBit('Z', this.getFlag_Z(), buf);
        this.appendBit('C', this.getFlag_C(), buf);
        for (int cntr = 0; cntr < 32; ++cntr) {
            buf.append(" R");
            buf.append(cntr);
            buf.append(": ");
            AbstractArithmetic.toString(this.av_REGISTERS[cntr], buf);
        }
        return buf.toString();
    }

    private void appendBit(char bit, char av1, StringBuffer buf) {
        buf.append(' ');
        buf.append(bit);
        buf.append(": ");
        buf.append(AbstractArithmetic.bitToChar(av1));
    }

    protected boolean deepCompare(StateCache.State i) {
        if (this.pc != i.pc) {
            return false;
        }
        if (this.av_SREG != i.av_SREG) {
            return false;
        }
        if (this.av_EIMSK != i.av_EIMSK) {
            return false;
        }
        if (this.av_TIMSK != i.av_TIMSK) {
            return false;
        }
        for (int cntr = 0; cntr < 32; ++cntr) {
            if (this.av_REGISTERS[cntr] == i.av_REGISTERS[cntr]) continue;
            return false;
        }
        return true;
    }
}

