/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack;

import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyInstrVisitor;
import avrora.arch.legacy.LegacyRegister;
import avrora.core.Program;
import avrora.stack.AbstractArithmetic;
import avrora.stack.AnalyzerPolicy;
import avrora.stack.MutableState;
import avrora.stack.StateCache;
import cck.text.StringUtil;
import cck.util.Util;

public class AbstractInterpreter
extends AbstractArithmetic
implements LegacyInstrVisitor {
    protected final AnalyzerPolicy policy;
    protected final Program program;
    protected StateCache.State oldState;
    protected MutableState state;

    AbstractInterpreter(Program pr, AnalyzerPolicy p) {
        this.policy = p;
        this.program = pr;
    }

    public void computeNextStates(StateCache.State os) {
        this.oldState = os;
        this.state = this.oldState.copy();
        if (this.state.getFlag_I() != '\u0100') {
            char eimsk = this.state.getIORegisterAV(57);
            for (int cntr = 0; cntr < 8; ++cntr) {
                char msk = AbstractArithmetic.getBit(eimsk, cntr);
                if (msk == '\u0100') continue;
                this.policy.interrupt(this.state.copy(), cntr + 2);
            }
            char timsk = this.state.getIORegisterAV(55);
            for (int cntr = 0; cntr < 8; ++cntr) {
                char msk = AbstractArithmetic.getBit(timsk, cntr);
                if (msk == '\u0100') continue;
                this.policy.interrupt(this.state.copy(), 17 - cntr);
            }
        }
        int pc = this.state.getPC();
        LegacyInstr i = this.readInstr(pc);
        i.accept(this);
        if (this.state != null) {
            this.state.setPC(pc + i.getSize());
            this.policy.pushState(this.state);
        }
    }

    private LegacyInstr readInstr(int pc) {
        if (pc >= this.program.program_end) {
            throw Util.failure("PC beyond end of program: " + StringUtil.addrToString(pc));
        }
        LegacyInstr i = (LegacyInstr)this.program.readInstr(pc);
        if (i == null) {
            throw Util.failure("Misaligned instruction access at PC: " + StringUtil.addrToString(pc));
        }
        return i;
    }

    public void visit(LegacyInstr.ADC i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        char result = this.performAddition(r1, r2, this.state.getFlag_C());
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.ADD i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        char result = this.performAddition(r1, r2, '\u0100');
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.ADIW i) {
        char rh = this.state.getRegisterAV(i.r1.nextRegister());
        this.addImmediateToRegister(i.r1, i.imm1);
        char RL = this.state.getRegisterAV(i.r1);
        char RH = this.state.getRegisterAV(i.r1.nextRegister());
        char R15 = AbstractInterpreter.getBit(RH, 7);
        char Rdh7 = AbstractInterpreter.getBit(rh, 7);
        this.state.setFlag_C(AbstractInterpreter.and(AbstractInterpreter.not(R15), Rdh7));
        this.state.setFlag_N(R15);
        this.state.setFlag_V(AbstractInterpreter.and(AbstractInterpreter.not(Rdh7), R15));
        this.state.setFlag_Z(AbstractInterpreter.couldBeZero(RL, RH));
        this.state.setFlag_S(AbstractInterpreter.xor(this.state.getFlag_N(), this.state.getFlag_Z()));
    }

    public void visit(LegacyInstr.AND i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        char result = this.performAnd(r1, r2);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.ANDI i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = AbstractInterpreter.knownVal((byte)i.imm1);
        char result = this.performAnd(r1, r2);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.ASR i) {
        char val = this.state.getRegisterAV(i.r1);
        char result = this.performRightShift(val, AbstractInterpreter.getBit(val, 7));
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.BCLR i) {
        this.state.setSREG_bit(i.imm1, '\u0100');
    }

    public void visit(LegacyInstr.BLD i) {
        char T = this.state.getFlag_T();
        char val = this.state.getRegisterAV(i.r1);
        char result = AbstractInterpreter.setBit(val, i.imm1, T);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.BRBC i) {
        char val = this.state.getSREG();
        char bit = AbstractInterpreter.getBit(val, i.imm1);
        this.branchOnCondition(AbstractInterpreter.not(bit), i.imm2);
    }

    public void visit(LegacyInstr.BRBS i) {
        char val = this.state.getSREG();
        char bit = AbstractInterpreter.getBit(val, i.imm1);
        this.branchOnCondition(bit, i.imm2);
    }

    public void visit(LegacyInstr.BRCC i) {
        char cond = this.state.getFlag_C();
        this.branchOnCondition(AbstractInterpreter.not(cond), i.imm1);
    }

    public void visit(LegacyInstr.BRCS i) {
        char cond = this.state.getFlag_C();
        this.branchOnCondition(cond, i.imm1);
    }

    public void visit(LegacyInstr.BREAK i) {
        this.state = null;
    }

    public void visit(LegacyInstr.BREQ i) {
        this.branchOnCondition(this.state.getFlag_Z(), i.imm1);
    }

    public void visit(LegacyInstr.BRGE i) {
        this.branchOnCondition(AbstractInterpreter.not(AbstractInterpreter.xor(this.state.getFlag_N(), this.state.getFlag_V())), i.imm1);
    }

    public void visit(LegacyInstr.BRHC i) {
        this.branchOnCondition(AbstractInterpreter.not(this.state.getFlag_H()), i.imm1);
    }

    public void visit(LegacyInstr.BRHS i) {
        this.branchOnCondition(this.state.getFlag_H(), i.imm1);
    }

    public void visit(LegacyInstr.BRID i) {
        this.branchOnCondition(AbstractInterpreter.not(this.state.getFlag_I()), i.imm1);
    }

    public void visit(LegacyInstr.BRIE i) {
        this.branchOnCondition(this.state.getFlag_I(), i.imm1);
    }

    public void visit(LegacyInstr.BRLO i) {
        this.branchOnCondition(this.state.getFlag_C(), i.imm1);
    }

    public void visit(LegacyInstr.BRLT i) {
        this.branchOnCondition(AbstractInterpreter.xor(this.state.getFlag_N(), this.state.getFlag_V()), i.imm1);
    }

    public void visit(LegacyInstr.BRMI i) {
        this.branchOnCondition(this.state.getFlag_N(), i.imm1);
    }

    public void visit(LegacyInstr.BRNE i) {
        this.branchOnCondition(this.state.getFlag_Z(), i.imm1);
    }

    public void visit(LegacyInstr.BRPL i) {
        this.branchOnCondition(AbstractInterpreter.not(this.state.getFlag_N()), i.imm1);
    }

    public void visit(LegacyInstr.BRSH i) {
        this.branchOnCondition(AbstractInterpreter.not(this.state.getFlag_C()), i.imm1);
    }

    public void visit(LegacyInstr.BRTC i) {
        this.branchOnCondition(AbstractInterpreter.not(this.state.getFlag_T()), i.imm1);
    }

    public void visit(LegacyInstr.BRTS i) {
        this.branchOnCondition(this.state.getFlag_T(), i.imm1);
    }

    public void visit(LegacyInstr.BRVC i) {
        this.branchOnCondition(AbstractInterpreter.not(this.state.getFlag_V()), i.imm1);
    }

    public void visit(LegacyInstr.BRVS i) {
        this.branchOnCondition(this.state.getFlag_V(), i.imm1);
    }

    public void visit(LegacyInstr.BSET i) {
        this.state.setSREG_bit(i.imm1, '\u0101');
    }

    public void visit(LegacyInstr.BST i) {
        char val = this.state.getRegisterAV(i.r1);
        char T = AbstractInterpreter.getBit(val, i.imm1);
        this.state.setFlag_T(T);
    }

    public void visit(LegacyInstr.CALL i) {
        this.state = this.policy.call(this.state, this.absolute(i.imm1));
    }

    public void visit(LegacyInstr.CBI i) {
        char val = this.state.getIORegisterAV(i.imm1);
        char result = AbstractInterpreter.setBit(val, i.imm2, '\u0100');
        this.state.setIORegisterAV(i.imm1, result);
    }

    public void visit(LegacyInstr.CBR i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = AbstractInterpreter.knownVal((byte)(~i.imm1));
        char result = this.performAnd(r1, r2);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.CLC i) {
        this.state.setFlag_C('\u0100');
    }

    public void visit(LegacyInstr.CLH i) {
        this.state.setFlag_H('\u0100');
    }

    public void visit(LegacyInstr.CLI i) {
        this.state.setFlag_I('\u0100');
    }

    public void visit(LegacyInstr.CLN i) {
        this.state.setFlag_N('\u0100');
    }

    public void visit(LegacyInstr.CLR i) {
        this.state.setFlag_S('\u0100');
        this.state.setFlag_V('\u0100');
        this.state.setFlag_N('\u0100');
        this.state.setFlag_Z('\u0101');
        this.state.setRegisterAV(i.r1, '\uff00');
    }

    public void visit(LegacyInstr.CLS i) {
        this.state.setFlag_S('\u0100');
    }

    public void visit(LegacyInstr.CLT i) {
        this.state.setFlag_T('\u0100');
    }

    public void visit(LegacyInstr.CLV i) {
        this.state.setFlag_V('\u0100');
    }

    public void visit(LegacyInstr.CLZ i) {
        this.state.setFlag_Z('\u0100');
    }

    public void visit(LegacyInstr.COM i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char mask = AbstractInterpreter.maskOf(r1);
        char result = AbstractInterpreter.canon(mask, ~r1);
        char C = '\u0101';
        char N = AbstractInterpreter.getBit(result, 7);
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = '\u0100';
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_CNZVS(C, N, Z, V, S);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.CP i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        this.performSubtraction(r1, r2, '\u0100');
    }

    public void visit(LegacyInstr.CPC i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        this.performSubtraction(r1, r2, this.state.getFlag_C());
    }

    public void visit(LegacyInstr.CPI i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = AbstractInterpreter.knownVal((byte)i.imm1);
        this.performSubtraction(r1, r2, '\u0100');
    }

    public void visit(LegacyInstr.CPSE i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        this.performSubtraction(r1, r2, '\u0100');
        this.skipOnCondition(this.state.getFlag_Z());
    }

    public void visit(LegacyInstr.DEC i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char result = AbstractInterpreter.decrement(r1);
        char N = AbstractInterpreter.getBit(result, 7);
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = AbstractInterpreter.couldBeEqual(r1, AbstractInterpreter.knownVal((byte)-128));
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_NZVS(N, Z, V, S);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.EICALL i) {
        char rl = this.state.getRegisterAV(LegacyRegister.Z);
        char rh = this.state.getRegisterAV(LegacyRegister.Z.nextRegister());
        char ext = this.state.getIORegisterAV(59);
        this.state = this.policy.indirectCall(this.state, rl, rh, ext);
    }

    public void visit(LegacyInstr.EIJMP i) {
        char rl = this.state.getRegisterAV(LegacyRegister.Z);
        char rh = this.state.getRegisterAV(LegacyRegister.Z.nextRegister());
        char ext = this.state.getIORegisterAV(59);
        this.state = this.policy.indirectJump(this.state, rl, rh, ext);
    }

    public void visit(LegacyInstr.ELPM i) {
        this.state.setRegisterAV(LegacyRegister.R0, '\u0000');
    }

    public void visit(LegacyInstr.ELPMD i) {
        this.state.setRegisterAV(i.r1, '\u0000');
    }

    public void visit(LegacyInstr.ELPMPI i) {
        this.state.setRegisterAV(i.r1, '\u0000');
        this.addImmediateToRegister(i.r2, 1);
    }

    public void visit(LegacyInstr.EOR i) {
        char result;
        if (i.r1 == i.r2) {
            result = '\uff00';
        } else {
            char r1 = this.state.getRegisterAV(i.r1);
            char r2 = this.state.getRegisterAV(i.r2);
            result = AbstractInterpreter.xor(r1, r2);
        }
        char N = AbstractInterpreter.getBit(result, 7);
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = '\u0100';
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_NZVS(N, Z, V, S);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.FMUL i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        int result = this.mul8(r1, false, r2, false);
        this.finishFMUL(result);
    }

    public void visit(LegacyInstr.FMULS i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        int result = this.mul8(r1, true, r2, true);
        this.finishFMUL(result);
    }

    public void visit(LegacyInstr.FMULSU i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        int result = this.mul8(r1, true, r2, false);
        this.finishFMUL(result);
    }

    private void finishFMUL(int result) {
        char RL = this.lowAbstractByte(result);
        char RH = this.highAbstractByte(result);
        char R15 = AbstractInterpreter.getBit(RH, 7);
        char R7 = AbstractInterpreter.getBit(RL, 7);
        RL = AbstractInterpreter.shiftLeftOne(RL);
        RH = AbstractInterpreter.shiftLeftOne(RH, R7);
        this.state.setFlag_C(R15);
        this.state.setFlag_Z(AbstractInterpreter.couldBeZero(RL, RH));
        this.writeRegisterWord(LegacyRegister.R0, RL, RH);
    }

    public void visit(LegacyInstr.ICALL i) {
        char rl = this.state.getRegisterAV(LegacyRegister.Z);
        char rh = this.state.getRegisterAV(LegacyRegister.Z.nextRegister());
        this.state = this.policy.indirectCall(this.state, rl, rh);
    }

    public void visit(LegacyInstr.IJMP i) {
        char rl = this.state.getRegisterAV(LegacyRegister.Z);
        char rh = this.state.getRegisterAV(LegacyRegister.Z.nextRegister());
        this.state = this.policy.indirectJump(this.state, rl, rh);
    }

    public void visit(LegacyInstr.IN i) {
        char val = this.state.getIORegisterAV(i.imm1);
        this.state.setRegisterAV(i.r1, val);
    }

    public void visit(LegacyInstr.INC i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char result = AbstractInterpreter.increment(r1);
        char N = AbstractInterpreter.getBit(result, 7);
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = AbstractInterpreter.couldBeEqual(r1, AbstractInterpreter.knownVal((byte)127));
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_NZVS(N, Z, V, S);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.JMP i) {
        this.state.setPC(this.absolute(i.imm1));
        this.policy.pushState(this.state);
        this.state = null;
    }

    public void visit(LegacyInstr.LD i) {
        this.state.setRegisterAV(i.r1, '\u0000');
    }

    public void visit(LegacyInstr.LDD i) {
        this.state.setRegisterAV(i.r1, '\u0000');
    }

    public void visit(LegacyInstr.LDI i) {
        this.state.setRegisterAV(i.r1, AbstractInterpreter.knownVal((byte)i.imm1));
    }

    public void visit(LegacyInstr.LDPD i) {
        this.state.setRegisterAV(i.r1, '\u0000');
        this.addImmediateToRegister(i.r2, -1);
    }

    public void visit(LegacyInstr.LDPI i) {
        this.state.setRegisterAV(i.r1, '\u0000');
        this.addImmediateToRegister(i.r2, 1);
    }

    public void visit(LegacyInstr.LDS i) {
        this.state.setRegisterAV(i.r1, '\u0000');
    }

    public void visit(LegacyInstr.LPM i) {
        this.state.setRegisterAV(LegacyRegister.R0, '\u0000');
    }

    public void visit(LegacyInstr.LPMD i) {
        this.state.setRegisterAV(i.r1, '\u0000');
    }

    public void visit(LegacyInstr.LPMPI i) {
        this.state.setRegisterAV(i.r1, '\u0000');
        this.addImmediateToRegister(i.r2, 1);
    }

    public void visit(LegacyInstr.LSL i) {
        char val = this.state.getRegisterAV(i.r1);
        char result = this.performLeftShift(val, '\u0100');
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.LSR i) {
        char val = this.state.getRegisterAV(i.r1);
        char result = this.performRightShift(val, '\u0100');
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.MOV i) {
        char result = this.state.getRegisterAV(i.r2);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.MOVW i) {
        char vall = this.state.getRegisterAV(i.r2);
        char valh = this.state.getRegisterAV(i.r2.nextRegister());
        this.state.setRegisterAV(i.r1, vall);
        this.state.setRegisterAV(i.r1.nextRegister(), valh);
    }

    public void visit(LegacyInstr.MUL i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        int result = this.mul8(r1, false, r2, false);
        this.finishMultiply(result);
    }

    public void visit(LegacyInstr.MULS i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        int result = this.mul8(r1, true, r2, true);
        this.finishMultiply(result);
    }

    public void visit(LegacyInstr.MULSU i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        int result = this.mul8(r1, true, r2, false);
        this.finishMultiply(result);
    }

    private void finishMultiply(int result) {
        char RL = this.lowAbstractByte(result);
        char RH = this.highAbstractByte(result);
        this.state.setFlag_C(AbstractInterpreter.getBit(RH, 7));
        this.state.setFlag_Z(AbstractInterpreter.couldBeZero(RL, RH));
        this.writeRegisterWord(LegacyRegister.R0, RL, RH);
    }

    public void visit(LegacyInstr.NEG i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char result = this.performSubtraction('\uff00', r1, '\u0100');
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.NOP i) {
    }

    public void visit(LegacyInstr.OR i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        char result = this.performOr(r1, r2);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.ORI i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = AbstractInterpreter.knownVal((byte)i.imm1);
        char result = this.performOr(r1, r2);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.OUT i) {
        char val = this.state.getRegisterAV(i.r1);
        this.state.setIORegisterAV(i.imm1, val);
    }

    public void visit(LegacyInstr.POP i) {
        char val = this.policy.pop(this.state);
        this.state.setRegisterAV(i.r1, val);
    }

    public void visit(LegacyInstr.PUSH i) {
        char val = this.state.getRegisterAV(i.r1);
        this.policy.push(this.state, val);
    }

    public void visit(LegacyInstr.RCALL i) {
        this.state = this.policy.call(this.state, this.relative(i.imm1));
    }

    public void visit(LegacyInstr.RET i) {
        this.state = this.policy.ret(this.state);
    }

    public void visit(LegacyInstr.RETI i) {
        this.state = this.policy.reti(this.state);
    }

    public void visit(LegacyInstr.RJMP i) {
        this.state.setPC(this.relative(i.imm1));
        this.policy.pushState(this.state);
        this.state = null;
    }

    public void visit(LegacyInstr.ROL i) {
        char val = this.state.getRegisterAV(i.r1);
        char result = this.performLeftShift(val, this.state.getFlag_C());
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.ROR i) {
        char val = this.state.getRegisterAV(i.r1);
        char result = this.performRightShift(val, this.state.getFlag_C());
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.SBC i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        char result = this.performSubtraction(r1, r2, this.state.getFlag_C());
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.SBCI i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char imm = AbstractInterpreter.knownVal((byte)i.imm1);
        char result = this.performSubtraction(r1, imm, this.state.getFlag_C());
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.SBI i) {
        char val = this.state.getIORegisterAV(i.imm1);
        char result = AbstractInterpreter.setBit(val, i.imm2, '\u0101');
        this.state.setIORegisterAV(i.imm1, result);
    }

    public void visit(LegacyInstr.SBIC i) {
        char reg = this.state.getIORegisterAV(i.imm1);
        char bit = AbstractInterpreter.getBit(reg, i.imm2);
        this.skipOnCondition(AbstractInterpreter.not(bit));
    }

    public void visit(LegacyInstr.SBIS i) {
        char reg = this.state.getIORegisterAV(i.imm1);
        char bit = AbstractInterpreter.getBit(reg, i.imm2);
        this.skipOnCondition(bit);
    }

    public void visit(LegacyInstr.SBIW i) {
        char rh = this.state.getRegisterAV(i.r1.nextRegister());
        this.addImmediateToRegister(i.r1, -i.imm1);
        char RL = this.state.getRegisterAV(i.r1);
        char RH = this.state.getRegisterAV(i.r1.nextRegister());
        char Rdh7 = AbstractInterpreter.getBit(rh, 7);
        char R15 = AbstractInterpreter.getBit(RH, 7);
        char V = AbstractInterpreter.and(Rdh7, AbstractInterpreter.not(R15));
        char N = R15;
        char Z = AbstractInterpreter.couldBeZero(RL, RH);
        char C = AbstractInterpreter.and(R15, AbstractInterpreter.not(Rdh7));
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_CNZVS(C, N, Z, V, S);
    }

    public void visit(LegacyInstr.SBR i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = AbstractInterpreter.knownVal((byte)i.imm1);
        char result = this.performOr(r1, r2);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.SBRC i) {
        char bit = AbstractInterpreter.getBit(this.state.getRegisterAV(i.r1), i.imm1);
        this.skipOnCondition(AbstractInterpreter.not(bit));
    }

    public void visit(LegacyInstr.SBRS i) {
        char bit = AbstractInterpreter.getBit(this.state.getRegisterAV(i.r1), i.imm1);
        this.skipOnCondition(bit);
    }

    public void visit(LegacyInstr.SEC i) {
        this.state.setFlag_C('\u0101');
    }

    public void visit(LegacyInstr.SEH i) {
        this.state.setFlag_H('\u0101');
    }

    public void visit(LegacyInstr.SEI i) {
        this.state.setFlag_I('\u0101');
    }

    public void visit(LegacyInstr.SEN i) {
        this.state.setFlag_N('\u0101');
    }

    public void visit(LegacyInstr.SER i) {
        this.state.setRegisterAV(i.r1, AbstractInterpreter.knownVal((byte)-1));
    }

    public void visit(LegacyInstr.SES i) {
        this.state.setFlag_S('\u0101');
    }

    public void visit(LegacyInstr.SET i) {
        this.state.setFlag_T('\u0101');
    }

    public void visit(LegacyInstr.SEV i) {
        this.state.setFlag_V('\u0101');
    }

    public void visit(LegacyInstr.SEZ i) {
        this.state.setFlag_Z('\u0101');
    }

    public void visit(LegacyInstr.SLEEP i) {
    }

    public void visit(LegacyInstr.SPM i) {
    }

    public void visit(LegacyInstr.ST i) {
    }

    public void visit(LegacyInstr.STD i) {
    }

    public void visit(LegacyInstr.STPD i) {
        this.addImmediateToRegister(i.r1, -1);
    }

    public void visit(LegacyInstr.STPI i) {
        this.addImmediateToRegister(i.r1, 1);
    }

    public void visit(LegacyInstr.STS i) {
    }

    public void visit(LegacyInstr.SUB i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char r2 = this.state.getRegisterAV(i.r2);
        char result = this.performSubtraction(r1, r2, '\u0100');
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.SUBI i) {
        char r1 = this.state.getRegisterAV(i.r1);
        char imm = AbstractInterpreter.knownVal((byte)i.imm1);
        char result = this.performSubtraction(r1, imm, '\u0100');
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.SWAP i) {
        char result = this.state.getRegisterAV(i.r1);
        int high = (result & 0xF0F0) >> 4;
        int low = (result & 0xF0F) << 4;
        result = (char)(low | high);
        this.state.setRegisterAV(i.r1, result);
    }

    public void visit(LegacyInstr.TST i) {
        char r1 = this.state.getRegisterAV(i.r1);
        this.state.setFlag_V('\u0100');
        this.state.setFlag_Z(AbstractInterpreter.couldBeZero(r1));
        this.state.setFlag_N(AbstractInterpreter.getBit(r1, 7));
        this.state.setFlag_S(AbstractInterpreter.xor(this.state.getFlag_N(), this.state.getFlag_V()));
    }

    public void visit(LegacyInstr.WDR i) {
    }

    private void branchOnCondition(char cond, int offset) {
        if (cond == '\u0100') {
            return;
        }
        MutableState taken = this.state.copy();
        this.relativeBranch(taken, offset);
        this.policy.pushState(taken);
        if (cond == '\u0101') {
            this.state = null;
        }
    }

    private void skipOnCondition(char cond) {
        int pc = this.state.getPC();
        int npc = pc + 2;
        int offset = this.program.readInstr(npc).getSize() / 2;
        this.branchOnCondition(cond, offset);
    }

    private void relativeBranch(MutableState s, int offset) {
        s.setPC(this.relative(offset));
    }

    private void setFlag_HCNZVS(char H, char C, char N, char Z, char V, char S) {
        this.state.setFlag_H(H);
        this.state.setFlag_C(C);
        this.state.setFlag_N(N);
        this.state.setFlag_Z(Z);
        this.state.setFlag_V(V);
        this.state.setFlag_S(S);
    }

    private void setFlag_CNZVS(char C, char N, char Z, char V, char S) {
        this.state.setFlag_C(C);
        this.state.setFlag_N(N);
        this.state.setFlag_Z(Z);
        this.state.setFlag_V(V);
        this.state.setFlag_S(S);
    }

    private void setFlag_NZVS(char N, char Z, char V, char S) {
        this.state.setFlag_N(N);
        this.state.setFlag_Z(Z);
        this.state.setFlag_V(V);
        this.state.setFlag_S(S);
    }

    private char performAddition(char r1, char r2, char carry) {
        char result = AbstractInterpreter.add(r1, r2);
        if (carry == '\u0101') {
            result = AbstractInterpreter.increment(result);
        } else if (carry != '\u0100') {
            result = AbstractInterpreter.merge(result, AbstractInterpreter.increment(result));
        }
        char Rd7 = AbstractInterpreter.getBit(r1, 7);
        char Rr7 = AbstractInterpreter.getBit(r2, 7);
        char R7 = AbstractInterpreter.getBit(result, 7);
        char Rd3 = AbstractInterpreter.getBit(r1, 3);
        char Rr3 = AbstractInterpreter.getBit(r2, 3);
        char R3 = AbstractInterpreter.getBit(result, 3);
        char H = AbstractInterpreter.or(AbstractInterpreter.and(Rd3, Rr3), AbstractInterpreter.and(AbstractInterpreter.not(R3), Rd3, AbstractInterpreter.and(AbstractInterpreter.not(R3), Rr3)));
        char C = AbstractInterpreter.or(AbstractInterpreter.and(Rd7, Rr7), AbstractInterpreter.and(AbstractInterpreter.not(R7), Rd7, AbstractInterpreter.and(AbstractInterpreter.not(R7), Rr7)));
        char N = AbstractInterpreter.getBit(result, 7);
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = AbstractInterpreter.or(AbstractInterpreter.and(Rd7, Rr7, AbstractInterpreter.not(R7)), AbstractInterpreter.and(AbstractInterpreter.not(Rd7), AbstractInterpreter.not(Rr7), R7));
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_HCNZVS(H, C, N, Z, V, S);
        return result;
    }

    private char performSubtraction(char r1, char r2, char carry) {
        char result = AbstractInterpreter.subtract(r1, r2);
        if (carry == '\u0101') {
            result = AbstractInterpreter.decrement(result);
        } else if (carry != '\u0100') {
            result = AbstractInterpreter.merge(result, AbstractInterpreter.decrement(result));
        }
        char Rd7 = AbstractInterpreter.getBit(r1, 7);
        char Rr7 = AbstractInterpreter.getBit(r2, 7);
        char R7 = AbstractInterpreter.getBit(result, 7);
        char Rd3 = AbstractInterpreter.getBit(r1, 3);
        char Rr3 = AbstractInterpreter.getBit(r2, 3);
        char R3 = AbstractInterpreter.getBit(result, 3);
        char H = AbstractInterpreter.or(AbstractInterpreter.and(AbstractInterpreter.not(Rd3), Rr3), AbstractInterpreter.and(Rr3, R3), AbstractInterpreter.and(R3, AbstractInterpreter.not(Rd3)));
        char C = AbstractInterpreter.or(AbstractInterpreter.and(AbstractInterpreter.not(Rd7), Rr7), AbstractInterpreter.and(Rr7, R7), AbstractInterpreter.and(R7, AbstractInterpreter.not(Rd7)));
        char N = R7;
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = AbstractInterpreter.or(AbstractInterpreter.and(Rd7, AbstractInterpreter.not(Rr7), AbstractInterpreter.not(R7)), AbstractInterpreter.and(AbstractInterpreter.not(Rd7), Rr7, R7));
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_HCNZVS(H, C, N, Z, V, S);
        return result;
    }

    private char performRightShift(char val, char highbit) {
        char result = (char)((val & 0xFEFE) >> 1 | highbit);
        char C = AbstractInterpreter.getBit(val, 1);
        char N = highbit;
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = AbstractInterpreter.xor(N, C);
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_CNZVS(C, N, Z, V, S);
        return result;
    }

    private char performLeftShift(char val, char lowbit) {
        char result = AbstractInterpreter.shiftLeftOne(val, lowbit);
        char H = AbstractInterpreter.getBit(result, 3);
        char C = AbstractInterpreter.getBit(val, 7);
        char N = AbstractInterpreter.getBit(result, 7);
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = AbstractInterpreter.xor(N, C);
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_HCNZVS(H, C, N, Z, V, S);
        return result;
    }

    private char performOr(char r1, char r2) {
        char result = AbstractInterpreter.or(r1, r2);
        char N = AbstractInterpreter.getBit(result, 7);
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = '\u0100';
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_NZVS(N, Z, V, S);
        return result;
    }

    private char performAnd(char r1, char r2) {
        char result = AbstractInterpreter.and(r1, r2);
        char N = AbstractInterpreter.getBit(result, 7);
        char Z = AbstractInterpreter.couldBeZero(result);
        char V = '\u0100';
        char S = AbstractInterpreter.xor(N, V);
        this.setFlag_NZVS(N, Z, V, S);
        return result;
    }

    private void addImmediateToRegister(LegacyRegister r, int imm) {
        char v1 = this.state.getRegisterAV(r);
        char v2 = this.state.getRegisterAV(r.nextRegister());
        int resultA = AbstractInterpreter.ceiling(v1, v2) + imm;
        int resultB = AbstractInterpreter.floor(v1, v2) + imm;
        char RL = AbstractInterpreter.mergeMask(AbstractInterpreter.maskOf(v1), AbstractInterpreter.merge((byte)resultA, (byte)resultB));
        char RH = AbstractInterpreter.mergeMask(AbstractInterpreter.maskOf(v2), AbstractInterpreter.merge((byte)(resultA >> 8), (byte)(resultB >> 8)));
        this.state.setRegisterAV(r, RL);
        this.state.setRegisterAV(r.nextRegister(), RH);
    }

    private int mul8(char v1, boolean s1, char v2, boolean s2) {
        int ceil1 = this.ceiling(v1, s1);
        int ceil2 = this.ceiling(v2, s2);
        int floor1 = this.floor(v1, s1);
        int floor2 = this.floor(v2, s2);
        int resultA = ceil1 * ceil2;
        int resultB = ceil1 * floor2;
        int resultC = floor1 * ceil2;
        int resultD = floor1 * floor2;
        char RL = AbstractInterpreter.merge((byte)resultA, (byte)resultB, (byte)resultC, (byte)resultD);
        char RH = AbstractInterpreter.merge((byte)(resultA >> 8), (byte)(resultB >> 8), (byte)(resultC >> 8), (byte)(resultD >> 8));
        return RH << 16 | RL;
    }

    private void writeRegisterWord(LegacyRegister r, char vl, char vh) {
        this.state.setRegisterAV(r, vl);
        this.state.setRegisterAV(r.nextRegister(), vh);
    }

    private int ceiling(char v1, boolean s1) {
        if (s1) {
            return (byte)AbstractInterpreter.ceiling(v1);
        }
        return AbstractInterpreter.ceiling(v1);
    }

    private int floor(char v1, boolean s1) {
        if (s1) {
            return (byte)AbstractInterpreter.floor(v1);
        }
        return AbstractInterpreter.floor(v1);
    }

    private char highAbstractByte(int result) {
        return (char)(result >> 16 & 0xFFFF);
    }

    private char lowAbstractByte(int result) {
        return (char)(result & 0xFFFF);
    }

    private int relative(int imm1) {
        return 2 + 2 * imm1 + this.state.getPC();
    }

    private int absolute(int imm1) {
        return 2 * imm1;
    }
}

