/*
 * Decompiled with CFR 0.152.
 */
package avrora.stack;

public class AbstractArithmetic {
    private static final char KNOWN_MASK = '\uff00';
    private static final char BIT_MASK = '\u00ff';
    private static final int SHIFT = 8;
    public static final char ZERO = '\uff00';
    public static final char TRUE = '\u0101';
    public static final char FALSE = '\u0100';
    public static final char UNKNOWN = '\u0000';

    public static char merge(byte cv1, byte cv2) {
        int mm = ~(cv1 ^ cv2);
        return AbstractArithmetic.canon((char)mm, (char)cv1);
    }

    public static char merge(char av1, byte cv2) {
        int mm = ~(AbstractArithmetic.knownBitsOf(av1) ^ cv2);
        return AbstractArithmetic.canon((char)(mm & AbstractArithmetic.maskOf(av1)), av1);
    }

    public static char merge(byte cv1, byte cv2, byte cv3) {
        return AbstractArithmetic.merge(AbstractArithmetic.merge(cv1, cv2), cv3);
    }

    public static char merge(byte cv1, byte cv2, byte cv3, byte cv4) {
        return AbstractArithmetic.merge(AbstractArithmetic.merge(cv1, cv2), AbstractArithmetic.merge(cv3, cv4));
    }

    public static char merge(char av1, char av2) {
        if (av1 == av2) {
            return av1;
        }
        char v1k = AbstractArithmetic.maskOf(av1);
        char v2k = AbstractArithmetic.maskOf(av2);
        int mm = ~(AbstractArithmetic.knownBitsOf(av1) ^ AbstractArithmetic.knownBitsOf(av2));
        int rk = v1k & v2k & mm & 0xFF;
        return AbstractArithmetic.canon((char)rk, av1);
    }

    public static boolean isUnknown(char av1) {
        return (av1 & 0xFF00) != 65280;
    }

    public static boolean areKnown(char av1, char av2) {
        return (av1 & av2 & 0xFF00) == 65280;
    }

    public static boolean areEqual(char val1, char val2) {
        if (val1 == val2) {
            return true;
        }
        return AbstractArithmetic.canon(val1) == AbstractArithmetic.canon(val2);
    }

    public static char canon(char av1) {
        int vk = av1 & 0xFF00;
        return (char)(vk | av1 & vk >> 8);
    }

    public static char canon(char mask, char av1) {
        return (char)(mask << 8 | av1 & mask);
    }

    public static char knownVal(byte cv1) {
        return (char)(0xFF00 | cv1 & 0xFF);
    }

    public static byte knownBitsOf(char val) {
        return (byte)((val & 0xFF00) >> 8 & val);
    }

    public static char bitsOf(char av1) {
        return (char)(av1 & 0xFF);
    }

    public static char maskOf(char av1) {
        return (char)((av1 & 0xFF00) >> 8);
    }

    public static char getBit(char av1, int bit) {
        return (char)(av1 >> bit & 0x101);
    }

    public static char setBit(char av1, int bit, char on) {
        int mask = ~(257 << bit);
        return (char)(av1 & mask | (on & 0x101) << bit);
    }

    public static char couldBeZero(char av1) {
        if (av1 == '\uff00') {
            return '\u0101';
        }
        if (AbstractArithmetic.knownBitsOf(av1) != 0) {
            return '\u0100';
        }
        return '\u0000';
    }

    public static char couldBeZero(char av1, char av2) {
        if (av1 == '\uff00' && av2 == '\uff00') {
            return '\u0101';
        }
        if (AbstractArithmetic.knownBitsOf(av1) != 0 || AbstractArithmetic.knownBitsOf(av2) != 0) {
            return '\u0100';
        }
        return '\u0000';
    }

    public static char couldBeEqual(char av1, char av2) {
        if (AbstractArithmetic.areKnown(av1, av2) && av1 == av2) {
            return '\u0101';
        }
        if (AbstractArithmetic.knownBitsOf(av1) != AbstractArithmetic.knownBitsOf(av2)) {
            return '\u0100';
        }
        return '\u0000';
    }

    public static char commonMask(char av1, char av2) {
        return (char)(AbstractArithmetic.maskOf(av1) & AbstractArithmetic.maskOf(av2));
    }

    public static char commonMask(char av1, char av2, char av3) {
        return (char)(AbstractArithmetic.maskOf(av1) & AbstractArithmetic.maskOf(av2) & AbstractArithmetic.maskOf(av3));
    }

    public static char logicalAnd(char av1, char av2) {
        return (char)(av1 & av2 & 0x101);
    }

    public static char add(char av1, char av2) {
        char common = AbstractArithmetic.commonMask(av1, av2);
        if (AbstractArithmetic.areKnown(av1, av2)) {
            return AbstractArithmetic.knownVal((byte)(AbstractArithmetic.bitsOf(av1) + AbstractArithmetic.bitsOf(av2)));
        }
        int resultA = AbstractArithmetic.ceiling(av1) + AbstractArithmetic.ceiling(av2);
        int resultB = AbstractArithmetic.floor(av1) + AbstractArithmetic.floor(av2);
        return AbstractArithmetic.mergeMask(common, AbstractArithmetic.merge((byte)resultA, (byte)resultB));
    }

    public static char subtract(char av1, char av2) {
        char common = AbstractArithmetic.commonMask(av1, av2);
        if (AbstractArithmetic.areKnown(av1, av2)) {
            return AbstractArithmetic.knownVal((byte)(AbstractArithmetic.bitsOf(av1) - AbstractArithmetic.bitsOf(av2)));
        }
        int resultA = AbstractArithmetic.ceiling(av1) - AbstractArithmetic.ceiling(av2);
        int resultB = AbstractArithmetic.floor(av1) - AbstractArithmetic.floor(av2);
        return AbstractArithmetic.mergeMask(common, AbstractArithmetic.merge((byte)resultA, (byte)resultB));
    }

    public static char increment(char av1) {
        char mask = AbstractArithmetic.maskOf(av1);
        int resultA = AbstractArithmetic.ceiling(av1) + 1;
        int resultB = AbstractArithmetic.floor(av1) + 1;
        return AbstractArithmetic.mergeMask(mask, AbstractArithmetic.merge((byte)resultA, (byte)resultB));
    }

    public static char decrement(char av1) {
        char mask = AbstractArithmetic.maskOf(av1);
        int resultA = AbstractArithmetic.ceiling(av1) - 1;
        int resultB = AbstractArithmetic.floor(av1) - 1;
        return AbstractArithmetic.mergeMask(mask, AbstractArithmetic.merge((byte)resultA, (byte)resultB));
    }

    public static char mergeMask(char mask, char av1) {
        char common = (char)(mask & AbstractArithmetic.maskOf(av1));
        return AbstractArithmetic.canon(common, av1);
    }

    public static char xor(char av1, char av2) {
        char mask = AbstractArithmetic.commonMask(av1, av2);
        return AbstractArithmetic.canon(mask, (char)(av1 ^ av2));
    }

    public static char and(char av1, char av2) {
        return (char)(av1 & av2);
    }

    public static char or(char av1, char av2) {
        return AbstractArithmetic.canon(AbstractArithmetic.commonMask(av1, av2), (char)(av1 | av2));
    }

    public static char and(char av1, char av2, char av3) {
        return (char)(av1 & av2 & av3);
    }

    public static char or(char av1, char av2, char av3) {
        return AbstractArithmetic.canon(AbstractArithmetic.commonMask(av1, av2, av3), (char)(av1 | av2 | av3));
    }

    public static char not(char av1) {
        return AbstractArithmetic.canon((char)(av1 ^ 0xFF));
    }

    public static int ceiling(char av1) {
        int invmask = ~AbstractArithmetic.maskOf(av1) & 0xFF;
        return AbstractArithmetic.bitsOf(av1) | invmask;
    }

    public static int ceiling(char av1, char av2) {
        return AbstractArithmetic.ceiling(av1) | AbstractArithmetic.ceiling(av2) << 8;
    }

    public static int floor(char av1) {
        return AbstractArithmetic.bitsOf(av1);
    }

    public static int floor(char av1, char av2) {
        return AbstractArithmetic.bitsOf(av1) | AbstractArithmetic.bitsOf(av2) << 8;
    }

    public static char shiftLeftOne(char av1) {
        return (char)((av1 & 0x7F7F) << 1 | 0x100);
    }

    public static char shiftLeftOne(char av1, char lowbit) {
        return (char)((av1 & 0x7F7F) << 1 | lowbit & 0x101);
    }

    public static String toString(char av1) {
        StringBuffer buf = new StringBuffer(9);
        AbstractArithmetic.toString(av1, buf);
        return buf.toString();
    }

    public static String toShortString(char av1) {
        if (av1 == '\uff00') {
            return "0";
        }
        StringBuffer buf = new StringBuffer(9);
        AbstractArithmetic.toString(av1, buf);
        return buf.toString();
    }

    public static char bitToChar(char av1) {
        switch (av1) {
            case '\u0101': {
                return '1';
            }
            case '\u0100': {
                return '0';
            }
        }
        return '.';
    }

    public static void toString(char av1, StringBuffer buf) {
        for (int cntr = 7; cntr >= 0; --cntr) {
            buf.append(AbstractArithmetic.bitToChar(AbstractArithmetic.getBit(av1, cntr)));
        }
    }
}

