/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.util;

public class TransactionalList {
    protected Link head;
    protected Link tail;
    protected Link transHead;
    protected Link transTail;
    protected int nesting;

    public void add(Object b) {
        if (this.nesting > 0) {
            this.addTransaction(b, true);
            return;
        }
        if (this.head == null) {
            this.head = this.tail = new Link(b);
        } else {
            this.tail = this.tail.next = new Link(b);
        }
    }

    public void remove(Object o) {
        if (this.nesting > 0) {
            this.addTransaction(o, false);
            return;
        }
        Link prev = null;
        Link pos = this.head;
        while (pos != null) {
            Link next = pos.next;
            if (pos.object == o) {
                if (prev == null) {
                    this.head = pos.next;
                } else {
                    prev.next = pos.next;
                }
                if (pos == this.tail) {
                    this.tail = prev;
                }
            } else {
                prev = pos;
            }
            pos = next;
        }
    }

    private void addTransaction(Object o, boolean isAdd) {
        if (this.transHead == null) {
            this.transHead = this.transTail = new Link(o, isAdd);
        } else {
            this.transTail = this.transTail.next = new Link(o, isAdd);
        }
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public void beginTransaction() {
        ++this.nesting;
    }

    public void endTransaction() {
        --this.nesting;
        if (this.nesting == 0) {
            Link thead = this.transHead;
            this.transHead = null;
            this.transTail = null;
            Link pos = thead;
            while (pos != null) {
                if (pos.addTransaction) {
                    this.add(pos.object);
                } else {
                    this.remove(pos.object);
                }
                pos = pos.next;
            }
        }
    }

    public Link getHead() {
        return this.head;
    }

    public static class Link {
        public boolean addTransaction;
        public final Object object;
        public Link next;

        Link(Object o) {
            this.object = o;
        }

        Link(Object o, boolean a) {
            this.object = o;
            this.addTransaction = a;
        }
    }
}

