/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.util;

import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.output.EventGen;
import avrora.sim.output.SimPrinter;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.text.Verbose;
import cck.util.TimeUtil;

public class SimUtil {
    public static int ID_LENGTH = 4;
    public static int TIME_LENGTH = 12;
    public static int SECONDS_PRECISION = 6;
    public static boolean REPORT_SECONDS = false;

    public static void readError(Simulator sim, String segment, int address) {
        String msg = "illegal read from " + segment + " at address " + StringUtil.addrToString(address);
        int npc = sim.getState().getPC();
        SimUtil.warning(sim, StringUtil.to0xHex(npc, 4), msg);
    }

    public static void writeError(Simulator sim, String segment, int address, byte value) {
        String msg = "illegal write to " + segment + " at address " + StringUtil.addrToString(address);
        int npc = sim.getState().getPC();
        SimUtil.warning(sim, StringUtil.to0xHex(npc, 4), msg);
    }

    public static SimPrinter getPrinter(Simulator s, String str) {
        return new SimPrinter(s, str);
    }

    public static EventGen getEventGen(Simulator s, String str) {
        EventGen gen = new EventGen(s.getEventBuffer());
        if (Verbose.getVerbosePrinter((String)str).enabled) {
            gen.enable();
        }
        return gen;
    }

    public static void toIDTimeString(StringBuffer buf, int id, Clock clk) {
        boolean R = true;
        StringUtil.justify(R, buf, id, ID_LENGTH);
        buf.append("  ");
        if (REPORT_SECONDS) {
            StringBuffer buf2 = new StringBuffer(TIME_LENGTH + 1);
            long hz = clk.getHZ();
            long count = clk.getCount();
            long seconds = count / hz;
            long fract = count % hz;
            double f = (double)fract / (double)hz;
            TimeUtil.appendSecs(buf2, seconds);
            StringUtil.appendFract(buf2, f, SECONDS_PRECISION);
            StringUtil.justify(R, buf, buf2.toString(), TIME_LENGTH);
        } else {
            StringUtil.justify(R, buf, clk.getCount(), TIME_LENGTH);
        }
        buf.append("  ");
    }

    public static String toIDTimeString(int id, Clock clk) {
        StringBuffer buf = new StringBuffer(40);
        SimUtil.toIDTimeString(buf, id, clk);
        return buf.toString();
    }

    public static String getIDTimeString(Simulator s) {
        return SimUtil.toIDTimeString(s.getID(), s.getClock());
    }

    public static void getIDTimeString(StringBuffer buf, Simulator s) {
        SimUtil.toIDTimeString(buf, s.getID(), s.getClock());
    }

    public static void warning(Simulator s, String w, String m) {
        StringBuffer buf = new StringBuffer(40 + w.length() + m.length());
        SimUtil.getIDTimeString(buf, s);
        Terminal.append(11, buf, w);
        buf.append(": ");
        buf.append(m);
        Terminal.println(buf.toString());
    }
}

