/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.util;

import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.sim.State;

public class RangeProfiler
extends Simulator.Probe.Empty {
    public final Program program;
    public final int low_addr;
    public final int high_addr;
    public final long[] icount;

    public RangeProfiler(Program p, int low, int high) {
        int size = p.program_end;
        this.icount = new long[size];
        this.program = p;
        this.low_addr = low;
        this.high_addr = high;
    }

    public void fireBefore(State state, int address) {
        if (address < this.low_addr) {
            return;
        }
        if (address >= this.high_addr) {
            return;
        }
        int n = address - this.low_addr;
        this.icount[n] = this.icount[n] + 1L;
    }
}

