/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.util;

import avrora.arch.legacy.LegacyInstr;
import avrora.core.Program;
import avrora.sim.State;

public class MemoryMatrixProfiler {
    public final long[][] rcount;
    public final long[][] wcount;
    public final int ramSize;

    public MemoryMatrixProfiler(Program p, int size) {
        this.ramSize = size;
        this.rcount = new long[p.program_end][];
        this.wcount = new long[p.program_end][];
    }

    public void fireBeforeRead(LegacyInstr i, int address, State state, int data_addr, byte value) {
        if (data_addr < this.ramSize) {
            if (this.rcount[address] == null) {
                this.rcount[address] = new long[this.ramSize];
            }
            long[] lArray = this.rcount[address];
            int n = data_addr;
            lArray[n] = lArray[n] + 1L;
        }
    }

    public void fireBeforeWrite(LegacyInstr i, int address, State state, int data_addr, byte value) {
        if (data_addr < this.ramSize) {
            if (this.wcount[address] == null) {
                this.wcount[address] = new long[this.ramSize];
            }
            long[] lArray = this.wcount[address];
            int n = data_addr;
            lArray[n] = lArray[n] + 1L;
        }
    }

    public void fireAfterRead(LegacyInstr i, int address, State state, int data_addr, byte value) {
    }

    public void fireAfterWrite(LegacyInstr i, int address, State state, int data_addr, byte value) {
    }

    public long getReadCount(int address, int data_addr) {
        return this.getCount(this.rcount, data_addr, address);
    }

    public long getWriteCount(int address, int data_addr) {
        return this.getCount(this.wcount, data_addr, address);
    }

    private long getCount(long[][] matrix, int data_addr, int address) {
        if (data_addr < this.ramSize) {
            if (matrix[address] == null) {
                return 0L;
            }
            return matrix[address][data_addr];
        }
        return 0L;
    }
}

