/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.util;

import avrora.sim.AtmelInterpreter;
import avrora.sim.Simulator;
import avrora.sim.State;
import cck.text.Terminal;

public class MemTimer
extends Simulator.Watch.Empty {
    int base;
    long start_time = 0L;
    int timer_state = 0;

    public MemTimer(int b) {
        this.base = b;
    }

    public void fireBeforeWrite(State state, int data_addr, byte value) {
        if (data_addr != this.base) {
            Terminal.printRed("Unexpected interception by printer!");
            System.exit(-1);
        }
        AtmelInterpreter a = (AtmelInterpreter)state.getSimulator().getInterpreter();
        switch (value) {
            case 100: {
                if (this.timer_state != 0) {
                    Terminal.printRed("timer: multiple starts in a row??");
                    Terminal.nextln();
                } else {
                    this.start_time = state.getCycles();
                }
                this.timer_state = 1;
                break;
            }
            case 101: {
                if (this.timer_state != 1) {
                    Terminal.printRed("timer: multiple stops in a row??");
                    Terminal.nextln();
                } else {
                    long stop_time = state.getCycles();
                    long duration = stop_time - this.start_time;
                    Terminal.printRed("timer: " + String.valueOf(duration) + " cycles");
                    Terminal.nextln();
                }
                this.timer_state = 0;
                break;
            }
            default: {
                Terminal.printRed("Unexpected command to timer!");
                Terminal.nextln();
            }
        }
    }
}

