/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.util;

import cck.text.Terminal;
import cck.util.Util;

public class Mem16 {
    public final int[] values = new int[16];
    public static final int max = 16;
    public int count = 0;
    public int state = 0;
    public long deadline = 0L;
    public byte saved;

    public void add(int v) {
        for (int i = 0; i < this.count; ++i) {
            if (this.values[i] != v) continue;
            return;
        }
        if (this.count == 16) {
            this.count = -1;
        } else {
            this.values[this.count] = v;
            ++this.count;
        }
    }

    public int btoi(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        return i;
    }

    public void add_lo(byte value, long time) {
        if (this.count < 0) {
            return;
        }
        if (this.state == 0) {
            this.state = 2;
            this.saved = value;
            return;
        }
        if (this.state == 1) {
            int v = this.btoi(value) + (this.btoi(this.saved) << 8);
            this.add(v);
            this.state = 0;
            return;
        }
        if (this.state == 2) {
            this.count = -2;
            return;
        }
        throw Util.failure("bug in Mem16!");
    }

    public void add_hi(byte value, long time) {
        if (this.count < 0) {
            return;
        }
        if (this.state == 0) {
            this.state = 1;
            this.saved = value;
            return;
        }
        if (this.state == 2) {
            int v = this.btoi(this.saved) + (this.btoi(value) << 8);
            this.add(v);
            this.state = 0;
            return;
        }
        if (this.state == 1) {
            this.count = -2;
            return;
        }
        throw Util.failure("bug in Mem16!");
    }

    public void print() {
        if (this.count == -2) {
            Terminal.println("invalid");
            return;
        }
        if (this.count == -1) {
            Terminal.println("bottom");
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            Terminal.print(Integer.toString(this.values[i]) + " ");
        }
        Terminal.println("");
    }
}

