/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.util;

import avrora.Main;
import avrora.sim.Simulator;
import cck.text.Terminal;
import cck.util.Util;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public class InterruptScheduler {
    final Simulator simulator;
    final File schedFile;
    final StreamTokenizer tokens;
    private int currentLine;
    private final int maxInt;

    public InterruptScheduler(String fname, Simulator s) {
        this.simulator = s;
        this.maxInt = s.getInterpreter().getInterruptTable().getNumberOfInterrupts();
        Main.checkFileExists(fname);
        this.schedFile = new File(fname);
        this.currentLine = 1;
        try {
            Terminal.println("Loading interrupt schedule from " + this.schedFile + "...");
            FileReader inf_reader = new FileReader(this.schedFile);
            this.tokens = new StreamTokenizer(inf_reader);
            this.scheduleNextInterrupt();
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
    }

    private void scheduleNextInterrupt() {
        try {
            if (this.tokens.nextToken() != -1) {
                if (this.tokens.ttype != -2) {
                    throw Util.failure("interrupt schedule format expected integer in field 1, line " + this.currentLine + " of " + this.schedFile);
                }
                int vec = (int)this.tokens.nval;
                if (vec >= this.maxInt) {
                    throw Util.failure("interrupt schedule contains out-of-bounds interrupt vector " + vec + " in line " + this.currentLine + " of " + this.schedFile);
                }
                if (this.tokens.nextToken() != -2) {
                    throw Util.failure("interrupt schedule format expected integer in field 2, line " + this.currentLine + " of " + this.schedFile);
                }
                long time = (int)this.tokens.nval;
                this.scheduleInterrupt(vec, time);
                ++this.currentLine;
            }
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
    }

    private void scheduleInterrupt(int vector, long cycles) {
        long future = cycles - this.simulator.getClock().getCount();
        if (future < 0L) {
            throw Util.failure("tried to schedule an interrupt in the past; schedule not sorted?");
        }
        ScheduledInterrupt e = new ScheduledInterrupt(vector);
        this.simulator.insertEvent(e, future);
    }

    public class ScheduledInterrupt
    implements Simulator.Event {
        public final int vec;

        public ScheduledInterrupt(int i) {
            this.vec = i;
        }

        public void fire() {
            InterruptScheduler.this.simulator.forceInterrupt(this.vec);
            InterruptScheduler.this.scheduleNextInterrupt();
        }
    }
}

