/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.types;

import avrora.Main;
import avrora.core.LoadableProgram;
import avrora.sim.Simulation;
import avrora.sim.SimulatorThread;
import avrora.sim.platform.PinConnect;
import avrora.sim.platform.PlatformFactory;
import cck.text.StringUtil;
import cck.util.Option;
import cck.util.Options;
import cck.util.Util;
import java.util.Iterator;
import java.util.Random;

public class WiredSimulation
extends Simulation {
    public static String HELP = "The wired network simulation is used for simulating multiple nodes simultaneously. These nodes can communicate with each other over wires.";
    public final Option.List NODECOUNT = this.newOptionList("nodecount", "1", "This option is used to specify the number of nodes to be instantiated. The format is a list of integers, where each integer specifies the number of nodes to instantiate with each program supplied on the command line. For example, when set to \"1,2\" one node will be created with the first program loaded onto it, and two nodes created with the second program loaded onto them.");
    public final Option.Interval RANDOM_START = this.newOption("random-start", 0L, 0L, "This option inserts a random delay before starting each node in order to prevent artificial cycle-level synchronization. The starting delay is pseudo-randomly chosen with uniform distribution over the specified interval, which is measured in clock cycles. If the \"random-seed\" option is set to a non-zero value, then its value is used as the seed to the pseudo-random number generator.");
    public final Option.Long STAGGER_START = this.newOption("stagger-start", 0L, "This option causes the simulator to insert a progressively longer delay before starting each node in order to avoid artificial cycle-level synchronization between nodes. The starting times are staggered by the specified number of clock cycles. For example, if this option is given the value X, then node 0 will start at time 0, node 1 at time 1*X, node 2 at time 2*X, etc.");
    long stagger;
    PinConnect pinConnect = PinConnect.pinConnect;

    public WiredSimulation() {
        super("wired", HELP, null);
        this.synchronizer = this.pinConnect.synchronizer;
        this.addSection("WIRED SIMULATION OVERVIEW", this.help);
        this.addOptionSection("This simulation type supports simulating multiple nodes that communicate with each other over wires. There are options to specify how many of each type of node to instantiate, as well as the program to be loaded onto each node.", this.options);
        this.PLATFORM.setNewDefault("seres");
    }

    public Simulation.Node newNode(int id, PlatformFactory pf, LoadableProgram p) {
        return new WiredNode(id, pf, p);
    }

    public void process(Options o, String[] args) throws Exception {
        this.options.process(o);
        this.processMonitorList();
        if (args.length == 0) {
            Util.userError("Simulation error", "No program specified");
        }
        Main.checkFilesExist(args);
        PlatformFactory pf = this.getPlatform();
        this.createNodes(args, pf);
    }

    protected void instantiateNodes() {
        super.instantiateNodes();
        this.pinConnect.initializeConnections();
    }

    private void createNodes(String[] args, PlatformFactory pf) throws Exception {
        int cntr = 0;
        Iterator i = this.NODECOUNT.get().iterator();
        while (i.hasNext() && args.length > cntr) {
            String pname = args[cntr++];
            LoadableProgram lp = new LoadableProgram(pname);
            lp.load();
            int max = StringUtil.evaluateIntegerLiteral((String)i.next());
            for (int node = 0; node < max; ++node) {
                WiredNode n = (WiredNode)this.createNode(pf, lp);
                long r = this.processRandom();
                long s = this.processStagger();
                n.startup = r + s;
            }
        }
    }

    long processRandom() {
        long low = this.RANDOM_START.getLow();
        long size = this.RANDOM_START.getHigh() - low;
        long delay = 0L;
        if (size > 0L) {
            Random r = this.getRandom();
            delay = r.nextLong();
            if (delay < 0L) {
                delay = -delay;
            }
            delay %= size;
        }
        return low + delay;
    }

    long processStagger() {
        long st = this.stagger;
        this.stagger += this.STAGGER_START.get();
        return st;
    }

    protected class WiredNode
    extends Simulation.Node {
        long startup;

        WiredNode(int id, PlatformFactory pf, LoadableProgram p) {
            super(id, pf, p);
        }

        protected void instantiate() {
            this.createNode();
        }

        private void createNode() {
            this.thread = new SimulatorThread(this);
            super.instantiate();
            this.simulator.delay(this.startup);
        }

        protected void remove() {
        }
    }
}

