/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.types;

import avrora.Main;
import avrora.core.LoadableProgram;
import avrora.sim.Simulation;
import avrora.sim.clock.Synchronizer;
import avrora.sim.platform.PlatformFactory;
import cck.util.Options;
import cck.util.Util;

public class SingleSimulation
extends Simulation {
    protected static final String HELP = "The \"single\" simulation type corresponds to a standard simulation of a single microcontroller with a single program.";

    public SingleSimulation() {
        super("single", HELP, new Synchronizer.Single());
        this.addSection("SINGLE NODE SIMULATION OVERVIEW", this.help);
        this.addOptionSection("The most basic type of simulation, the single node simulation, is designed to simulate a single microcontroller running a single program. Help for specific options relating to simulating a single node is below.", this.options);
        this.MONITORS.setNewDefault("leds");
    }

    public void process(Options o, String[] args) throws Exception {
        this.options.process(o);
        this.processMonitorList();
        if (args.length == 0) {
            Util.userError("Simulation error", "No program specified");
        }
        if (args.length > 1) {
            Util.userError("Simulation error", "Single node simulation accepts only one program");
        }
        Main.checkFilesExist(args);
        LoadableProgram p = new LoadableProgram(args[0]);
        p.load();
        PlatformFactory pf = this.getPlatform();
        this.createNode(pf, p);
    }
}

