/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.types;

import avrora.Main;
import avrora.core.LoadableProgram;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.sim.AtmelInterpreter;
import avrora.sim.Simulation;
import avrora.sim.SimulatorThread;
import avrora.sim.clock.RippleSynchronizer;
import avrora.sim.platform.Platform;
import avrora.sim.platform.PlatformFactory;
import avrora.sim.platform.sensors.RandomSensorData;
import avrora.sim.platform.sensors.ReplaySensorData;
import avrora.sim.platform.sensors.Sensor;
import avrora.sim.radio.CC1000Radio;
import avrora.sim.radio.CC2420Radio;
import avrora.sim.radio.Medium;
import avrora.sim.radio.Noise;
import avrora.sim.radio.Radio;
import avrora.sim.radio.RadioModel;
import avrora.sim.radio.Topology;
import cck.text.StringUtil;
import cck.util.Arithmetic;
import cck.util.Option;
import cck.util.Options;
import cck.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class SensorSimulation
extends Simulation {
    public static String HELP = "The sensor network simulation is used for simulating multiple sensor nodes simultaneously. These nodes can communicate with each other wirelessly to exchange packets that include sensor data and routing information for a multi-hop network. Currently, only the \"mica2\" platform sensor nodes are supported.";
    public final Option.List NODECOUNT = this.newOptionList("nodecount", "1", "This option is used to specify the number of nodes to be instantiated. The format is a list of integers, where each integer specifies the number of nodes to instantiate with each program supplied on the command line. For example, when set to \"1,2\" one node will be created with the first program loaded onto it, and two nodes created with the second program loaded onto them.");
    public final Option.Str TOPOLOGY = this.newOption("topology", "", "This option can be used to specify the name of a file that contains information about the topology of the network. When this option is specified. the free space radio model will be used to model radio propagation.");
    public final Option.Str NOISE = this.newOption("noise", "", "This option can be used to specify the name of a file that contains a noise time trace. When this option is specifiedthe indoor radio model will be used to model radio propagation.");
    public final Option.Double RANGE = this.newOption("radio-range", 15.0, "This option, when used in conjunction with the -topology option, specifies the maximum range for radio communication between nodes. This simple idealized radius model will drop all communications between nodes whose distance is greater than this threshold value.");
    public final Option.Interval RANDOM_START = this.newOption("random-start", 0L, 0L, "This option inserts a random delay before starting each node in order to prevent artificial cycle-level synchronization. The starting delay is pseudo-randomly chosen with uniform distribution over the specified interval, which is measured in clock cycles. If the \"random-seed\" option is set to a non-zero value, then its value is used as the seed to the pseudo-random number generator.");
    public final Option.Long STAGGER_START = this.newOption("stagger-start", 0L, "This option causes the simulator to insert a progressively longer delay before starting each node in order to avoid artificial cycle-level synchronization between nodes. The starting times are staggered by the specified number of clock cycles. For example, if this option is given the value X, then node 0 will start at time 0, node 1 at time 1*X, node 2 at time 2*X, etc.");
    public final Option.List SENSOR_DATA = this.newOptionList("sensor-data", "", "This option accepts a list describing the input data for each sensor node. The format for each entry in this list is $sensor:$id:$data, where $sensor is the name of the sensor device such as \"light\", $id is the integer ID of the node, and $data is the name of a file or the special '.' character, indicating random data. A sensor data input file consists of an initial sensor reading which is interpreted as a 10-bit ADC result, then a list of time value pairs separated by whitespace; the sensor will continue returning the current value until the next (relative) time in seconds, and then the sensor will change to the new value. ");
    public final Option.Bool UPDATE_NODE_ID = this.newOption("update-node-id", true, "When this option is set, the sensor network simulator will attempt to update the node identifiers stored in the flash memory of the program. For TinyOS programs, this identifier is labelled \"TOS_LOCAL_ADDRESS\". For SOS programs, this identifier is called \"node_address\". When loading a program onto a node, the simulator will search for these labels, and if found, will update the word in flash with the node's ID number.");
    Topology topology;
    Noise noise;
    RadioModel radioModel;
    Medium cc2420_medium;
    Medium cc1000_medium;
    long stagger;

    public SensorSimulation() {
        super("sensor-network", HELP, null);
        this.addSection("SENSOR NETWORK SIMULATION OVERVIEW", this.help);
        this.addOptionSection("This simulation type supports simulating multiple sensor network nodes that communicate with each other over radios. There are options to specify how many of each type of sensor node to instantiate, as well as the program to be loaded onto each node, and an optional topology file that describes the physical layout of the sensor network. Also, each node's sensors can be supplied with random or replay sensor data through the \"sensor-data\" option.", this.options);
        this.PLATFORM.setNewDefault("micaz");
        this.MONITORS.setNewDefault("leds,packet");
    }

    public Simulation.Node newNode(int id, PlatformFactory pf, LoadableProgram p) {
        return new SensorNode(id, pf, p);
    }

    public void process(Options o, String[] args) throws Exception {
        this.options.process(o);
        this.processMonitorList();
        if (args.length == 0) {
            Util.userError("Simulation error", "No program specified");
        }
        Main.checkFilesExist(args);
        PlatformFactory pf = this.getPlatform();
        this.synchronizer = new RippleSynchronizer(100000L, null);
        this.createNodes(args, pf);
        this.processSensorInput();
        this.createNoise();
    }

    private void createNodes(String[] args, PlatformFactory pf) throws Exception {
        Iterator i = this.NODECOUNT.get().iterator();
        for (int arg = 0; arg < args.length; ++arg) {
            int count = i.hasNext() ? StringUtil.evaluateIntegerLiteral((String)i.next()) : 1;
            LoadableProgram lp = new LoadableProgram(args[arg]);
            lp.load();
            for (int node = 0; node < count; ++node) {
                SensorNode n = (SensorNode)this.createNode(pf, lp);
                long r = this.processRandom();
                long s = this.processStagger();
                n.startup = r + s;
            }
        }
    }

    private void createNoise() throws Exception {
        if (this.noise == null && !this.NOISE.isBlank()) {
            this.noise = new Noise(this.NOISE.get());
        } else if (this.noise == null && this.NOISE.isBlank()) {
            this.noise = new Noise();
        }
    }

    private void processSensorInput() {
        for (String str : this.SENSOR_DATA.get()) {
            int ind = str.indexOf(58);
            if (ind <= 0) {
                Util.userError("Sensor data format error", str);
            }
            String sensor = str.substring(0, ind);
            String rest = str.substring(ind + 1);
            int ind2 = rest.indexOf(58);
            if (ind2 <= 0) {
                Util.userError("Sensor data format error", str);
            }
            String id = rest.substring(0, ind2);
            String file = rest.substring(ind2 + 1);
            this.addSensorData(id, file, sensor);
        }
    }

    private void addSensorData(String id, String file, String sensor) {
        int num = StringUtil.evaluateIntegerLiteral(id);
        SensorNode node = (SensorNode)this.getNode(num);
        if (node != null) {
            SensorDataInput sdi = new SensorDataInput();
            sdi.fname = file;
            sdi.sensor = sensor;
            node.sensorInput.add(sdi);
            if (!".".equals(file)) {
                Main.checkFileExists(file);
            }
        }
    }

    long processRandom() {
        long low = this.RANDOM_START.getLow();
        long size = this.RANDOM_START.getHigh() - low;
        long delay = 0L;
        if (size > 0L) {
            Random r = this.getRandom();
            delay = r.nextLong();
            if (delay < 0L) {
                delay = -delay;
            }
            delay %= size;
        }
        return low + delay;
    }

    long processStagger() {
        long st = this.stagger;
        this.stagger += this.STAGGER_START.get();
        return st;
    }

    protected class SensorNode
    extends Simulation.Node {
        Radio radio;
        long startup;
        List sensorInput;

        SensorNode(int id, PlatformFactory pf, LoadableProgram p) {
            super(id, pf, p);
            this.sensorInput = new LinkedList();
        }

        protected void instantiate() {
            this.createNode();
            this.updateNodeID();
            this.addSensorData();
        }

        private void addSensorData() {
            for (SensorDataInput sdi : this.sensorInput) {
                sdi.instantiate(this.platform);
            }
        }

        private void createNode() {
            this.thread = new SimulatorThread(this);
            super.instantiate();
            Object dev = this.platform.getDevice("radio");
            if (dev instanceof CC2420Radio) {
                CC2420Radio radio = (CC2420Radio)dev;
                this.radio = radio;
                radio.setMedium(this.createCC2420Medium());
            } else if (dev instanceof CC1000Radio) {
                CC1000Radio radio = (CC1000Radio)dev;
                this.radio = radio;
                radio.setMedium(this.createCC1000Medium());
            }
            this.simulator.delay(this.startup);
            if (SensorSimulation.this.topology != null) {
                this.setNodePosition();
                return;
            }
        }

        private Medium createCC2420Medium() {
            if (SensorSimulation.this.cc2420_medium == null) {
                this.createRadioModel();
                SensorSimulation.this.cc2420_medium = CC2420Radio.createMedium(SensorSimulation.this.synchronizer, SensorSimulation.this.radioModel);
                return SensorSimulation.this.cc2420_medium;
            }
            return SensorSimulation.this.cc2420_medium;
        }

        private Medium createCC1000Medium() {
            if (SensorSimulation.this.cc1000_medium == null) {
                this.createRadioModel();
                SensorSimulation.this.cc1000_medium = CC1000Radio.createMedium(SensorSimulation.this.synchronizer, SensorSimulation.this.radioModel);
                return SensorSimulation.this.cc1000_medium;
            }
            return SensorSimulation.this.cc1000_medium;
        }

        private void createRadioModel() {
            if (SensorSimulation.this.topology == null && !SensorSimulation.this.TOPOLOGY.isBlank()) {
                try {
                    SensorSimulation.this.topology = new Topology(SensorSimulation.this.TOPOLOGY.get());
                    SensorSimulation.this.radioModel = new RadioModel();
                }
                catch (IOException e) {
                    throw Util.unexpected(e);
                }
            }
        }

        private void setNodePosition() {
            RadioModel.Position p = SensorSimulation.this.topology.getPosition(this.id);
            if (p != null && this.radio != null) {
                SensorSimulation.this.radioModel.setPosition(this.radio, p);
            }
        }

        private void updateNodeID() {
            Program p;
            SourceMapping smap;
            if (SensorSimulation.this.UPDATE_NODE_ID.get() && (smap = (p = this.path.getProgram()).getSourceMapping()) != null) {
                this.updateVariable(smap, "TOS_LOCAL_ADDRESS", this.id);
                this.updateVariable(smap, "node_address", this.id);
                this.updateVariable(smap, "TOS_NODE_ID", this.id);
                this.updateVariable(smap, "ActiveMessageAddressC$addr", this.id);
            }
        }

        private void updateVariable(SourceMapping smap, String name, int value) {
            SourceMapping.Location location = smap.getLocation(name);
            if (location == null) {
                location = smap.getLocation("node_address");
            }
            if (location != null) {
                AtmelInterpreter bi = (AtmelInterpreter)this.simulator.getInterpreter();
                bi.writeFlashByte(location.lma_addr, Arithmetic.low(value));
                bi.writeFlashByte(location.lma_addr + 1, Arithmetic.high(value));
            }
        }

        protected void remove() {
            SensorSimulation.this.synchronizer.removeNode(this);
        }
    }

    class SensorDataInput {
        String sensor;
        String fname;

        SensorDataInput() {
        }

        void instantiate(Platform p) {
            try {
                Sensor s = (Sensor)p.getDevice(this.sensor + "-sensor");
                if (s == null) {
                    Util.userError("Sensor device does not exist", this.sensor);
                }
                if (".".equals(this.fname)) {
                    s.setSensorData(new RandomSensorData(SensorSimulation.this.getRandom()));
                } else {
                    s.setSensorData(new ReplaySensorData(p.getMicrocontroller(), this.fname));
                }
            }
            catch (IOException e) {
                throw Util.unexpected(e);
            }
        }
    }
}

