/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.state;

import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.output.SimPrinter;
import avrora.sim.state.BooleanView;
import avrora.sim.state.Register;
import avrora.sim.state.RegisterView;
import avrora.sim.state.VolatileBehavior;
import cck.text.StringUtil;
import cck.util.Arithmetic;

public class RegisterUtil {
    public static BooleanView booleanView(RegisterView sup, int low) {
        return new BoolView(sup, (byte)low);
    }

    public static RegisterView bitView(RegisterView sup, int low) {
        return new BitRangeView(sup, (byte)low, (byte)low);
    }

    public static RegisterView bitRangeView(RegisterView sup, int low, int high) {
        return new BitRangeView(sup, (byte)low, (byte)high);
    }

    public static RegisterView permutedView(RegisterView sup, byte[] perm) {
        return new PermutedView(sup, perm);
    }

    public static RegisterView stackedView(RegisterView a, RegisterView b) {
        return new StackedView(new RegisterView[]{a, b});
    }

    public static RegisterView stackedView(RegisterView[] a) {
        return new StackedView(a);
    }

    public static void instrumentRegister(SimPrinter sp, Register reg, String name) {
        if (sp.enabled) {
            reg.addWatch(new RegisterPrinter(sp, name));
        }
    }

    public static class ReadonlyBehavior
    extends VolatileBehavior {
        public int write(int cur, int nv) {
            return cur;
        }
    }

    public static class ConstantBehavior
    extends VolatileBehavior {
        public final int value;

        public ConstantBehavior(int val) {
            this.value = val;
        }

        public int read(int cur) {
            return this.value;
        }

        public int write(int cur, int nv) {
            return this.value;
        }
    }

    public static class RegisterPrinter
    implements Register.Watch {
        protected final SimPrinter printer;
        protected final String name;

        public RegisterPrinter(SimPrinter p, String n) {
            this.printer = p;
            this.name = n;
        }

        public void fireAfterWrite(Register r, int oldv, int newv) {
            this.printer.println(this.name + "    <=   " + StringUtil.toMultirepString(newv, r.width));
        }

        public void fireAfterRead(Register r, int oldv, int newv) {
            this.printer.println(this.name + "    ->   " + StringUtil.toMultirepString(oldv, r.width));
        }
    }

    public static class TimedBuffer
    implements Register.Watch,
    Simulator.Event {
        protected final Clock clock;
        protected final Register r1;
        protected final Register r2;
        protected int value;
        protected long delay;

        public TimedBuffer(Clock c, Register a, Register b, long d) {
            this.clock = c;
            this.r1 = a;
            this.r2 = b;
            this.delay = d;
            this.r1.addWatch(this);
        }

        public void fireAfterWrite(Register r, int oldv, int newv) {
            this.value = newv;
            this.clock.insertEvent(this, this.delay);
        }

        public void fireAfterRead(Register r, int oldv, int newv) {
        }

        public void setDelay(long cycles) {
            this.delay = cycles;
        }

        public void fire() {
            this.r2.write(this.value);
        }
    }

    public static class StackedView
    implements RegisterView {
        protected final RegisterView[] regs;
        protected final int width;

        public StackedView(RegisterView[] r) {
            this.regs = r;
            int w = 0;
            for (int i = 0; i < r.length; ++i) {
                w += this.regs[i].getWidth();
            }
            this.width = w;
        }

        public int getWidth() {
            return this.width;
        }

        public int getValue() {
            int val = 0;
            int p = 0;
            for (int i = 0; i < this.regs.length; ++i) {
                RegisterView r = this.regs[i];
                val |= r.getValue() << p;
                p += r.getWidth();
            }
            return val;
        }

        public void setValue(int val) {
            int p = 0;
            for (int i = 0; i < this.regs.length; ++i) {
                RegisterView r = this.regs[i];
                r.setValue(val);
                val >>= (p += r.getWidth());
            }
        }
    }

    public static class PermutedView
    implements RegisterView {
        protected final RegisterView reg;
        protected final byte[] bits;

        public PermutedView(RegisterView r, byte[] b) {
            this.bits = b;
            this.reg = r;
        }

        public int getWidth() {
            return this.bits.length;
        }

        public int getValue() {
            int val = this.reg.getValue();
            int res = 0;
            for (int cntr = 0; cntr < this.bits.length; ++cntr) {
                int bit = val >> this.bits[cntr] & 1;
                res |= bit << cntr;
            }
            return res;
        }

        public void setValue(int val) {
            int res = this.reg.getValue();
            for (int cntr = 0; cntr < this.bits.length; ++cntr) {
                int nbit = val >> cntr & 1;
                res = res & ~(1 << this.bits[cntr]) | nbit << this.bits[cntr];
            }
            this.reg.setValue(res);
        }
    }

    public static class BitRangeView
    implements RegisterView {
        protected final RegisterView reg;
        protected final byte low;
        protected final byte width;
        protected final int mask;

        public BitRangeView(RegisterView r, byte l, byte h) {
            this.low = l;
            this.mask = Arithmetic.getBitRangeMask(l, h);
            this.width = (byte)(h - l + 1);
            this.reg = r;
        }

        public int getWidth() {
            return this.width;
        }

        public int getValue() {
            return (this.reg.getValue() & this.mask) >> this.low;
        }

        public void setValue(int val) {
            this.reg.setValue(this.reg.getValue() & ~this.mask | val << this.low & this.mask);
        }
    }

    public static class CharArrayView
    implements RegisterView {
        protected final char[] values;
        protected final int index;

        public CharArrayView(char[] v, int i) {
            this.values = v;
            this.index = i;
        }

        public int getWidth() {
            return 16;
        }

        public int getValue() {
            return this.values[this.index];
        }

        public void setValue(int val) {
            this.values[this.index] = (char)val;
        }
    }

    public static class ByteArrayView
    implements RegisterView {
        protected final byte[] values;
        protected final int index;

        public ByteArrayView(byte[] v, int i) {
            this.values = v;
            this.index = i;
        }

        public int getWidth() {
            return 8;
        }

        public int getValue() {
            return this.values[this.index];
        }

        public void setValue(int val) {
            this.values[this.index] = (byte)val;
        }
    }

    public static class BoolView
    implements BooleanView {
        protected final RegisterView reg;
        protected final byte low;

        public BoolView(RegisterView r, byte l) {
            this.reg = r;
            this.low = l;
        }

        public boolean getValue() {
            return (this.reg.getValue() >> this.low & 1) == 1;
        }

        public void setValue(boolean v) {
            if (v) {
                this.reg.setValue(this.reg.getValue() | 1 << this.low);
            } else {
                this.reg.setValue(this.reg.getValue() & ~(1 << this.low));
            }
        }
    }

    public static class Buffer {
        protected final Register r1;
        protected final Register r2;

        public Buffer(Register a, Register b) {
            this.r1 = a;
            this.r2 = b;
        }

        public void flush() {
            this.r2.write(this.r1.getValue());
        }
    }
}

