/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.state;

import avrora.sim.state.RegisterView;
import avrora.sim.state.VolatileBehavior;
import avrora.sim.util.TransactionalList;

public class Register
implements RegisterView {
    public final int width;
    public final int mask;
    protected int value;
    protected VolatileBehavior behavior;
    protected TransactionalList watches;

    public Register(int w) {
        this.width = w;
        this.mask = ~(-1 << w);
    }

    public void write(int newv) {
        int oldv = this.value;
        int n = this.value = this.behavior != null ? this.mask & this.behavior.write(this.value, newv) : (newv &= this.mask);
        if (this.watches != null) {
            this.watches.beginTransaction();
            TransactionalList.Link n2 = this.watches.getHead();
            while (n2 != null) {
                ((Watch)n2.object).fireAfterWrite(this, oldv, newv);
                n2 = n2.next;
            }
            this.watches.endTransaction();
        }
    }

    public int read() {
        int oldv = this.value;
        int newv = this.value;
        if (this.behavior != null) {
            this.value = newv = this.mask & this.behavior.read(this.value);
        }
        if (this.watches != null) {
            this.watches.beginTransaction();
            TransactionalList.Link n = this.watches.getHead();
            while (n != null) {
                ((Watch)n.object).fireAfterRead(this, oldv, newv);
                n = n.next;
            }
            this.watches.endTransaction();
        }
        return this.value;
    }

    public void setBehavior(VolatileBehavior b) {
        this.behavior = b;
    }

    public void setValue(int val) {
        this.value = val & this.mask;
    }

    public int getValue() {
        return this.value;
    }

    public int getWidth() {
        return this.width;
    }

    public void addWatch(Watch w) {
        if (this.watches == null) {
            this.watches = new TransactionalList();
        }
        this.watches.add(w);
    }

    public void removeWatch(Watch w) {
        this.watches.remove(w);
        if (this.watches.isEmpty()) {
            this.watches = null;
        }
    }

    protected static class NotifyItem {
        protected final Watch notify;
        protected NotifyItem next;

        protected NotifyItem(Watch n, NotifyItem nx) {
            this.notify = n;
            this.next = nx;
        }
    }

    public static interface Watch {
        public void fireAfterWrite(Register var1, int var2, int var3);

        public void fireAfterRead(Register var1, int var2, int var3);

        public static class Empty
        implements Watch {
            public void fireAfterWrite(Register r, int oldv, int newv) {
            }

            public void fireAfterRead(Register r, int oldv, int newv) {
            }
        }
    }
}

