/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.state;

import avrora.sim.state.BooleanView;
import avrora.sim.state.Register;
import avrora.sim.state.RegisterUtil;
import avrora.sim.state.RegisterView;
import cck.text.StringUtil;

public class NamedRegister
extends Register {
    public final String name;
    protected Printer head;
    protected Printer tail;

    public NamedRegister(String n, int w) {
        super(w);
        this.name = n;
    }

    public BooleanView booleanView(String n, int b) {
        BooleanView view = RegisterUtil.booleanView(this, b);
        if (n != null) {
            this.addPrinter(new BoolPrinter(n, view));
        }
        return view;
    }

    public RegisterView bitRangeView(String n, int l, int h) {
        RegisterView view = RegisterUtil.bitRangeView(this, l, h);
        if (n != null) {
            this.addPrinter(new RegPrinter(n, view));
        }
        return view;
    }

    public RegisterView permutedView(String n, byte[] perm) {
        RegisterView view = RegisterUtil.permutedView(this, perm);
        if (n != null) {
            this.addPrinter(new RegPrinter(n, view));
        }
        return view;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.name);
        buf.append(" = ");
        buf.append(StringUtil.toMultirepString(this.getValue(), this.getWidth()));
        if (this.head != null) {
            buf.append('(');
            Printer p = this.head;
            while (p != null) {
                p.print(buf);
                if (p.next != null) {
                    buf.append(", ");
                }
                p = p.next;
            }
            buf.append(')');
        }
        return buf.toString();
    }

    void addPrinter(Printer p) {
        if (this.head == null) {
            this.head = this.tail = p;
        } else {
            this.tail.next = p;
            this.tail = p;
        }
    }

    protected class BoolPrinter
    extends Printer {
        final BooleanView reg;

        BoolPrinter(String n, BooleanView r) {
            super(n);
            this.reg = r;
        }

        void print(StringBuffer buf) {
            buf.append(this.name);
            buf.append(" = ");
            buf.append(this.reg.getValue() ? "true" : "false");
        }
    }

    protected class RegPrinter
    extends Printer {
        final RegisterView reg;

        RegPrinter(String n, RegisterView r) {
            super(n);
            this.reg = r;
        }

        void print(StringBuffer buf) {
            buf.append(this.name);
            buf.append(" = ");
            buf.append(StringUtil.toMultirepString(this.reg.getValue(), this.reg.getWidth()));
        }
    }

    protected abstract class Printer {
        final String name;
        Printer next;

        abstract void print(StringBuffer var1);

        Printer(String n) {
            this.name = n;
        }
    }
}

