/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.state;

import java.util.Arrays;

public class ByteFIFO {
    protected final byte[] data;
    protected int head;
    protected int used;
    protected boolean underflow;
    protected boolean overflow;

    public ByteFIFO(int sz) {
        this.data = new byte[sz];
    }

    public void add(byte c) {
        if (this.full()) {
            this.overflow = true;
        } else {
            this.data[this.wrap((int)(this.head + this.used++))] = c;
        }
    }

    public byte remove() {
        byte b = 0;
        if (this.empty()) {
            this.underflow = true;
        } else {
            b = this.data[this.head];
            this.head = this.wrap(this.head + 1);
            --this.used;
        }
        return b;
    }

    public byte peek(int ind) {
        return this.data[this.wrap(this.head + ind)];
    }

    public byte[] peekField(int from, int to) {
        if (this.head + from < this.data.length && this.head + to == this.data.length) {
            return ByteFIFO.copyOfRange(this.data, this.wrap(this.head + from), this.head + to);
        }
        if (this.head + from < this.data.length && this.head + to > this.data.length) {
            byte[] r = new byte[to - from];
            System.arraycopy(this.data, this.wrap(this.head + from), r, 0, this.data.length - (this.head + from));
            System.arraycopy(this.data, 0, r, this.data.length - (this.head + from), this.wrap(this.head + to));
            return r;
        }
        return ByteFIFO.copyOfRange(this.data, this.wrap(this.head + from), this.wrap(this.head + to));
    }

    public byte poke(int ind, byte val) {
        int indx = this.wrap(this.head + ind);
        byte prev = this.data[indx];
        this.data[indx] = val;
        return prev;
    }

    public boolean underFlow() {
        return this.underflow;
    }

    public boolean overFlow() {
        return this.overflow;
    }

    public int capacity() {
        return this.data.length;
    }

    public int size() {
        return this.used;
    }

    public boolean full() {
        return this.used == this.data.length;
    }

    public boolean empty() {
        return this.used == 0;
    }

    public void clearFlags() {
        this.overflow = false;
        this.underflow = false;
    }

    public void refill() {
        this.overflow = false;
        this.underflow = false;
        this.head = 0;
        this.used = 0;
    }

    public void clear() {
        this.overflow = false;
        this.underflow = false;
        this.head = 0;
        this.used = 0;
        Arrays.fill(this.data, (byte)0);
    }

    private int wrap(int i) {
        if (i >= this.data.length) {
            return i - this.data.length;
        }
        return i;
    }

    public static byte[] copyOfRange(byte[] origin, int from, int to) {
        byte[] narray = new byte[to - from];
        for (int i = 0; i < narray.length; ++i) {
            narray[i] = origin[from + i];
        }
        return narray;
    }
}

