/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.radio;

import avrora.sim.radio.RadioModel;
import cck.util.Util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Topology {
    private final ArrayList nodes = new ArrayList();

    public Topology(String fileName) throws IOException {
        this.parse(new BufferedReader(new FileReader(fileName)));
    }

    private void parse(BufferedReader f) throws IOException {
        String line;
        while ((line = f.readLine()) != null) {
            this.parseLine(line);
        }
        f.close();
    }

    private void parseLine(String line) {
        String nodeName = "";
        double[] positions = new double[4];
        if (!line.startsWith("#")) {
            int count;
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            for (count = 0; tokenizer.hasMoreTokens() && count < 5; ++count) {
                try {
                    if (count == 0) {
                        nodeName = tokenizer.nextToken();
                        continue;
                    }
                    positions[count - 1] = Double.parseDouble(tokenizer.nextToken());
                    continue;
                }
                catch (NoSuchElementException e) {
                    throw Util.failure("Error reading topology tokens");
                }
            }
            if (count == 4) {
                this.nodes.add(new RadioModel.Position(positions[0], positions[1], positions[2], 0.0));
            } else if (count == 5) {
                this.nodes.add(new RadioModel.Position(positions[0], positions[1], positions[2], positions[3]));
            }
        }
    }

    public RadioModel.Position getPosition(int id) {
        return (RadioModel.Position)this.nodes.get(id);
    }
}

