/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.radio;

import avrora.sim.radio.Medium;
import avrora.sim.radio.Noise;
import avrora.sim.radio.Radio;
import avrora.sim.state.Complex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RadioModel
implements Medium.Arbitrator {
    protected static final double Sensitivity = -95.0;
    protected int TimeBefore = 0;
    protected final Map positions;
    protected final double a = Math.exp(-0.8333333333333334);
    protected final double u = Math.sqrt(1.0 - Math.pow(this.a, 2.0));
    protected double Csf;
    protected double Sf;
    protected boolean first = true;
    private static Random rn = new Random();

    public RadioModel() {
        this.positions = new HashMap();
    }

    public boolean lockTransmission(Medium.Receiver receiver, Medium.Transmission trans, int Milliseconds) {
        double dist = this.distance(trans.origin, receiver);
        double PowerRec = this.computeReceivedPower(trans, receiver, Milliseconds);
        int Pn = this.getNoise(Milliseconds);
        return PowerRec > -95.0 && PowerRec > (double)Pn;
    }

    public char mergeTransmissions(Medium.Receiver receiver, List it, long bit, int Milliseconds) {
        assert (it.size() > 0);
        boolean one = false;
        int value = 0;
        for (Medium.Transmission next : it) {
            if (!this.lockTransmission(receiver, next, Milliseconds)) continue;
            if (one) {
                int nval = 0xFF & next.getByteAtTime(bit);
                value |= nval << 8 ^ value << 8;
                value |= nval;
                continue;
            }
            one = true;
            value = 0xFF & next.getByteAtTime(bit);
        }
        assert (one);
        return (char)value;
    }

    public static double getGaussian(double mean, double std2) {
        return mean + std2 * rn.nextGaussian();
    }

    private double Rayleigh() {
        Complex c = new Complex(RadioModel.getGaussian(0.0, 1.0), RadioModel.getGaussian(0.0, 1.0));
        return Complex.abs(c);
    }

    private double Shadowing(double mean, double std2, int Milliseconds) {
        if (this.first) {
            this.first = false;
            this.Sf = RadioModel.getGaussian(mean, std2);
            return this.Sf;
        }
        if (Milliseconds < 1000) {
            this.Csf = this.Sf;
            return this.Csf;
        }
        if (Milliseconds - this.TimeBefore > 1000) {
            this.TimeBefore = Milliseconds;
            this.Csf = this.a * this.Csf + this.u * RadioModel.getGaussian(mean, std2);
            return this.Csf;
        }
        this.Csf = this.Csf;
        return this.Csf;
    }

    public void setPosition(Radio radio, double x, double y, double z, double rho) {
        Position pos = new Position(x, y, z, rho);
        this.positions.put(radio.getTransmitter(), pos);
        this.positions.put(radio.getReceiver(), pos);
    }

    public void setPosition(Radio radio, Position pos) {
        this.positions.put(radio.getTransmitter(), pos);
        this.positions.put(radio.getReceiver(), pos);
    }

    public int getNoise(int index) {
        if (Noise.sizeNoise() == 1) {
            return Noise.getNoise(0);
        }
        while (index > Noise.sizeNoise()) {
            index -= Noise.sizeNoise();
        }
        return Noise.getNoise(index);
    }

    protected double distance(Medium.Transmitter t, Medium.Receiver r) {
        double dist = 0.0;
        Position a = (Position)this.positions.get(t);
        Position b = (Position)this.positions.get(r);
        if (a != null && b != null) {
            double dx = a.x - b.x;
            double dy = a.y - b.y;
            double dz = a.z - b.z;
            dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
        return dist;
    }

    protected double densityObstacles(Medium.Transmitter t, Medium.Receiver r) {
        double rho = 0.0;
        Position a = (Position)this.positions.get(t);
        Position b = (Position)this.positions.get(r);
        if (a != null && b != null) {
            rho = Math.max(a.rho, b.rho);
        }
        return rho;
    }

    public double computeReceivedPower(Medium.Transmission t, Medium.Receiver receiver, int Milliseconds) {
        double p = this.densityObstacles(t.origin, receiver);
        double d = this.distance(t.origin, receiver);
        double A = Math.pow(1.0 - p, 0.2 * d);
        double n = 3.0;
        double PathLoss = 55.0;
        if (d > 1.0) {
            PathLoss += 10.0 * n * Math.log10(d);
        }
        double L_Rayleigh = this.Rayleigh();
        int k = 6;
        double L_Rician = L_Rayleigh / Math.sqrt(k) + 1.0;
        double std2 = Math.log10(55.0 * d * p + 1.0) / Math.log10(7.0) + 0.5;
        double mean = Math.pow(3.0 * d * p, 0.7);
        double s = this.Shadowing(mean, std2, Milliseconds);
        double Lsf = Math.pow(10.0, s / 20.0);
        double Fading = 10.0 * Math.log10(A * L_Rician + (1.0 - A) * (Lsf * L_Rayleigh));
        return t.Pt - Fading - PathLoss;
    }

    public static final class noise {
        public final ArrayList noise;

        public noise(ArrayList noise2) {
            this.noise = noise2;
        }
    }

    public static final class Position {
        public final double x;
        public final double y;
        public final double z;
        public final double rho;

        public Position(double x, double y, double z, double rho) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.rho = rho;
        }
    }
}

