/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.radio;

import cck.util.Util;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Noise {
    private static List<Integer> noise = new ArrayList<Integer>();

    public Noise(String fileName) throws FileNotFoundException, IOException {
        this.parse(new BufferedReader(new FileReader(fileName)));
    }

    public Noise() {
        noise.add(-95);
    }

    private void parse(BufferedReader f) throws IOException {
        String line;
        while ((line = f.readLine()) != null) {
            this.parseLine(line);
        }
        f.close();
    }

    private void parseLine(String line) {
        int noise_value = 0;
        if (!line.startsWith("#")) {
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            int count = 0;
            while (tokenizer.hasMoreTokens()) {
                try {
                    if (count == 0) {
                        noise_value = Integer.parseInt(tokenizer.nextToken());
                    }
                    ++count;
                }
                catch (NoSuchElementException e) {
                    throw Util.failure("Error reading Noise file");
                }
            }
            if (count == 1) {
                noise.add(noise_value);
            }
        }
    }

    public static int getNoise(int index) {
        return noise.get(index);
    }

    public static int sizeNoise() {
        return noise.size();
    }
}

