/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.radio;

import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.Synchronizer;
import avrora.sim.util.TransactionalList;
import cck.util.Arithmetic;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Medium {
    private static final int BYTE_SIZE = 8;
    private static int Pn = -95;
    private static double Pr = Pn;
    public final Synchronizer synch;
    public final Arbitrator arbitrator;
    public final int bitsPerSecond;
    public final int leadBits;
    public final int minLength;
    public final int maxLength;
    protected List transmissions = new LinkedList();

    public Medium(Synchronizer synch, Arbitrator arb, int bps, int ltb, int mintl, int maxtl) {
        this.synch = synch;
        this.bitsPerSecond = bps;
        this.leadBits = ltb;
        this.minLength = mintl;
        this.maxLength = maxtl;
        this.arbitrator = arb == null ? new BasicArbitrator() : arb;
    }

    protected synchronized Transmission newTransmission(Transmitter o, double p, double f) {
        Transmission tx = new Transmission(o, p, f);
        this.transmissions.add(tx);
        return tx;
    }

    public static boolean isCorruptedByte(char c) {
        return (c & 0xFF00) != 0;
    }

    public static byte getCorruptedBits(char c) {
        return (byte)(c >> 8);
    }

    public static byte getTransmittedBits(char c) {
        return (byte)c;
    }

    public class Transmission {
        public final Transmitter origin;
        public final long start;
        public final long firstBit;
        public final double power;
        public final double Pt;
        public final double f;
        public long lastBit;
        public long end;
        protected int counter;
        protected byte[] data;

        protected Transmission(Transmitter o, double pow, double freq) {
            this.origin = o;
            this.power = pow;
            this.Pt = pow;
            this.f = freq;
            this.start = o.clock.getCount();
            this.end = Long.MAX_VALUE;
            long l = this.start + o.leadCycles;
            this.firstBit = this.origin.getBitNum(l);
            this.lastBit = Long.MAX_VALUE;
            this.data = new byte[Arithmetic.roundup(o.medium.maxLength, 8)];
        }

        public void end() {
            this.end = this.origin.clock.getCount();
            this.lastBit = this.firstBit + (long)(this.counter * 8);
        }

        public byte getByteAtTime(long bit) {
            assert (bit >= this.firstBit);
            int offset = (int)(bit - this.firstBit);
            int shift = offset & 7;
            int indx = offset / 8;
            int hi = 0xFF & this.data[indx] << shift;
            if (shift > 0) {
                int low = 0xFF & this.data[1 + indx];
                return (byte)(hi | low >> 8 - shift);
            }
            return (byte)hi;
        }
    }

    public static class BasicArbitrator
    implements Arbitrator {
        public boolean lockTransmission(Receiver receiver, Transmission trans, int Milliseconds) {
            return true;
        }

        public char mergeTransmissions(Receiver receiver, List it, long bit, int Milliseconds) {
            assert (it.size() > 0);
            Iterator i = it.iterator();
            Transmission first = (Transmission)i.next();
            int value = 0xFF & first.getByteAtTime(bit);
            while (i.hasNext()) {
                Transmission next = (Transmission)i.next();
                int nval = 0xFF & next.getByteAtTime(bit);
                value |= nval << 8 ^ value << 8;
                value |= nval;
            }
            return (char)value;
        }

        public double computeReceivedPower(Transmission t, Receiver receiver, int Milliseconds) {
            return Pr;
        }

        public int getNoise(int index) {
            return Pn;
        }
    }

    public static abstract class Receiver
    extends TXRX {
        private static final int BIT_DELAY = 1;
        protected boolean locked;
        public Ticker ticker = new Ticker();
        public SampleRSSI sample = new SampleRSSI();

        protected Receiver(Medium m, Clock c) {
            super(m, c);
        }

        public final void beginReceive() {
            if (!this.activated) {
                this.activated = true;
                this.clock.insertEvent(this.sample, 8L * this.cyclesPerByte);
                this.clock.insertEvent(this.ticker, this.leadCycles + this.cyclesPerByte);
            }
        }

        public final void endReceive() {
            this.activated = false;
            this.locked = false;
            this.clock.removeEvent(this.ticker);
            this.clock.removeEvent(this.sample);
        }

        public abstract byte nextByte(boolean var1, byte var2);

        public abstract void setRssiValid(boolean var1);

        public abstract boolean getRssiValid();

        public abstract void setRSSI(double var1);

        public abstract void setBER(double var1);

        public final boolean isChannelClear(int RSSI_reg, int MDMCTRL0_reg) {
            int cca_mode = (MDMCTRL0_reg & 0xC0) >>> 6;
            if (!this.activated) {
                long time = this.clock.getCount();
                long bit = this.getBitNum(time) - 1L;
                this.waitForNeighbors(time - this.cyclesPerByte);
                List it = this.getIntersection(bit - 8L);
                if (it != null) {
                    boolean one = false;
                    double rssi = 0.0;
                    assert (it.size() > 0);
                    for (Transmission t : it) {
                        if (one) {
                            double I = this.medium.arbitrator.computeReceivedPower(t, this, (int)this.clock.cyclesToMillis(this.clock.getCount()));
                            rssi = 10.0 * Math.log10(Math.pow(10.0, rssi / 10.0) + Math.pow(10.0, I / 10.0));
                            continue;
                        }
                        one = true;
                        Pr = this.medium.arbitrator.computeReceivedPower(t, this, (int)this.clock.cyclesToMillis(this.clock.getCount()));
                        Pn = this.medium.arbitrator.getNoise((int)this.clock.cyclesToMillis(this.clock.getCount()));
                        rssi = Pr;
                    }
                    if (cca_mode == 1 | cca_mode == 3) {
                        int rssi_val = (int)rssi + 45;
                        int cca_thr = ((RSSI_reg & 0xFF00) >>> 8) - 256;
                        int cca_hyst = (MDMCTRL0_reg & 0x700) >>> 8;
                        return rssi_val < cca_thr - cca_hyst;
                    }
                    return it != null;
                }
                return it != null;
            }
            return !this.locked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Transmission earliestNewTransmission(long bit) {
            Transmission tx = null;
            Medium medium = this.medium;
            synchronized (medium) {
                Iterator i = this.medium.transmissions.iterator();
                while (i.hasNext()) {
                    Transmission t = (Transmission)i.next();
                    if (bit <= t.firstBit && this.medium.arbitrator.lockTransmission(this, t, (int)this.clock.cyclesToMillis(this.clock.getCount()))) {
                        if (tx == null) {
                            tx = t;
                            continue;
                        }
                        if (t.firstBit >= tx.firstBit) continue;
                        tx = t;
                        continue;
                    }
                    if (bit - 8L - (long)(2 * this.medium.leadBits) <= t.lastBit) continue;
                    i.remove();
                }
            }
            return tx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getIntersection(long bit) {
            LinkedList<Transmission> it = null;
            Medium medium = this.medium;
            synchronized (medium) {
                for (Transmission t : this.medium.transmissions) {
                    if (!this.intersect(bit, t)) continue;
                    if (it == null) {
                        it = new LinkedList<Transmission>();
                    }
                    it.add(t);
                }
            }
            return it;
        }

        private boolean intersect(long bit, Transmission t) {
            return bit >= t.firstBit && bit < t.lastBit;
        }

        private void waitForNeighbors(long gtime) {
            if (this.medium.synch != null) {
                this.medium.synch.waitForNeighbors(gtime);
            }
        }

        protected class SampleRSSI
        implements Simulator.Event {
            protected SampleRSSI() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fire() {
                assert (Receiver.this.medium.transmissions.size() > 0);
                boolean one = false;
                double SNR = 0.0;
                double BER = 0.0;
                long time = Receiver.this.clock.getCount();
                if (Receiver.this.getRssiValid()) {
                    Receiver.this.waitForNeighbors(time - Receiver.this.cyclesPerByte);
                    Medium medium = Receiver.this.medium;
                    synchronized (medium) {
                        for (Transmission t : Receiver.this.medium.transmissions) {
                            double rssi;
                            if (one) {
                                double I = Receiver.this.medium.arbitrator.computeReceivedPower(t, Receiver.this, (int)Receiver.this.clock.cyclesToMillis(Receiver.this.clock.getCount()));
                                rssi = 10.0 * Math.log10(Math.pow(10.0, Pr / 10.0) + Math.pow(10.0, I / 10.0));
                                SNR -= I;
                            } else {
                                one = true;
                                Pr = Receiver.this.medium.arbitrator.computeReceivedPower(t, Receiver.this, (int)Receiver.this.clock.cyclesToMillis(Receiver.this.clock.getCount()));
                                Pn = Receiver.this.medium.arbitrator.getNoise((int)Receiver.this.clock.cyclesToMillis(Receiver.this.clock.getCount()));
                                rssi = Pr;
                                SNR = Pr - (double)Pn;
                                if (SNR < 0.0) {
                                    SNR = 0.0;
                                }
                            }
                            double snr = Math.pow(10.0, SNR / 10.0);
                            double ebno = snr / Math.log(1.0 + snr);
                            double x = Math.sqrt(2.0 * ebno);
                            double x2 = Math.pow(x, 2.0);
                            BER = Math.exp(-x2 / 2.0) / (1.64 * x + Math.sqrt(0.76 * x2 + 4.0));
                            Receiver.this.setRSSI(rssi);
                        }
                    }
                } else if (Receiver.this.activated) {
                    Receiver.this.setRssiValid(true);
                }
            }
        }

        protected class Ticker
        implements Simulator.Event {
            protected Ticker() {
            }

            public void fire() {
                if (Receiver.this.activated) {
                    if (Receiver.this.locked) {
                        this.fireLocked(Receiver.this.clock.getCount());
                    } else {
                        this.fireUnlocked(Receiver.this.clock.getCount());
                    }
                }
            }

            private void fireUnlocked(long time) {
                long oneBitBeforeNow = Receiver.this.getBitNum(time) - 1L;
                Receiver.this.waitForNeighbors(time - Receiver.this.cyclesPerByte);
                Transmission tx = Receiver.this.earliestNewTransmission(oneBitBeforeNow - 8L);
                if (tx != null) {
                    long dcycle = Receiver.this.getCycleTime(tx.firstBit + 8L + 1L);
                    long delta = dcycle - time;
                    if (delta <= 0L) {
                        Receiver.this.locked = true;
                        this.deliverByte(oneBitBeforeNow);
                        return;
                    }
                    if (delta < Receiver.this.leadCycles) {
                        Receiver.this.locked = true;
                        Receiver.this.clock.insertEvent(this, delta);
                        return;
                    }
                    if (delta < Receiver.this.leadCycles + Receiver.this.cyclesPerByte) {
                        Receiver.this.clock.insertEvent(this, delta);
                        return;
                    }
                }
                Receiver.this.clock.insertEvent(this, Receiver.this.leadCycles);
            }

            private void fireLocked(long time) {
                long oneBitBeforeNow = Receiver.this.getBitNum(time) - 1L;
                Receiver.this.waitForNeighbors(time - Receiver.this.cyclesPerByte);
                this.deliverByte(oneBitBeforeNow);
            }

            private void deliverByte(long oneBitBeforeNow) {
                List it = Receiver.this.getIntersection(oneBitBeforeNow - 8L);
                if (it != null) {
                    boolean one = false;
                    double rssi = 0.0;
                    double SNR = 0.0;
                    double BER = 0.0;
                    assert (it.size() > 0);
                    for (Transmission t : it) {
                        if (one) {
                            double I = Receiver.this.medium.arbitrator.computeReceivedPower(t, Receiver.this, (int)Receiver.this.clock.cyclesToMillis(Receiver.this.clock.getCount()));
                            rssi = 10.0 * Math.log10(Math.pow(10.0, rssi / 10.0) + Math.pow(10.0, I / 10.0));
                            SNR -= I;
                        } else {
                            one = true;
                            Pr = Receiver.this.medium.arbitrator.computeReceivedPower(t, Receiver.this, (int)Receiver.this.clock.cyclesToMillis(Receiver.this.clock.getCount()));
                            Pn = Receiver.this.medium.arbitrator.getNoise((int)Receiver.this.clock.cyclesToMillis(Receiver.this.clock.getCount()));
                            rssi = Pr;
                            SNR = Pr - (double)Pn;
                        }
                        double snr = Math.pow(10.0, SNR / 10.0);
                        double ebno = snr / Math.log(1.0 + snr);
                        double x = Math.sqrt(2.0 * ebno);
                        double x2 = Math.pow(x, 2.0);
                        BER = Math.exp(-x2 / 2.0) / (1.64 * x + Math.sqrt(0.76 * x2 + 4.0));
                        Receiver.this.setBER(BER);
                        Receiver.this.setRSSI(rssi);
                    }
                    Receiver.this.clock.insertEvent(Receiver.this.sample, Receiver.this.cyclesPerByte / 2L);
                    char val = Receiver.this.medium.arbitrator.mergeTransmissions(Receiver.this, it, oneBitBeforeNow - 8L, (int)Receiver.this.clock.cyclesToMillis(Receiver.this.clock.getCount()));
                    int hval = val >>> 8;
                    int value = 0xFF & Receiver.this.nextByte(true, (byte)val);
                    value |= hval & value << 8;
                    val = (char)(value |= hval);
                    if (Receiver.this.probeList != null) {
                        Receiver.this.probeList.fireAfterReceive(Receiver.this, val);
                    }
                    Receiver.this.clock.insertEvent(this, Receiver.this.cyclesPerByte);
                } else {
                    Receiver.this.clock.removeEvent(Receiver.this.sample);
                    Receiver.this.locked = false;
                    Receiver.this.nextByte(false, (byte)0);
                    if (Receiver.this.probeList != null) {
                        Receiver.this.probeList.fireAfterReceiveEnd(Receiver.this);
                    }
                    Receiver.this.clock.insertEvent(this, Receiver.this.leadCycles + Receiver.this.cyclesPerByte);
                }
            }
        }
    }

    public static abstract class Transmitter
    extends TXRX {
        protected Transmission transmission;
        protected final Ticker ticker = new Ticker();
        protected boolean shutdown;

        protected Transmitter(Medium m, Clock c) {
            super(m, c);
        }

        public final void beginTransmit(double pow, double freq) {
            if (!this.activated) {
                this.transmission = this.medium.newTransmission(this, pow, freq);
                this.activated = true;
                this.clock.insertEvent(this.ticker, this.leadCycles);
            }
        }

        public final void endTransmit() {
            if (this.activated) {
                this.shutdown = true;
                this.transmission.end();
            }
        }

        public abstract byte nextByte();

        protected class Ticker
        implements Simulator.Event {
            protected Ticker() {
            }

            public void fire() {
                if (Transmitter.this.shutdown) {
                    if (Transmitter.this.probeList != null) {
                        Transmitter.this.probeList.fireBeforeTransmitEnd(Transmitter.this);
                    }
                    Transmitter.this.transmission = null;
                    Transmitter.this.shutdown = false;
                    Transmitter.this.activated = false;
                } else if (Transmitter.this.activated) {
                    byte val;
                    int indx = Transmitter.this.transmission.counter++;
                    Transmitter.this.transmission.data[indx] = val = Transmitter.this.nextByte();
                    if (Transmitter.this.probeList != null) {
                        Transmitter.this.probeList.fireBeforeTransmit(Transmitter.this, val);
                    }
                    Transmitter.this.clock.insertEvent(this, Transmitter.this.cyclesPerByte);
                }
            }
        }
    }

    protected static class TXRX {
        public final Medium medium;
        public final Clock clock;
        public final long cyclesPerByte;
        public final long leadCycles;
        public final long cyclesPerBit;
        protected Probe.List probeList;
        public boolean activated;

        protected TXRX(Medium m, Clock c) {
            this.medium = m;
            this.clock = c;
            long hz = c.getHZ();
            int bps = this.medium.bitsPerSecond;
            assert (hz > (long)bps);
            this.cyclesPerBit = hz / (long)bps;
            this.cyclesPerByte = 8L * this.cyclesPerBit;
            this.leadCycles = (long)this.medium.leadBits * hz / (long)bps;
        }

        protected long getBitNum(long time) {
            return time / this.cyclesPerBit;
        }

        protected long getCycleTime(long bit) {
            return bit * this.cyclesPerBit;
        }

        public void insertProbe(Probe probe) {
            if (this.probeList == null) {
                this.probeList = new Probe.List();
            }
            this.probeList.add(probe);
        }

        public void removeProbe(Probe probe) {
            if (this.probeList != null) {
                this.probeList.remove(probe);
            }
        }
    }

    public static interface Probe {
        public void fireBeforeTransmit(Transmitter var1, byte var2);

        public void fireBeforeTransmitEnd(Transmitter var1);

        public void fireAfterReceive(Receiver var1, char var2);

        public void fireAfterReceiveEnd(Receiver var1);

        public static class List
        extends TransactionalList
        implements Probe {
            public void fireBeforeTransmit(Transmitter t, byte val) {
                this.beginTransaction();
                TransactionalList.Link pos = this.head;
                while (pos != null) {
                    ((Probe)pos.object).fireBeforeTransmit(t, val);
                    pos = pos.next;
                }
                this.endTransaction();
            }

            public void fireBeforeTransmitEnd(Transmitter t) {
                this.beginTransaction();
                TransactionalList.Link pos = this.head;
                while (pos != null) {
                    ((Probe)pos.object).fireBeforeTransmitEnd(t);
                    pos = pos.next;
                }
                this.endTransaction();
            }

            public void fireAfterReceive(Receiver r, char val) {
                this.beginTransaction();
                TransactionalList.Link pos = this.head;
                while (pos != null) {
                    ((Probe)pos.object).fireAfterReceive(r, val);
                    pos = pos.next;
                }
                this.endTransaction();
            }

            public void fireAfterReceiveEnd(Receiver r) {
                this.beginTransaction();
                TransactionalList.Link pos = this.head;
                while (pos != null) {
                    ((Probe)pos.object).fireAfterReceiveEnd(r);
                    pos = pos.next;
                }
                this.endTransaction();
            }
        }

        public static class Empty
        implements Probe {
            public void fireBeforeTransmit(Transmitter t, byte val) {
            }

            public void fireBeforeTransmitEnd(Transmitter t) {
            }

            public void fireAfterReceive(Receiver r, char val) {
            }

            public void fireAfterReceiveEnd(Receiver r) {
            }
        }
    }

    public static interface Arbitrator {
        public boolean lockTransmission(Receiver var1, Transmission var2, int var3);

        public char mergeTransmissions(Receiver var1, List var2, long var3, int var5);

        public double computeReceivedPower(Transmission var1, Receiver var2, int var3);

        public int getNoise(int var1);
    }
}

