/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.radio;

import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.Synchronizer;
import avrora.sim.energy.Energy;
import avrora.sim.mcu.ADC;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.mcu.SPI;
import avrora.sim.mcu.SPIDevice;
import avrora.sim.output.SimPrinter;
import avrora.sim.radio.CC2420Energy;
import avrora.sim.radio.Medium;
import avrora.sim.radio.Radio;
import avrora.sim.state.BooleanRegister;
import avrora.sim.state.BooleanView;
import avrora.sim.state.ByteFIFO;
import avrora.sim.state.Register;
import avrora.sim.state.RegisterUtil;
import avrora.sim.state.RegisterView;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.util.Arithmetic;
import cck.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class CC2420Radio
implements Radio {
    public static final int MAIN = 16;
    public static final int MDMCTRL0 = 17;
    public static final int MDMCTRL1 = 18;
    public static final int RSSI = 19;
    public static final int SYNCWORD = 20;
    public static final int TXCTRL = 21;
    public static final int RXCTRL0 = 22;
    public static final int RXCTRL1 = 23;
    public static final int FSCTRL = 24;
    public static final int SECCTRL0 = 25;
    public static final int SECCTRL1 = 26;
    public static final int BATTMON = 27;
    public static final int IOCFG0 = 28;
    public static final int IOCFG1 = 29;
    public static final int MANFIDL = 30;
    public static final int MANFIDH = 31;
    public static final int FSMTC = 32;
    public static final int MANAND = 33;
    public static final int MANOR = 34;
    public static final int AGCCTRL0 = 35;
    public static final int AGCTST0 = 36;
    public static final int AGCTST1 = 37;
    public static final int AGCTST2 = 38;
    public static final int FSTST0 = 39;
    public static final int FSTST1 = 40;
    public static final int FSTST2 = 41;
    public static final int FSTST3 = 42;
    public static final int RXBPFTST = 43;
    public static final int FSMSTATE = 44;
    public static final int ADCTST = 45;
    public static final int DACTST = 46;
    public static final int TOPTST = 47;
    public static final int TXFIFO = 62;
    public static final int RXFIFO = 63;
    public static final int SNOP = 0;
    public static final int SXOSCON = 1;
    public static final int STXCAL = 2;
    public static final int SRXON = 3;
    public static final int STXON = 4;
    public static final int STXONCCA = 5;
    public static final int SRFOFF = 6;
    public static final int SXOSCOFF = 7;
    public static final int SFLUSHRX = 8;
    public static final int SFLUSHTX = 9;
    public static final int SACK = 10;
    public static final int SACKPEND = 11;
    public static final int SRXDEC = 12;
    public static final int STXENC = 13;
    public static final int SAES = 14;
    private static final int NUM_REGISTERS = 64;
    private static final int FIFO_SIZE = 128;
    private static final int RAMSECURITYBANK_SIZE = 113;
    private static final int XOSC_START_TIME = 1000;
    protected final Microcontroller mcu;
    protected final Simulator sim;
    protected final int xfreq;
    protected final char[] registers = new char[64];
    protected final byte[] RAMSecurityRegisters = new byte[113];
    protected final ByteFIFO txFIFO = new ByteFIFO(128);
    protected final ByteFIFO rxFIFO = new ByteFIFO(128);
    protected List<Double> BERlist = new ArrayList<Double>();
    protected Medium medium;
    protected Transmitter transmitter;
    protected Receiver receiver;
    protected final Register statusRegister = new Register(8);
    protected boolean startingOscillator;
    protected boolean SRXDEC_switched;
    protected boolean STXENC_switched;
    protected final BooleanView oscStable = RegisterUtil.booleanView(this.statusRegister, 6);
    protected final BooleanView txUnderflow = RegisterUtil.booleanView(this.statusRegister, 5);
    protected final BooleanView txActive = RegisterUtil.booleanView(this.statusRegister, 3);
    protected final BooleanView signalLock = RegisterUtil.booleanView(this.statusRegister, 2);
    protected final BooleanView rssiValid = RegisterUtil.booleanView(this.statusRegister, 1);
    protected final RegisterView MDMCTRL0_reg = new RegisterUtil.CharArrayView(this.registers, 17);
    protected final BooleanView autoACK = RegisterUtil.booleanView(this.MDMCTRL0_reg, 4);
    protected final BooleanView autoCRC = RegisterUtil.booleanView(this.MDMCTRL0_reg, 5);
    protected final BooleanView ADR_DECODE = RegisterUtil.booleanView(this.MDMCTRL0_reg, 11);
    protected final BooleanView PAN_COORDINATOR = RegisterUtil.booleanView(this.MDMCTRL0_reg, 12);
    protected final BooleanView RESERVED_FRAME_MODE = RegisterUtil.booleanView(this.MDMCTRL0_reg, 13);
    protected final RegisterView IOCFG0_reg = new RegisterUtil.CharArrayView(this.registers, 28);
    protected final BooleanView BCN_ACCEPT = RegisterUtil.booleanView(this.IOCFG0_reg, 11);
    protected final BooleanView CCA_assessor = new ClearChannelAssessor();
    protected BooleanView SFD_value = new BooleanRegister();
    public final CC2420Pin SCLK_pin = new CC2420Pin("SCLK");
    public final CC2420Pin MISO_pin = new CC2420Pin("MISO");
    public final CC2420Pin MOSI_pin = new CC2420Pin("MOSI");
    public final CC2420Pin CS_pin = new CC2420Pin("CS");
    public final CC2420Output FIFO_pin = new CC2420Output("FIFO", new BooleanRegister());
    public final CC2420Output FIFOP_pin = new CC2420Output("FIFOP", new BooleanRegister());
    public final CC2420Output CCA_pin = new CC2420Output("CCA", this.CCA_assessor);
    public final CC2420Output SFD_pin = new CC2420Output("SFD", this.SFD_value);
    public final SPIInterface spiInterface = new SPIInterface();
    public final ADCInterface adcInterface = new ADCInterface();
    public int FIFOP_interrupt = -1;
    protected final SimPrinter printer;
    protected boolean FIFO_active;
    protected boolean FIFOP_active;
    protected boolean CCA_active;
    protected boolean SFD_active;
    protected boolean SendAck;
    protected boolean SendAckPend;
    protected byte DSN;
    protected byte[] PANId;
    protected byte[] macPANId;
    protected byte[] ShortAddr;
    protected byte[] macShortAddr;
    protected static final byte[] SHORT_BROADCAST_ADDR = new byte[]{15, 15};
    protected byte[] LongAdr;
    protected byte[] IEEEAdr;
    protected static final byte[] LONG_BROADCAST_ADDR = new byte[]{15, 15, 15, 15, 15, 15, 15, 15};
    protected static final double[] POWER_dBm = new double[]{-37.917, -32.984, -28.697, -25.0, -21.837, -19.153, -16.893, -15.0, -13.42, -12.097, -10.975, -10.0, -9.1238, -8.3343, -7.6277, -7.0, -6.4442, -5.9408, -5.467, -5.0, -4.5212, -4.0275, -3.5201, -3.0, -2.4711, -1.9492, -1.4526, -1.0, -0.6099, -0.3008, -0.0914, 0.0};
    protected static final int[] Corr_MAX = new int[]{110, 109, 109, 109, 107, 107, 107, 107, 107, 107, 107, 107, 103, 102, 102, 102, 101, 101, 101, 101, 99, 94, 92, 94, 101, 97, 98, 97, 97, 97, 97, 97, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 92, 89, 89, 89, 89, 89, 88, 88, 88, 88, 88, 86, 86, 86, 86, 86, 86, 86, 86, 86, 85, 85, 85, 85, 85, 85, 83, 83, 83, 83, 83, 83, 83, 83, 79, 78, 78, 78, 78, 78, 76, 76, 76, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 66, 65, 65, 65};
    protected static final int[] Corr_MIN = new int[]{95, 95, 94, 91, 90, 90, 89, 89, 89, 88, 88, 88, 82, 82, 82, 82, 76, 76, 76, 76, 76, 76, 74, 74, 74, 74, 74, 74, 72, 72, 72, 72, 72, 72, 72, 72, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 67, 67, 67, 67, 67, 67, 65, 65, 65, 65, 65, 65, 65, 64, 64, 63, 63, 63, 63, 63, 63, 63, 63, 63, 61, 61, 61, 60, 60, 60, 58, 58, 56, 56, 56, 55, 55, 55, 50, 50, 50, 50, 50, 50, 50};
    protected double Correlation;
    protected static final String[] allModeNames = CC2420Energy.allModeNames();
    protected static final int[][] ttm = FiniteStateMachine.buildSparseTTM(allModeNames.length, 0);
    protected final FiniteStateMachine stateMachine;
    protected boolean ClearFlag;
    protected static final int CMD_R_REG = 0;
    protected static final int CMD_W_REG = 1;
    protected static final int CMD_R_RX = 2;
    protected static final int CMD_W_RX = 3;
    protected static final int CMD_R_TX = 4;
    protected static final int CMD_W_TX = 5;
    protected static final int CMD_R_RAM = 6;
    protected static final int CMD_W_RAM = 7;
    protected int configCommand;
    protected int configByteCnt;
    protected int configRegAddr;
    protected byte configByteHigh;
    protected int configRAMAddr;
    protected int configRAMBank;
    private static final int TX_IN_PREAMBLE = 0;
    private static final int TX_SFD_1 = 1;
    private static final int TX_SFD_2 = 2;
    private static final int TX_LENGTH = 3;
    private static final int TX_IN_PACKET = 4;
    private static final int TX_CRC_1 = 5;
    private static final int TX_CRC_2 = 6;
    private static final int TX_END = 7;
    private static final int RECV_SFD_SCAN = 0;
    private static final int RECV_SFD_MATCHED_1 = 1;
    private static final int RECV_SFD_MATCHED_2 = 2;
    private static final int RECV_IN_PACKET = 3;
    private static final int RECV_CRC_1 = 4;
    private static final int RECV_CRC_2 = 5;
    private static final int RECV_END_STATE = 6;
    private static final int RECV_OVERFLOW = 7;

    public CC2420Radio(Microcontroller mcu, int xfreq) {
        this.mcu = mcu;
        this.sim = mcu.getSimulator();
        this.xfreq = xfreq;
        this.setMedium(CC2420Radio.createMedium(null, null));
        Simulator simulator = mcu.getSimulator();
        this.stateMachine = new FiniteStateMachine((Clock)simulator.getClock(), 0, allModeNames, ttm);
        new Energy("Radio", CC2420Energy.modeAmpere, this.stateMachine);
        this.reset();
        this.printer = SimUtil.getPrinter(mcu.getSimulator(), "radio.cc2420");
    }

    public FiniteStateMachine getFiniteStateMachine() {
        return this.stateMachine;
    }

    private void reset() {
        for (int cntr = 0; cntr < 64; ++cntr) {
            this.resetRegister(cntr);
        }
        this.txFIFO.clear();
        this.rxFIFO.clear();
        this.statusRegister.setValue(0);
        this.CCA_pin.level = this.CCA_assessor;
        this.SFD_pin.level = this.SFD_value;
        this.FIFO_active = true;
        this.FIFOP_active = true;
        this.CCA_active = true;
        this.SFD_active = true;
        this.FIFO_pin.level.setValue(!this.FIFO_active);
        this.FIFOP_pin.level.setValue(!this.FIFOP_active);
        this.transmitter.endTransmit();
        this.receiver.endReceive();
        this.stateMachine.transition(1);
    }

    public void setSFDView(BooleanView sfd) {
        if (this.SFD_pin.level == this.SFD_value) {
            this.SFD_pin.level = sfd;
        }
        this.SFD_value = sfd;
    }

    int readRegister(int addr) {
        char val = this.registers[addr];
        if (this.printer.enabled) {
            this.printer.println("CC2420 " + CC2420Radio.regName(addr) + " => " + StringUtil.toMultirepString(val, 16));
        }
        return val;
    }

    void writeRegister(int addr, int val) {
        if (this.printer.enabled) {
            this.printer.println("CC2420 " + CC2420Radio.regName(addr) + " <= " + StringUtil.toMultirepString(val, 16));
        }
        this.registers[addr] = (char)val;
        switch (addr) {
            case 16: {
                if ((val & 0x8000) == 0) break;
                this.reset();
                break;
            }
            case 29: {
                int ccaMux = val & 0x1F;
                int sfdMux = val >> 5 & 0x1F;
                this.setCCAMux(ccaMux);
                this.setSFDMux(sfdMux);
                break;
            }
            case 28: {
                this.FIFO_active = !Arithmetic.getBit(val, 10);
                this.FIFOP_active = !Arithmetic.getBit(val, 9);
                this.SFD_active = !Arithmetic.getBit(val, 8);
                this.CCA_active = !Arithmetic.getBit(val, 7);
            }
        }
        this.computeStatus();
    }

    private void setSFDMux(int sfdMux) {
    }

    private void setCCAMux(int ccaMux) {
        this.CCA_pin.level = ccaMux == 24 ? this.oscStable : this.CCA_assessor;
    }

    void strobe(int addr) {
        if (this.printer.enabled) {
            this.printer.println("CC2420 Strobe " + CC2420Radio.strobeName(addr));
        }
        switch (addr) {
            case 0: {
                break;
            }
            case 1: {
                this.startOscillator();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.transmitter.shutdown();
                this.receiver.startup();
                break;
            }
            case 5: {
                if (!this.CCA_assessor.getValue()) break;
                this.receiver.shutdown();
                this.transmitter.startup();
                break;
            }
            case 4: {
                this.receiver.shutdown();
                this.transmitter.startup();
                break;
            }
            case 6: {
                this.stateMachine.transition(2);
                break;
            }
            case 7: {
                this.stateMachine.transition(1);
                break;
            }
            case 8: {
                this.rxFIFO.clear();
                this.receiver.resetOverflow();
                this.FIFO_pin.level.setValue(!this.FIFO_active);
                this.FIFOP_pin.level.setValue(!this.FIFOP_active);
                break;
            }
            case 9: {
                this.txFIFO.clear();
                this.txUnderflow.setValue(false);
                break;
            }
            case 10: {
                this.SendAck = true;
                if (this.receiver.locked) break;
                this.receiver.shutdown();
                this.transmitter.startup();
                break;
            }
            case 11: {
                this.SendAckPend = true;
                if (this.receiver.locked) break;
                this.receiver.shutdown();
                this.transmitter.startup();
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
        }
    }

    private void startOscillator() {
        if (!this.oscStable.getValue() && !this.startingOscillator) {
            this.startingOscillator = true;
            this.sim.insertEvent(new Simulator.Event(){

                public void fire() {
                    CC2420Radio.this.oscStable.setValue(true);
                    CC2420Radio.this.startingOscillator = false;
                    CC2420Radio.this.stateMachine.transition(2);
                    if (CC2420Radio.this.printer.enabled) {
                        CC2420Radio.this.printer.println("CC2420 Oscillator established");
                    }
                }
            }, this.toCycles(1000L));
        }
    }

    void resetRegister(int addr) {
        int val = 0;
        switch (addr) {
            case 16: {
                val = 63488;
                break;
            }
            case 17: {
                val = 2786;
                break;
            }
            case 20: {
                val = 42767;
                break;
            }
            case 21: {
                val = 41215;
                break;
            }
            case 22: {
                val = 4837;
                break;
            }
            case 23: {
                val = 2646;
                break;
            }
            case 24: {
                val = 16741;
                break;
            }
            case 28: {
                val = 64;
            }
        }
        this.registers[addr] = val;
    }

    void computeStatus() {
    }

    protected byte receiveConfigByte(byte val) {
        ++this.configByteCnt;
        if (this.configByteCnt == 1) {
            byte status = this.getStatus();
            boolean ramop = Arithmetic.getBit(val, 7);
            boolean readop = Arithmetic.getBit(val, 6);
            this.configRegAddr = val & 0x3F;
            this.configRAMAddr = val & 0x7F;
            this.computeStatus();
            if (this.configRegAddr <= 15) {
                this.strobe(this.configRegAddr);
                this.configByteCnt = 0;
            } else {
                this.configCommand = ramop ? 6 : (this.configRegAddr == 62 ? (readop ? 4 : 5) : (this.configRegAddr == 63 ? (readop ? 2 : 3) : (readop ? 0 : 1)));
            }
            return status;
        }
        if (this.configByteCnt == 2) {
            switch (this.configCommand) {
                case 0: {
                    return Arithmetic.high(this.readRegister(this.configRegAddr));
                }
                case 1: {
                    this.configByteHigh = val;
                    return 0;
                }
                case 4: {
                    return this.readFIFO(this.txFIFO);
                }
                case 2: {
                    return this.readFIFO(this.rxFIFO);
                }
                case 5: {
                    return this.writeFIFO(this.txFIFO, val, true);
                }
                case 3: {
                    return this.writeFIFO(this.rxFIFO, val, false);
                }
                case 6: {
                    this.configRAMBank = val >> 6 & 3;
                    this.configCommand = Arithmetic.getBit(val, 5) ? 6 : 7;
                    return 0;
                }
            }
        } else {
            switch (this.configCommand) {
                case 0: {
                    this.configByteCnt = 0;
                    return Arithmetic.low(this.readRegister(this.configRegAddr));
                }
                case 1: {
                    this.configByteCnt = 0;
                    this.writeRegister(this.configRegAddr, Arithmetic.word(val, this.configByteHigh));
                    return 0;
                }
                case 4: {
                    return this.readFIFO(this.txFIFO);
                }
                case 2: {
                    return this.readFIFO(this.rxFIFO);
                }
                case 5: {
                    return this.writeFIFO(this.txFIFO, val, true);
                }
                case 3: {
                    return this.writeFIFO(this.rxFIFO, val, false);
                }
                case 6: {
                    if (this.configRAMBank == 0) {
                        return this.txFIFO.peek(this.configRAMAddr);
                    }
                    if (this.configRAMBank == 1) {
                        return this.rxFIFO.peek(this.configRAMAddr);
                    }
                    if (this.configRAMBank == 2) {
                        return this.ReadSecurityBank(this.configRAMAddr + (this.configByteCnt - 5));
                    }
                    return 0;
                }
                case 7: {
                    if (this.configRAMBank == 0) {
                        return this.txFIFO.poke(this.configRAMAddr, val);
                    }
                    if (this.configRAMBank == 1) {
                        return this.rxFIFO.poke(this.configRAMAddr, val);
                    }
                    if (this.configRAMBank == 2) {
                        return this.WriteSecurityBank(this.configRAMAddr + (this.configByteCnt - 5), val);
                    }
                    return 0;
                }
            }
        }
        return 0;
    }

    private byte getStatus() {
        byte status = (byte)this.statusRegister.getValue();
        if (this.printer.enabled) {
            this.printer.println("CC2420 status: " + StringUtil.toBin(status, 8));
        }
        return status;
    }

    protected byte ReadSecurityBank(int address) {
        byte value = this.RAMSecurityRegisters[address];
        if (this.printer.enabled) {
            this.printer.println("CC2420 " + CC2420Radio.SecurityRAMName(address) + "(addr " + StringUtil.to0xHex(address, 2) + ") -> " + StringUtil.toMultirepString(value, 8));
        }
        return value;
    }

    protected byte WriteSecurityBank(int address, byte value) {
        if (this.printer.enabled) {
            this.printer.println("CC2420 " + CC2420Radio.SecurityRAMName(address) + "(addr " + StringUtil.to0xHex(address, 2) + ") <= " + StringUtil.toMultirepString(value, 8));
        }
        this.RAMSecurityRegisters[address] = value;
        if (this.RAMSecurityRegisters[104] == 255 && this.RAMSecurityRegisters[105] == 255) {
            this.BCN_ACCEPT.setValue(true);
        }
        return value;
    }

    protected byte readFIFO(ByteFIFO fifo) {
        byte val = fifo.remove();
        if (this.printer.enabled) {
            this.printer.println("CC2420 Read " + this.fifoName(fifo) + " -> " + StringUtil.toMultirepString(val, 8));
        }
        if (fifo == this.rxFIFO) {
            if (fifo.empty()) {
                this.FIFO_pin.level.setValue(!this.FIFO_active);
            } else if (fifo.size() < this.getFIFOThreshold()) {
                this.FIFOP_pin.level.setValue(!this.FIFOP_active);
            }
        }
        return val;
    }

    protected byte writeFIFO(ByteFIFO fifo, byte val, boolean st) {
        byte result;
        if (this.printer.enabled) {
            this.printer.println("CC2420 Write " + this.fifoName(fifo) + " <= " + StringUtil.toMultirepString(val, 8));
        }
        byte by = result = st ? this.getStatus() : (byte)0;
        if (this.getClearFlag()) {
            fifo.clear();
            this.ClearFlag = false;
        }
        fifo.add(val);
        this.computeStatus();
        return result;
    }

    protected boolean getClearFlag() {
        return this.ClearFlag;
    }

    protected void setClearFlag() {
        this.ClearFlag = true;
    }

    private int getFIFOThreshold() {
        return this.registers[28] & 0x7F;
    }

    public Simulator getSimulator() {
        return this.sim;
    }

    public double getPower() {
        return POWER_dBm[this.readRegister(21) & 0x1F];
    }

    public double getFrequency() {
        return 2048 + this.readRegister(24) & 0x3FF;
    }

    private void pinChange_CS(boolean level) {
        this.configByteCnt = 0;
    }

    char crcAccumulate(char crc, byte val) {
        int i = 8;
        crc = (char)(crc ^ val << 8);
        do {
            crc = (crc & 0x8000) != 0 ? (char)(crc << 1 ^ 0x1021) : (char)(crc << 1);
        } while (--i > 0);
        return crc;
    }

    public static String regName(int reg) {
        switch (reg) {
            case 16: {
                return "MAIN    ";
            }
            case 17: {
                return "MDMCTRL0";
            }
            case 18: {
                return "MDMCTRL1";
            }
            case 19: {
                return "RSSI    ";
            }
            case 20: {
                return "SYNCWORD";
            }
            case 21: {
                return "TXCTRL  ";
            }
            case 22: {
                return "RXCTRL0 ";
            }
            case 23: {
                return "RXCTRL1 ";
            }
            case 24: {
                return "FSCTRL  ";
            }
            case 25: {
                return "SECCTRL0";
            }
            case 26: {
                return "SECCTRL1";
            }
            case 27: {
                return "BATTMON ";
            }
            case 28: {
                return "IOCFG0  ";
            }
            case 29: {
                return "IOCFG1  ";
            }
            case 30: {
                return "MANFIDL ";
            }
            case 31: {
                return "MANFIDH ";
            }
            case 32: {
                return "FSMTC   ";
            }
            case 33: {
                return "MANAND  ";
            }
            case 34: {
                return "MANOR   ";
            }
            case 35: {
                return "AGCCTRL0";
            }
            case 36: {
                return "AGCTST0 ";
            }
            case 37: {
                return "AGCTST1 ";
            }
            case 38: {
                return "AGCTST2 ";
            }
            case 39: {
                return "FSTST0  ";
            }
            case 40: {
                return "FSTST1  ";
            }
            case 41: {
                return "FSTST2  ";
            }
            case 42: {
                return "FSTST3  ";
            }
            case 43: {
                return "RXBPFTST";
            }
            case 44: {
                return "FSMSTATE";
            }
            case 45: {
                return "ADCTST  ";
            }
            case 46: {
                return "DACTST  ";
            }
            case 47: {
                return "TOPTST  ";
            }
            case 62: {
                return "TXFIFO  ";
            }
            case 63: {
                return "RXFIFO  ";
            }
        }
        return StringUtil.to0xHex(reg, 2) + "    ";
    }

    public static String strobeName(int strobe) {
        switch (strobe) {
            case 0: {
                return "SNOP    ";
            }
            case 1: {
                return "SXOSCON ";
            }
            case 2: {
                return "STXCAL  ";
            }
            case 3: {
                return "SRXON   ";
            }
            case 4: {
                return "STXON   ";
            }
            case 5: {
                return "STXONCCA";
            }
            case 6: {
                return "SRFOFF  ";
            }
            case 7: {
                return "SXOSCOFF";
            }
            case 8: {
                return "SFLUSHRX";
            }
            case 9: {
                return "SFLUSHTX";
            }
            case 10: {
                return "SACK    ";
            }
            case 11: {
                return "SACKPEND";
            }
            case 12: {
                return "SRXDEC  ";
            }
            case 13: {
                return "STXENC  ";
            }
            case 14: {
                return "SAES    ";
            }
        }
        return StringUtil.to0xHex(strobe, 2) + "    ";
    }

    String fifoName(ByteFIFO fifo) {
        if (fifo == this.txFIFO) {
            return "TX FIFO";
        }
        if (fifo == this.rxFIFO) {
            return "RX FIFO";
        }
        return "XX FIFO";
    }

    public static String SecurityRAMName(int address) {
        if (address < 16) {
            return "KEY0";
        }
        if (address < 32) {
            return "RX_NONCE_COUNTER";
        }
        if (address < 48) {
            return "SABUF";
        }
        if (address < 64) {
            return "KEY1";
        }
        if (address < 80) {
            return "TX_NONCE_COUNTER";
        }
        if (address < 96) {
            return "CBCSTATE";
        }
        if (address < 104) {
            return "IEEADR";
        }
        if (address < 106) {
            return "PANID";
        }
        if (address < 112) {
            return "SHORTADR";
        }
        return " ";
    }

    private long toCycles(long us) {
        return us * this.sim.getClock().getHZ() / 1000000L;
    }

    public static Medium createMedium(Synchronizer synch, Medium.Arbitrator arbitrator) {
        return new Medium(synch, arbitrator, 250000, 48, 8, 1024);
    }

    public Medium.Transmitter getTransmitter() {
        return this.transmitter;
    }

    public Medium.Receiver getReceiver() {
        return this.receiver;
    }

    public void setMedium(Medium m) {
        this.medium = m;
        this.transmitter = new Transmitter(m);
        this.receiver = new Receiver(m);
    }

    public Medium getMedium() {
        return this.medium;
    }

    public class CC2420Output
    implements Microcontroller.Pin.Input {
        protected BooleanView level;
        protected final String name;

        public CC2420Output(String n, BooleanView lvl) {
            this.name = n;
            this.level = lvl;
        }

        public boolean read() {
            boolean val = this.level.getValue();
            if (CC2420Radio.this.printer.enabled) {
                CC2420Radio.this.printer.println("CC2420 Read pin " + this.name + " -> " + val);
            }
            return val;
        }
    }

    public class CC2420Pin
    implements Microcontroller.Pin.Input,
    Microcontroller.Pin.Output {
        protected final String name;
        protected boolean level;

        public CC2420Pin(String n) {
            this.name = n;
        }

        public void write(boolean level) {
            if (this.level != level) {
                this.level = level;
                if (this == CC2420Radio.this.CS_pin) {
                    CC2420Radio.this.pinChange_CS(level);
                }
                if (CC2420Radio.this.printer.enabled) {
                    CC2420Radio.this.printer.println("CC2420 Write pin " + this.name + " -> " + level);
                }
            }
        }

        public boolean read() {
            if (CC2420Radio.this.printer.enabled) {
                CC2420Radio.this.printer.println("CC2420 Read pin " + this.name + " -> " + this.level);
            }
            return this.level;
        }
    }

    public class Receiver
    extends Medium.Receiver {
        protected int state;
        protected int counter;
        protected int length;
        protected char crc;
        protected byte crcLow;

        public Receiver(Medium m) {
            super(m, CC2420Radio.this.sim.getClock());
        }

        public void setRssiValid(boolean v) {
            CC2420Radio.this.rssiValid.setValue(v);
            if (v) {
                int cca_thr = CC2420Radio.this.readRegister(19) & 0xFF00;
                if (cca_thr == 0) {
                    cca_thr = -32;
                }
                int rssi_val = cca_thr;
                rssi_val <<= 8;
                int rssi = 161;
                rssi_val = rssi | rssi_val;
                CC2420Radio.this.writeRegister(19, rssi_val);
            } else if (this.getRssiValid()) {
                int cca_thr = CC2420Radio.this.readRegister(19) & 0xFF00;
                if (cca_thr == 0) {
                    cca_thr = -32;
                }
                int rssi_val = cca_thr;
                rssi_val <<= 8;
                int rssi = 128;
                rssi_val = rssi | rssi_val;
                CC2420Radio.this.writeRegister(19, rssi_val);
            }
        }

        public boolean getRssiValid() {
            return CC2420Radio.this.rssiValid.getValue();
        }

        public double getCorrelation() {
            int PERindex = (int)(this.getPER() * 100.0);
            Random random = new Random();
            long range = (long)Corr_MAX[PERindex] - (long)Corr_MIN[PERindex] + 1L;
            long fraction = (long)((double)range * random.nextDouble());
            double corr = fraction + (long)Corr_MIN[PERindex];
            return corr;
        }

        public void setRSSI(double Prec) {
            int rssi_val = (int)Math.rint(Prec + 45.0);
            rssi_val &= 0xFF;
            int cca_thr = CC2420Radio.this.readRegister(19) & 0xFF00;
            CC2420Radio.this.writeRegister(19, rssi_val |= cca_thr);
        }

        public void setBER(double BER) {
            CC2420Radio.this.BERlist.add(BER);
        }

        public double getPER() {
            double Total = 0.0;
            int size = CC2420Radio.this.BERlist.size();
            for (int i = 5; i < CC2420Radio.this.BERlist.size(); ++i) {
                Total += CC2420Radio.this.BERlist.get(i).doubleValue();
            }
            CC2420Radio.this.BERlist.clear();
            double BER = Total / (double)(size - 5);
            return 1.0 - Math.pow(1.0 - BER, (size - 5) * 8);
        }

        public byte nextByte(boolean lock, byte b) {
            if (!lock) {
                CC2420Radio.this.SFD_value.setValue(!CC2420Radio.this.SFD_active);
                switch (this.state) {
                    case 3: {
                        CC2420Radio.this.rxFIFO.clear();
                        this.state = 0;
                        break;
                    }
                    case 6: {
                        if (CC2420Radio.this.SendAck || CC2420Radio.this.SendAckPend) {
                            this.shutdown();
                            CC2420Radio.this.transmitter.startup();
                            break;
                        }
                        this.state = 0;
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        this.state = 0;
                    }
                }
                return b;
            }
            if (CC2420Radio.this.printer.enabled) {
                CC2420Radio.this.printer.println("CC2420 <======== " + StringUtil.to0xHex(b, 2));
            }
            switch (this.state) {
                case 0: {
                    if (b == Arithmetic.low(CC2420Radio.this.registers[20])) {
                        this.state = 1;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 1: {
                    if (b == Arithmetic.high(CC2420Radio.this.registers[20])) {
                        this.state = 2;
                        CC2420Radio.this.SFD_value.setValue(CC2420Radio.this.SFD_active);
                        break;
                    }
                }
                case 2: {
                    this.length = b & 0x7F;
                    CC2420Radio.this.rxFIFO.add(b);
                    this.counter = 0;
                    this.state = 3;
                    this.crc = '\u0000';
                    break;
                }
                case 3: {
                    boolean satisfied;
                    ++this.counter;
                    CC2420Radio.this.rxFIFO.add(b);
                    if (CC2420Radio.this.rxFIFO.overFlow()) {
                        CC2420Radio.this.FIFO_pin.level.setValue(!CC2420Radio.this.FIFO_active);
                        this.signalFIFOP();
                        this.state = 7;
                        break;
                    }
                    CC2420Radio.this.FIFO_pin.level.setValue(CC2420Radio.this.FIFO_active);
                    if (CC2420Radio.this.rxFIFO.size() >= CC2420Radio.this.getFIFOThreshold()) {
                        this.signalFIFOP();
                    }
                    if (CC2420Radio.this.autoCRC.getValue()) {
                        this.crc = CC2420Radio.this.crcAccumulate(this.crc, b);
                        if (this.counter == this.length - 2) {
                            this.state = 4;
                        }
                    } else if (this.counter == this.length) {
                        this.state = 6;
                    }
                    if (this.state != 3 || !CC2420Radio.this.ADR_DECODE.getValue() || (satisfied = this.matchAddress(b, this.counter))) break;
                    CC2420Radio.this.FIFO_pin.level.setValue(!CC2420Radio.this.FIFO_active);
                    this.unsignalFIFOP();
                    CC2420Radio.this.rxFIFO.clear();
                    break;
                }
                case 4: {
                    this.crcLow = b;
                    this.state = 5;
                    b = (byte)(CC2420Radio.this.readRegister(19) & 0xFF);
                    CC2420Radio.this.rxFIFO.add(b);
                    break;
                }
                case 5: {
                    this.state = 6;
                    char crcResult = (char)Arithmetic.word(this.crcLow, b);
                    if (crcResult == this.crc) {
                        if (CC2420Radio.this.printer.enabled) {
                            CC2420Radio.this.printer.println("CC2420 CRC passed");
                        }
                        int corr = (int)this.getCorrelation();
                        b = (byte)(corr | 0x80);
                        CC2420Radio.this.rxFIFO.add(b);
                        this.signalFIFOP();
                        CC2420Radio.this.SFD_value.setValue(!CC2420Radio.this.SFD_active);
                        if (!CC2420Radio.this.autoACK.getValue() || (CC2420Radio.this.rxFIFO.peek(1) & 0x20) != 32 || (CC2420Radio.this.rxFIFO.peek(1) & 7) == 2) break;
                        if ((CC2420Radio.this.rxFIFO.peek(1) & 0x10) != 16) {
                            CC2420Radio.this.SendAck = true;
                            break;
                        }
                        if ((CC2420Radio.this.rxFIFO.peek(1) & 0x10) != 16) break;
                        CC2420Radio.this.SendAckPend = true;
                        break;
                    }
                    if (CC2420Radio.this.printer.enabled) {
                        CC2420Radio.this.printer.println("CC2420 CRC failed");
                    }
                    CC2420Radio.this.FIFO_pin.level.setValue(!CC2420Radio.this.FIFO_active);
                    this.unsignalFIFOP();
                    CC2420Radio.this.rxFIFO.clear();
                    break;
                }
            }
            return b;
        }

        private boolean matchAddress(byte b, int counter) {
            switch (counter) {
                case 1: {
                    if ((CC2420Radio.this.rxFIFO.peek(1) & 4) != 4 || CC2420Radio.this.RESERVED_FRAME_MODE.getValue()) break;
                    return false;
                }
                case 3: {
                    if ((CC2420Radio.this.rxFIFO.peek(1) & 7) == 0 || (CC2420Radio.this.rxFIFO.peek(1) & 4) == 4) break;
                    CC2420Radio.this.DSN = b;
                    break;
                }
                case 5: {
                    CC2420Radio.this.PANId = CC2420Radio.this.rxFIFO.peekField(4, 6);
                    CC2420Radio.this.macPANId = ByteFIFO.copyOfRange(CC2420Radio.this.RAMSecurityRegisters, 104, 106);
                    if (!((CC2420Radio.this.rxFIFO.peek(2) >> 2 & 2) != 0 ? !Arrays.equals(CC2420Radio.this.PANId, CC2420Radio.this.macPANId) && !Arrays.equals(CC2420Radio.this.PANId, SHORT_BROADCAST_ADDR) : (CC2420Radio.this.rxFIFO.peek(2) >> 2 & 3) == 0 && (CC2420Radio.this.rxFIFO.peek(2) >> 6 & 2) != 0 && ((CC2420Radio.this.rxFIFO.peek(1) & 7) == 0 ? !Arrays.equals(CC2420Radio.this.PANId, CC2420Radio.this.macPANId) && !Arrays.equals(CC2420Radio.this.PANId, SHORT_BROADCAST_ADDR) : !((CC2420Radio.this.rxFIFO.peek(1) & 7) != 1 && (CC2420Radio.this.rxFIFO.peek(1) & 7) != 3 || CC2420Radio.this.PAN_COORDINATOR.getValue() && Arrays.equals(CC2420Radio.this.PANId, CC2420Radio.this.macPANId))))) break;
                    return false;
                }
                case 7: {
                    CC2420Radio.this.ShortAddr = CC2420Radio.this.rxFIFO.peekField(6, 8);
                    CC2420Radio.this.macShortAddr = ByteFIFO.copyOfRange(CC2420Radio.this.RAMSecurityRegisters, 106, 108);
                    if ((CC2420Radio.this.rxFIFO.peek(2) >> 2 & 3) != 2 || Arrays.equals(CC2420Radio.this.ShortAddr, CC2420Radio.this.ShortAddr) || Arrays.equals(CC2420Radio.this.ShortAddr, SHORT_BROADCAST_ADDR)) break;
                    return false;
                }
                case 12: {
                    if ((CC2420Radio.this.rxFIFO.peek(2) >> 2 & 3) != 3) break;
                    CC2420Radio.this.LongAdr = CC2420Radio.this.rxFIFO.peekField(8, 16);
                    CC2420Radio.this.IEEEAdr = ByteFIFO.copyOfRange(CC2420Radio.this.RAMSecurityRegisters, 96, 104);
                    if (Arrays.equals(CC2420Radio.this.LongAdr, CC2420Radio.this.IEEEAdr) || Arrays.equals(CC2420Radio.this.LongAdr, LONG_BROADCAST_ADDR)) break;
                    return false;
                }
            }
            return true;
        }

        private void signalFIFOP() {
            CC2420Radio.this.FIFOP_pin.level.setValue(CC2420Radio.this.FIFOP_active);
            if (CC2420Radio.this.FIFOP_interrupt > 0) {
                CC2420Radio.this.sim.getInterpreter().getInterruptTable().post(CC2420Radio.this.FIFOP_interrupt);
            }
        }

        private void unsignalFIFOP() {
            CC2420Radio.this.FIFOP_pin.level.setValue(!CC2420Radio.this.FIFOP_active);
            if (CC2420Radio.this.FIFOP_interrupt > 0) {
                CC2420Radio.this.sim.getInterpreter().getInterruptTable().unpost(CC2420Radio.this.FIFOP_interrupt);
            }
        }

        void startup() {
            CC2420Radio.this.stateMachine.transition(3);
            this.state = 0;
            this.beginReceive();
        }

        void shutdown() {
            CC2420Radio.this.stateMachine.transition(2);
            this.endReceive();
        }

        void resetOverflow() {
            this.state = 0;
        }
    }

    public class Transmitter
    extends Medium.Transmitter {
        protected int state;
        protected int counter;
        protected int length;
        protected char crc;

        public Transmitter(Medium m) {
            super(m, CC2420Radio.this.sim.getClock());
        }

        public byte nextByte() {
            byte val = 0;
            switch (this.state) {
                case 0: {
                    ++this.counter;
                    if (this.counter < this.getPreambleLength()) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.state = 2;
                    val = Arithmetic.low(CC2420Radio.this.registers[20]);
                    break;
                }
                case 2: {
                    this.state = 3;
                    val = Arithmetic.high(CC2420Radio.this.registers[20]);
                    break;
                }
                case 3: {
                    this.length = CC2420Radio.this.SendAck || CC2420Radio.this.SendAckPend ? 5 : CC2420Radio.this.txFIFO.remove() & 0x7F;
                    this.state = 4;
                    this.counter = 0;
                    this.crc = '\u0000';
                    val = (byte)this.length;
                    CC2420Radio.this.SFD_value.setValue(CC2420Radio.this.SFD_active);
                    break;
                }
                case 4: {
                    if (!CC2420Radio.this.SendAck && !CC2420Radio.this.SendAckPend) {
                        if (CC2420Radio.this.txFIFO.empty()) {
                            CC2420Radio.this.txUnderflow.setValue(true);
                            val = 0;
                            this.state = 7;
                            break;
                        }
                        val = CC2420Radio.this.txFIFO.remove();
                        ++this.counter;
                    } else {
                        switch (this.counter) {
                            case 0: {
                                if (CC2420Radio.this.SendAck) {
                                    val = 2;
                                    break;
                                }
                                if (CC2420Radio.this.SendAckPend) {
                                    val = 9;
                                    break;
                                }
                            }
                            case 1: {
                                val = 0;
                                break;
                            }
                            case 2: {
                                val = CC2420Radio.this.DSN;
                                if (CC2420Radio.this.SendAck) {
                                    CC2420Radio.this.SendAck = false;
                                    break;
                                }
                                if (!CC2420Radio.this.SendAckPend) break;
                                CC2420Radio.this.SendAckPend = false;
                            }
                        }
                        ++this.counter;
                    }
                    if (CC2420Radio.this.autoCRC.getValue()) {
                        this.crc = CC2420Radio.this.crcAccumulate(this.crc, val);
                        if (this.counter < this.length - 2) break;
                        this.state = 5;
                        break;
                    }
                    if (this.counter < this.length) break;
                    this.state = 7;
                    break;
                }
                case 5: {
                    this.state = 6;
                    val = Arithmetic.low(this.crc);
                    break;
                }
                case 6: {
                    val = Arithmetic.high(this.crc);
                    this.state = 7;
                    this.counter = 0;
                    CC2420Radio.this.SFD_value.setValue(!CC2420Radio.this.SFD_active);
                    CC2420Radio.this.txFIFO.refill();
                    CC2420Radio.this.setClearFlag();
                    this.shutdown();
                    CC2420Radio.this.receiver.startup();
                    break;
                }
                default: {
                    this.state = 0;
                    this.counter = 0;
                }
            }
            if (CC2420Radio.this.printer.enabled) {
                CC2420Radio.this.printer.println("CC2420 " + StringUtil.to0xHex(val, 2) + " --------> ");
            }
            return val;
        }

        private int getPreambleLength() {
            int val = CC2420Radio.this.registers[17] & 0xF;
            return val + 1;
        }

        void startup() {
            CC2420Radio.this.stateMachine.transition((CC2420Radio.this.readRegister(21) & 0x1F) + 4);
            if (!CC2420Radio.this.txActive.getValue()) {
                CC2420Radio.this.txActive.setValue(true);
                this.state = 0;
                this.beginTransmit(CC2420Radio.this.getPower(), CC2420Radio.this.getFrequency());
            }
        }

        void shutdown() {
            CC2420Radio.this.stateMachine.transition(2);
            CC2420Radio.this.txActive.setValue(false);
            this.endTransmit();
        }
    }

    public class ADCInterface
    implements ADC.ADCInput {
        public float getVoltage() {
            throw Util.unimplemented();
        }
    }

    public class SPIInterface
    implements SPIDevice {
        public SPI.Frame exchange(SPI.Frame frame) {
            if (CC2420Radio.this.printer.enabled) {
                CC2420Radio.this.printer.println("CC2420 new SPI frame exchange " + StringUtil.toMultirepString(frame.data, 8));
            }
            if (!CC2420Radio.this.CS_pin.level) {
                return SPI.newFrame(CC2420Radio.this.receiveConfigByte(frame.data));
            }
            return SPI.newFrame((byte)0);
        }

        public void connect(SPIDevice d) {
        }
    }

    public class ClearChannelAssessor
    implements BooleanView {
        public void setValue(boolean val) {
        }

        public boolean getValue() {
            return CC2420Radio.this.receiver.isChannelClear(CC2420Radio.this.readRegister(19), CC2420Radio.this.readRegister(17));
        }
    }
}

