/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.radio;

import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.Synchronizer;
import avrora.sim.energy.Energy;
import avrora.sim.mcu.ADC;
import avrora.sim.mcu.ATMegaFamily;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.mcu.SPI;
import avrora.sim.mcu.SPIDevice;
import avrora.sim.output.SimPrinter;
import avrora.sim.radio.Medium;
import avrora.sim.radio.Radio;
import avrora.sim.radio.RadioEnergy;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.util.Arithmetic;

public class CC1000Radio
implements Radio {
    private static final double FXOSC_FREQUENCY = 1.47456E7;
    public static final int MAIN = 0;
    public static final int FREQ_2A = 1;
    public static final int FREQ_1A = 2;
    public static final int FREQ_0A = 3;
    public static final int FREQ_2B = 4;
    public static final int FREQ_1B = 5;
    public static final int FREQ_0B = 6;
    public static final int FSEP1 = 7;
    public static final int FSEP0 = 8;
    public static final int CURRENT = 9;
    public static final int FRONT_END = 10;
    public static final int PA_POW = 11;
    public static final int PLL = 12;
    public static final int LOCK = 13;
    public static final int CAL = 14;
    public static final int MODEM2 = 15;
    public static final int MODEM1 = 16;
    public static final int MODEM0 = 17;
    public static final int MATCH = 18;
    public static final int FSCTRL = 19;
    public static final int PRESCALER = 28;
    public static final int TEST6 = 64;
    public static final int TEST5 = 65;
    public static final int TEST4 = 66;
    public static final int TEST3 = 67;
    public static final int TEST2 = 68;
    public static final int TEST1 = 69;
    public static final int TEST0 = 70;
    protected static final String[] allModeNames = RadioEnergy.allModeNames();
    protected static final int[][] ttm = FiniteStateMachine.buildSparseTTM(allModeNames.length, 0);
    protected RadioRegister[] registers = new RadioRegister[71];
    protected final MainRegister MAIN_reg;
    protected final FrequencyRegister FREQ_A_reg;
    protected final FrequencyRegister FREQ_B_reg;
    protected final FrequencySeparationRegister FSEP_reg;
    protected final CurrentRegister CURRENT_reg;
    protected final FrontEndRegister FRONT_END_reg;
    protected final PA_POWRegister PA_POW_reg;
    protected final PLLRegister PLL_reg;
    protected final LockRegister LOCK_reg;
    protected final CALRegister CAL_reg;
    protected final Modem2Register MODEM_2_reg;
    protected final Modem1Register MODEM_1_reg;
    protected final Modem0Register MODEM_0_reg;
    protected final MatchRegister MATCH_reg;
    protected final FSCTRLRegister FSCTRL_reg;
    protected final PrescalerRegister PRESCALER_reg;
    protected final SimPrinter radioPrinter;
    protected final long xoscFrequency;
    protected FrequencyRegister currentFrequencyRegister;
    protected final Microcontroller mcu;
    protected final Simulator sim;
    protected final Clock clock;
    protected final FiniteStateMachine stateMachine;
    public final SerialConfigurationInterface config;
    static final int[] VCO_CURRENT = new int[]{150, 250, 350, 450, 950, 1050, 1150, 1250, 1450, 1550, 1650, 1750, 2250, 2350, 2450, 2550};
    static final double[] LO_DRIVE = new double[]{0.5, 1.0, 1.5, 2.0};
    static final int[] PA_DRIVE = new int[]{1, 2, 3, 4};
    static final int[] BUF_CURRENT = new int[]{520, 690};
    static final double[] LNA_CURRENT = new double[]{0.8, 1.4, 1.8, 2.2};
    static final int[] SETS_LOCK_THRESHOLD = new int[]{127, 31};
    static final int[] RESET_LOCK_THRESHOLD = new int[]{111, 15};
    static final int[] SETTLING = new int[]{11, 22, 43, 86};
    static final int[] BAUDRATE = new int[]{600, 1200, 2400, 4800, 9600, 19200, 0, 0};
    static final int[] XOSC_FREQ = new int[]{3686400, 0x708000, 0x10E000, 1474560};
    static final double[] PRE_SWING = new double[]{1.0, 0.6666666666666666, 2.3333333333333335, 1.6666666666666667};
    static final double[] PRE_CURRENT = new double[]{1.0, 0.6666666666666666, 0.5, 0.4};
    protected Medium medium;
    protected Transmitter transmitter;
    protected Receiver receiver;
    protected SPITicker ticker;
    protected RSSIOutput rssiOutput;
    long spiTick;
    byte txBuffer;
    int rxBuffer;

    public CC1000Radio(Microcontroller mcu, long xfreq) {
        this.xoscFrequency = xfreq;
        this.mcu = mcu;
        this.sim = mcu.getSimulator();
        this.clock = this.sim.getClock();
        this.radioPrinter = SimUtil.getPrinter(this.sim, "radio.cc1000");
        for (int i = 20; i < this.registers.length; ++i) {
            this.registers[i] = new DummyRegister(i);
        }
        this.MAIN_reg = new MainRegister();
        this.registers[0] = this.MAIN_reg;
        this.FREQ_A_reg = new FrequencyRegister("A");
        this.registers[1] = this.FREQ_A_reg.reg2;
        this.registers[2] = this.FREQ_A_reg.reg1;
        this.registers[3] = this.FREQ_A_reg.reg0;
        this.FREQ_B_reg = new FrequencyRegister("B");
        this.registers[4] = this.FREQ_B_reg.reg2;
        this.registers[5] = this.FREQ_B_reg.reg1;
        this.registers[6] = this.FREQ_B_reg.reg0;
        this.FSEP_reg = new FrequencySeparationRegister();
        this.registers[7] = this.FSEP_reg.reg1;
        this.registers[8] = this.FSEP_reg.reg0;
        this.CURRENT_reg = new CurrentRegister();
        this.registers[9] = this.CURRENT_reg;
        this.FRONT_END_reg = new FrontEndRegister();
        this.registers[10] = this.FRONT_END_reg;
        this.PA_POW_reg = new PA_POWRegister();
        this.registers[11] = this.PA_POW_reg;
        this.PLL_reg = new PLLRegister();
        this.registers[12] = this.PLL_reg;
        this.LOCK_reg = new LockRegister();
        this.registers[13] = this.LOCK_reg;
        this.CAL_reg = new CALRegister();
        this.registers[14] = this.CAL_reg;
        this.MODEM_2_reg = new Modem2Register();
        this.registers[15] = this.MODEM_2_reg;
        this.MODEM_1_reg = new Modem1Register();
        this.registers[16] = this.MODEM_1_reg;
        this.MODEM_0_reg = new Modem0Register();
        this.registers[17] = this.MODEM_0_reg;
        this.MATCH_reg = new MatchRegister();
        this.registers[18] = this.MATCH_reg;
        this.FSCTRL_reg = new FSCTRLRegister();
        this.registers[19] = this.FSCTRL_reg;
        this.PRESCALER_reg = new PrescalerRegister();
        this.registers[28] = this.PRESCALER_reg;
        Simulator simulator = mcu.getSimulator();
        this.stateMachine = new FiniteStateMachine((Clock)simulator.getClock(), 0, allModeNames, ttm);
        new Energy("Radio", RadioEnergy.modeAmpere, this.stateMachine);
        ATMegaFamily amcu = (ATMegaFamily)mcu;
        this.ticker = new SPITicker();
        this.ticker.spiDevice = (SPIDevice)((Object)amcu.getDevice("spi"));
        this.setMedium(CC1000Radio.createMedium(null, null));
        this.rssiOutput = new RSSIOutput();
        ADC adc = (ADC)amcu.getDevice("adc");
        adc.connectADCInput(this.rssiOutput, 0);
        this.config = new SerialConfigurationInterface();
    }

    public FiniteStateMachine getFiniteStateMachine() {
        return this.stateMachine;
    }

    public double getPower() {
        double powerSet = this.PA_POW_reg.getPower();
        double power = powerSet < 16.0 ? 0.12 * powerSet - 1.8 : 0.00431 * powerSet - 0.06459;
        return power;
    }

    public double getFrequency() {
        double fref = 1.47456E7 / (double)this.PLL_reg.refDiv;
        int freq = !this.MAIN_reg.fReg ? this.FREQ_A_reg.frequency : this.FREQ_B_reg.frequency;
        return fref * (double)(freq + 8192) / 1.6384E10;
    }

    public static Medium createMedium(Synchronizer synch, Medium.Arbitrator arb) {
        return new Medium(synch, arb, 19200, 4, 8, 1024);
    }

    public Simulator getSimulator() {
        return this.sim;
    }

    public Medium.Transmitter getTransmitter() {
        return this.transmitter;
    }

    public Medium.Receiver getReceiver() {
        return this.receiver;
    }

    public void setMedium(Medium m) {
        this.medium = m;
        this.transmitter = new Transmitter(m);
        this.receiver = new Receiver(m);
    }

    public Medium getMedium() {
        return this.medium;
    }

    private class RSSIOutput
    implements ADC.ADCInput {
        private RSSIOutput() {
        }

        public float getVoltage() {
            if (CC1000Radio.this.receiver.isChannelClear(0, 0)) {
                return 1.0f;
            }
            return 0.0f;
        }
    }

    private class Receiver
    extends Medium.Receiver {
        Receiver(Medium m) {
            super(m, CC1000Radio.this.sim.getClock());
        }

        public void setRssiValid(boolean v) {
        }

        public boolean getRssiValid() {
            return false;
        }

        public void setRSSI(double PRec) {
        }

        public void setBER(double BER) {
        }

        public byte nextByte(boolean lock, byte val) {
            if (lock) {
                int delta = (int)(this.clock.getCount() - CC1000Radio.this.spiTick);
                int offset = (int)(8L * ((long)delta % this.cyclesPerByte) / this.cyclesPerByte);
                CC1000Radio.this.rxBuffer = CC1000Radio.this.rxBuffer << 8 | (~val & 0xFF) << offset;
                if (CC1000Radio.this.radioPrinter.enabled) {
                    CC1000Radio.this.radioPrinter.println("CC1000 <======== " + StringUtil.to0xHex(val, 2));
                }
            } else {
                CC1000Radio.this.rxBuffer = 0;
                if (CC1000Radio.this.radioPrinter.enabled) {
                    CC1000Radio.this.radioPrinter.println("CC1000 lock lost");
                }
            }
            return val;
        }
    }

    private class Transmitter
    extends Medium.Transmitter {
        Transmitter(Medium m) {
            super(m, CC1000Radio.this.sim.getClock());
        }

        public byte nextByte() {
            if (CC1000Radio.this.radioPrinter.enabled) {
                CC1000Radio.this.radioPrinter.println("CC1000 " + StringUtil.to0xHex(CC1000Radio.this.txBuffer, 2) + " --------> ");
            }
            return CC1000Radio.this.txBuffer;
        }
    }

    private class SPITicker
    implements Simulator.Event {
        protected SPIDevice spiDevice;
        protected boolean activated;

        private SPITicker() {
        }

        public void fire() {
            CC1000Radio.this.spiTick = CC1000Radio.this.clock.getCount();
            SPI.Frame frame = this.spiDevice.exchange(SPI.newFrame((byte)(CC1000Radio.this.rxBuffer >> 8)));
            CC1000Radio.this.txBuffer = frame.data;
            CC1000Radio.this.clock.insertEvent(this, CC1000Radio.this.receiver.cyclesPerByte);
        }

        protected void activate() {
            if (!this.activated) {
                this.activated = true;
                CC1000Radio.this.clock.insertEvent(this, CC1000Radio.this.receiver.cyclesPerByte);
            }
        }

        protected void deactivate() {
            if (this.activated) {
                this.activated = false;
                CC1000Radio.this.clock.removeEvent(this);
            }
        }
    }

    public class SerialConfigurationInterface {
        public final PCLKOutput PCLK_in = new PCLKOutput();
        public final PDATAOutput PDATA_in = new PDATAOutput();
        public final PDATAInput PDATA_out = new PDATAInput();
        public final PALEOutput PALE_in = new PALEOutput();
        byte address;
        boolean writeCommand;
        int writeValue;
        boolean inputPin;
        byte readData;
        int bitsRead;
        SimPrinter readerPrinter;

        SerialConfigurationInterface() {
            this.readerPrinter = SimUtil.getPrinter(CC1000Radio.this.sim, "radio.cc1000.pinconfig");
        }

        private void clockInBit() {
            if (this.bitsRead < 7) {
                this.address = (byte)(this.address << 1);
                this.address = (byte)(this.address | (this.inputPin ? (byte)1 : 0));
            } else if (this.bitsRead == 7) {
                this.writeCommand = this.inputPin;
                if (!this.writeCommand) {
                    this.readData = CC1000Radio.this.registers[this.address].value;
                    this.outputReadBit();
                }
            } else if (this.bitsRead < 16) {
                if (this.writeCommand) {
                    this.inputWriteBit();
                } else {
                    this.outputReadBit();
                }
            }
            ++this.bitsRead;
            if (this.bitsRead == 16) {
                if (this.writeCommand) {
                    CC1000Radio.this.registers[this.address].write((byte)this.writeValue);
                    if (this.readerPrinter.enabled) {
                        this.readerPrinter.println("CC1000.Reg[" + StringUtil.toHex(this.address, 2) + "] <= " + StringUtil.toMultirepString(this.writeValue, 8));
                    }
                } else if (this.readerPrinter.enabled) {
                    this.readerPrinter.println("CC1000.Reg[" + StringUtil.toHex(this.address, 2) + "] -> " + StringUtil.toMultirepString(this.readData, 8));
                }
                this.bitsRead = 0;
                this.address = 0;
            }
        }

        private void inputWriteBit() {
            this.writeValue = this.writeValue << 1 | (this.inputPin ? 1 : 0);
        }

        private void outputReadBit() {
            this.PDATA_out.outputPin = Arithmetic.getBit(this.readData, 14 - this.bitsRead);
        }

        protected class PALEOutput
        implements Microcontroller.Pin.Output {
            protected boolean last;

            protected PALEOutput() {
            }

            public void write(boolean level) {
                if (level == this.last) {
                    return;
                }
                SerialConfigurationInterface.this.bitsRead = !level ? 0 : 8;
                this.last = level;
            }
        }

        protected class PDATAOutput
        implements Microcontroller.Pin.Output {
            protected PDATAOutput() {
            }

            public void write(boolean level) {
                SerialConfigurationInterface.this.inputPin = level;
            }
        }

        protected class PDATAInput
        implements Microcontroller.Pin.Input {
            boolean outputPin;

            protected PDATAInput() {
            }

            public boolean read() {
                return this.outputPin;
            }
        }

        protected class PCLKOutput
        implements Microcontroller.Pin.Output {
            protected boolean last;

            protected PCLKOutput() {
            }

            public void write(boolean level) {
                if (level != this.last) {
                    if (!level) {
                        SerialConfigurationInterface.this.clockInBit();
                    }
                    this.last = level;
                }
            }
        }
    }

    protected class PrescalerRegister
    extends RadioRegister {
        double preSwing;
        double preCurrent;
        boolean ifInput;
        boolean ifFront;

        PrescalerRegister() {
            super("PRESCALER", (byte)0);
            this.preSwing = 1.0;
            this.preCurrent = 1.0;
        }

        protected void decode(byte val) {
            this.preSwing = PRE_SWING[(val & 0xC0) >> 6];
            this.preCurrent = PRE_CURRENT[(val & 0x30) >> 4];
            this.ifInput = Arithmetic.getBit(val, 3);
            this.ifFront = Arithmetic.getBit(val, 4);
        }
    }

    protected class FSCTRLRegister
    extends RadioRegister {
        boolean fsResetN;

        FSCTRLRegister() {
            super("FSCTRL", (byte)1);
        }

        protected void decode(byte val) {
            this.fsResetN = Arithmetic.getBit(val, 0);
        }
    }

    protected class MatchRegister
    extends RadioRegister {
        int rxMatch;
        int txMatch;

        MatchRegister() {
            super("MATCH", (byte)0);
        }

        protected void decode(byte val) {
            this.rxMatch = (val & 0xF0) >> 4;
            this.txMatch = val & 0xF;
        }
    }

    protected class Modem0Register
    extends RadioRegister {
        int baudrate;
        int bitrate;
        static final int DATA_FORMAT_NRZ = 0;
        static final int DATA_FORMAT_MANCHESTER = 1;
        static final int DATA_FORMAT_UART = 2;
        int dataFormat;
        int xoscFreqRange;

        Modem0Register() {
            super("MODEM0", (byte)36);
            this.baudrate = 2400;
            this.bitrate = 1200;
            this.dataFormat = 1;
            this.xoscFreqRange = XOSC_FREQ[0];
            this.decode(this.value);
        }

        protected void decode(byte val) {
            int baudIndex = (val & 0x70) >> 4;
            int xoscIndex = val & 3;
            this.dataFormat = (val & 0xC) >> 2;
            this.xoscFreqRange = XOSC_FREQ[xoscIndex];
            this.calculateBaudRate(baudIndex, xoscIndex);
            this.bitrate = this.baudrate / (this.dataFormat == 1 ? 2 : 1);
        }

        private void calculateBaudRate(int baudIndex, int xoscIndex) {
            this.baudrate = baudIndex == 5 && CC1000Radio.this.xoscFrequency > (long)XOSC_FREQ[2] ? (xoscIndex == 0 ? 76800 : (xoscIndex == 1 ? 38400 : BAUDRATE[baudIndex])) : BAUDRATE[baudIndex];
        }

        protected void printStatus() {
            CC1000Radio.this.radioPrinter.println("CC1000[MODEM0]: " + this.baudrate + " baud, " + this.bitrate + " bit rate, manchester: " + (this.dataFormat == 1));
        }
    }

    protected class Modem1Register
    extends RadioRegister {
        int mlimit;
        boolean lockAvgN;
        boolean lockAvgMode;
        int settling;
        boolean modemResetN;

        Modem1Register() {
            super("MODEM1", (byte)103);
            this.settling = 11;
        }

        protected void decode(byte val) {
            this.mlimit = (val & 0xE0) >> 5;
            this.lockAvgN = Arithmetic.getBit(val, 4);
            this.lockAvgMode = Arithmetic.getBit(val, 3);
            this.settling = SETTLING[(val & 6) >> 1];
            this.modemResetN = Arithmetic.getBit(val, 0);
        }
    }

    protected class Modem2Register
    extends RadioRegister {
        boolean peakDetect;
        int peakLevelOffset;

        Modem2Register() {
            super("MODEM2", (byte)-106);
        }

        protected void decode(byte val) {
            this.peakDetect = Arithmetic.getBit(val, 7);
            this.peakLevelOffset = val & 0x7F;
        }
    }

    protected class CALRegister
    extends RadioRegister {
        static final int CAL_START = 7;
        static final int CAL_DUAL = 6;
        static final int CAL_WAIT = 5;
        static final int CAL_CURRENT = 4;
        static final int CAL_COMPLETE = 3;
        boolean calStart;
        boolean calDual;
        boolean calWait;
        boolean calCurrent;
        boolean calComplete;
        static final int CAL_ITERATE_NORMAL = 6;
        int calIterate;
        Calibrate calibrate;
        boolean calibrating;

        CALRegister() {
            super("CAL", (byte)5);
            this.calibrate = new Calibrate();
        }

        protected void decode(byte val) {
            boolean oldCalStart = this.calStart;
            this.calStart = Arithmetic.getBit(val, 7);
            this.calDual = Arithmetic.getBit(val, 6);
            this.calWait = Arithmetic.getBit(val, 5);
            this.calCurrent = Arithmetic.getBit(val, 4);
            this.calComplete = Arithmetic.getBit(val, 3);
            this.calIterate = this.value & 7;
            if (!oldCalStart && this.calStart && !this.calibrating) {
                this.calibrating = true;
                double calMs = 2.3057725694444446 * (double)CC1000Radio.this.PLL_reg.refDiv;
                CC1000Radio.this.clock.insertEvent(this.calibrate, CC1000Radio.this.clock.millisToCycles(calMs));
            }
        }

        protected void printStatus() {
            StringBuffer buf = new StringBuffer(100);
            buf.append("CC1000[CAL]: cal start: ");
            buf.append(StringUtil.toBit(this.calStart));
            buf.append(", dual: ");
            buf.append(StringUtil.toBit(this.calDual));
            buf.append(", wait: ");
            buf.append(StringUtil.toBit(this.calWait));
            buf.append(", current: ");
            buf.append(StringUtil.toBit(this.calCurrent));
            buf.append(", complete: ");
            buf.append(StringUtil.toBit(this.calComplete));
            buf.append(", iterate: ");
            buf.append(this.calIterate);
            CC1000Radio.this.radioPrinter.println(buf.toString());
        }

        protected class Calibrate
        implements Simulator.Event {
            protected Calibrate() {
            }

            public void fire() {
                CALRegister.this.value = Arithmetic.setBit(CALRegister.this.value, 7, false);
                CALRegister.this.decode(CALRegister.this.value);
                CALRegister.this.value = Arithmetic.setBit(CALRegister.this.value, 3, true);
                CALRegister.this.decode(CALRegister.this.value);
                CC1000Radio.this.LOCK_reg.write((byte)(CC1000Radio.this.LOCK_reg.read() & 0xF | 0x50));
                if (CC1000Radio.this.radioPrinter.enabled) {
                    CC1000Radio.this.radioPrinter.println("CC1000: Calibration complete ");
                }
                CALRegister.this.calibrating = false;
            }
        }
    }

    protected class LockRegister
    extends RadioRegister {
        static final int LOCK_NORMAL = 0;
        static final int LOCK_CONTINUOUS = 1;
        static final int LOCK_INSTANT = 2;
        static final int ALARM_H = 3;
        static final int ALARM_L = 4;
        static final int CAL_COMPLETE = 5;
        static final int IF_OUT = 6;
        static final int REFERENCE_DIVIDER = 7;
        static final int TX_DPB = 8;
        static final int MANCHESTER_VIOLATION = 9;
        static final int RX_PDB = 10;
        static final int LOCK_AVG_FILTER = 13;
        static final int N_DIVIDER = 14;
        static final int F_COMP = 15;
        final String[] LOCK_SELECT;
        int lockSelect;
        boolean pllLockLength;
        int setsLockThreshold;
        int resetLockThreshold;
        boolean lockInstant;
        boolean lockContinuous;

        LockRegister() {
            super("LOCK", (byte)0);
            this.LOCK_SELECT = new String[]{"LOCK NORMAL", "LOCK CONTINUOUS", "LOCK INSTANT", "ALARM HIGH", "ALARM LOW", "CAL COMPLETE", "IF OUT", "REFERENCE DIVIDER", "TX DPB", "MANCHESTER VIOLATION", "RX PDB", "NOT DEFINED (11)", "NOT DEFINED (12)", "LOCK AVG FILTER", "N DIVIDER", "F COMP"};
            this.setsLockThreshold = 127;
            this.resetLockThreshold = 111;
        }

        protected void decode(byte val) {
            this.lockSelect = (val & 0xF0) >> 4;
            int pllLockAccuracy = (val & 0xC) >> 2;
            this.setsLockThreshold = SETS_LOCK_THRESHOLD[pllLockAccuracy];
            this.resetLockThreshold = RESET_LOCK_THRESHOLD[pllLockAccuracy];
            this.pllLockLength = Arithmetic.getBit(val, 2);
            this.lockInstant = Arithmetic.getBit(val, 1);
            this.lockContinuous = Arithmetic.getBit(val, 0);
        }

        protected void printStatus() {
            StringBuffer buf = new StringBuffer(100);
            buf.append("CC1000[LOCK]: lock select: ");
            buf.append(this.LOCK_SELECT[this.lockSelect]);
            buf.append(", set thr: ");
            buf.append(this.setsLockThreshold);
            buf.append(", reset thr: ");
            buf.append(this.resetLockThreshold);
            buf.append(", inst: ");
            buf.append(StringUtil.toBit(this.lockInstant));
            buf.append(", contin: ");
            buf.append(StringUtil.toBit(this.lockContinuous));
            CC1000Radio.this.radioPrinter.println(buf.toString());
        }

        public byte read() {
            return (byte)(this.value & 3);
        }
    }

    protected class PLLRegister
    extends RadioRegister {
        boolean extFilter;
        int refDiv;
        boolean alarmDisable;
        boolean alarmHigh;
        boolean alarmLow;

        PLLRegister() {
            super("PLL", (byte)16);
        }

        protected void decode(byte val) {
            this.extFilter = Arithmetic.getBit(val, 7);
            this.refDiv = (this.value & 0x78) >> 3;
            this.alarmDisable = Arithmetic.getBit(val, 2);
            this.alarmHigh = Arithmetic.getBit(val, 1);
            this.alarmLow = Arithmetic.getBit(val, 0);
        }
    }

    protected class PA_POWRegister
    extends RadioRegister {
        int paHighPower;
        int paLowPower;

        PA_POWRegister() {
            super("PA_POW", (byte)15);
        }

        protected void decode(byte val) {
            this.paHighPower = (this.value & 0xF0) >> 4;
            this.paLowPower = this.value & 0xF;
            if (!(CC1000Radio.this.MAIN_reg.corePd || CC1000Radio.this.MAIN_reg.biasPd || CC1000Radio.this.MAIN_reg.fsPd || !CC1000Radio.this.MAIN_reg.rxtx || CC1000Radio.this.MAIN_reg.txPd)) {
                CC1000Radio.this.stateMachine.transition(this.getPower() + 6);
            }
        }

        protected int getPower() {
            return this.value & 0xFF;
        }

        protected void printStatus() {
            CC1000Radio.this.radioPrinter.println("CC1000[PA_POW]: PA high power: " + this.paHighPower + ", PA low power: " + this.paLowPower);
        }
    }

    protected class FrontEndRegister
    extends RadioRegister {
        int bufCurrent;
        double lnaCurrent;
        static final int IF_RSSI_INACTIVE = 0;
        static final int IF_RSSI_ACTIVE = 1;
        static final int IF_RSSI_MIXER = 2;
        int ifRSSI;
        boolean xoscBypassExternal;

        FrontEndRegister() {
            super("FRONT_END", (byte)0);
            this.bufCurrent = 520;
            this.lnaCurrent = 0.8;
        }

        protected void decode(byte val) {
            this.bufCurrent = BUF_CURRENT[(val & 0x20) >> 5];
            this.lnaCurrent = LNA_CURRENT[(val & 0x18) >> 3];
            this.ifRSSI = (val & 6) >> 1;
            this.xoscBypassExternal = Arithmetic.getBit(val, 0);
        }
    }

    protected class CurrentRegister
    extends RadioRegister {
        int vcoCurrent;
        double loDrive;
        int paDrive;

        CurrentRegister() {
            super("CURRENT", (byte)-54);
            this.vcoCurrent = 150;
            this.loDrive = 0.5;
            this.paDrive = 1;
        }

        protected void decode(byte val) {
            this.vcoCurrent = VCO_CURRENT[(val & 0xF0) >> 4];
            this.loDrive = LO_DRIVE[(val & 0xC) >> 2];
            this.paDrive = PA_DRIVE[val & 3];
        }

        protected void printStatus() {
            CC1000Radio.this.radioPrinter.println("CC1000[CURRENT]: vco current: " + this.vcoCurrent + ", LO drive: " + this.loDrive + ", PA drive: " + this.paDrive);
        }
    }

    protected class FrequencySeparationRegister {
        protected final SubRegister reg1 = new SubRegister("FSEP1");
        protected final SubRegister reg0 = new SubRegister("FSEP0");
        int frequencySeparation;

        FrequencySeparationRegister() {
            this.setFrequencySeparation(89);
        }

        protected void updateFrequencySeparation() {
            this.frequencySeparation = (this.reg1.value & 0xF) << 8;
            this.frequencySeparation |= this.reg0.value;
        }

        protected void setFrequencySeparation(int val) {
            this.reg1.write((byte)((0xF00 & val) >> 8));
            this.reg0.write((byte)(0xFF & val));
        }

        protected class SubRegister
        extends RadioRegister {
            SubRegister(String id) {
                super(id, (byte)0);
            }

            protected void decode(byte val) {
                FrequencySeparationRegister.this.updateFrequencySeparation();
            }
        }
    }

    protected class FrequencyRegister {
        protected final FrequencySubRegister reg2;
        protected final FrequencySubRegister reg1;
        protected final FrequencySubRegister reg0;
        int frequency;

        FrequencyRegister(String subId) {
            this.reg2 = new FrequencySubRegister("FREQ2" + subId);
            this.reg1 = new FrequencySubRegister("FREQ1" + subId);
            this.reg0 = new FrequencySubRegister("FREQ0" + subId);
            this.setFrequency(7708875);
        }

        protected void updateFrequency() {
            this.frequency = 0xFF0000 & this.reg2.value << 16;
            this.frequency |= 0xFF00 & this.reg1.value << 8;
            this.frequency |= 0xFF & this.reg0.value;
        }

        protected void setFrequency(int frequency) {
            this.reg2.write((byte)((0xFF0000 & frequency) >> 16));
            this.reg1.write((byte)((0xFF00 & frequency) >> 8));
            this.reg0.write((byte)(0xFF & frequency));
        }

        protected class FrequencySubRegister
        extends RadioRegister {
            FrequencySubRegister(String id) {
                super(id, (byte)0);
            }

            protected void decode(byte val) {
                FrequencyRegister.this.updateFrequency();
            }
        }
    }

    protected class MainRegister
    extends RadioRegister {
        public static final int RXTX = 7;
        public static final int F_REG = 6;
        public static final int RX_PD = 5;
        public static final int TX_PD = 4;
        public static final int FS_PD = 3;
        public static final int CORE_PD = 2;
        public static final int BIAS_PD = 1;
        public static final int RESET_N = 0;
        boolean rxtx;
        boolean fReg;
        boolean rxPd;
        boolean txPd;
        boolean fsPd;
        boolean corePd;
        boolean biasPd;
        boolean resetN;
        byte oldVal;
        boolean transmit_activated;
        boolean receive_activated;

        MainRegister() {
            super("MAIN", (byte)62);
        }

        protected void decode(byte val) {
            this.rxtx = Arithmetic.getBit(val, 7);
            this.fReg = Arithmetic.getBit(val, 6);
            this.rxPd = Arithmetic.getBit(val, 5);
            this.txPd = Arithmetic.getBit(val, 4);
            this.fsPd = Arithmetic.getBit(val, 3);
            this.corePd = Arithmetic.getBit(val, 2);
            this.biasPd = Arithmetic.getBit(val, 1);
            this.resetN = Arithmetic.getBit(val, 0);
            if (this.rxPd) {
                CC1000Radio.this.receiver.endReceive();
            } else {
                CC1000Radio.this.receiver.beginReceive();
            }
            if (this.txPd) {
                CC1000Radio.this.transmitter.endTransmit();
            } else {
                CC1000Radio.this.transmitter.beginTransmit(CC1000Radio.this.getPower(), CC1000Radio.this.getFrequency());
            }
            if (!this.rxPd || !this.txPd) {
                CC1000Radio.this.ticker.activate();
            } else {
                CC1000Radio.this.ticker.deactivate();
            }
            boolean oldrxtx = Arithmetic.getBit(this.oldVal, 7);
            if (this.rxtx && !oldrxtx) {
                if (CC1000Radio.this.radioPrinter.enabled) {
                    CC1000Radio.this.radioPrinter.println("CC1000: RX end receiving -> begin transmitting");
                }
            } else if (!this.rxtx && oldrxtx && CC1000Radio.this.radioPrinter.enabled) {
                CC1000Radio.this.radioPrinter.println("CC1000: TX end transmitting -> begin receiving");
            }
            FrequencyRegister frequencyRegister = CC1000Radio.this.currentFrequencyRegister = this.fReg ? CC1000Radio.this.FREQ_B_reg : CC1000Radio.this.FREQ_A_reg;
            if (this.resetN && !Arithmetic.getBit(this.oldVal, 0)) {
                this.oldVal = val;
                return;
            }
            if (val != this.oldVal) {
                int state = this.corePd ? 1 : 2;
                if (!this.corePd && !this.biasPd) {
                    state = 3;
                }
                if (!(this.corePd || this.biasPd || this.fsPd)) {
                    state = 4;
                }
                if (!(this.corePd || this.biasPd || this.fsPd || this.rxtx || this.rxPd)) {
                    state = 5;
                }
                if (!(this.corePd || this.biasPd || this.fsPd || !this.rxtx || this.txPd)) {
                    state = CC1000Radio.this.PA_POW_reg.getPower() + 6;
                }
                CC1000Radio.this.stateMachine.transition(state);
            }
            this.oldVal = val;
        }

        protected void printStatus() {
            String rxtxS = this.rxtx ? "TX" : "RX";
            String fRegS = this.fReg ? "B" : "A";
            StringBuffer buf = new StringBuffer(100);
            buf.append("CC1000[MAIN]: ");
            buf.append(rxtxS);
            buf.append(", freg: ");
            buf.append(fRegS);
            buf.append(", rx pd: ");
            buf.append(StringUtil.toBit(this.rxPd));
            buf.append(", tx pd: ");
            buf.append(StringUtil.toBit(this.txPd));
            buf.append(", fs pd: ");
            buf.append(StringUtil.toBit(this.fsPd));
            buf.append(", core pd: ");
            buf.append(StringUtil.toBit(this.corePd));
            buf.append(", bias pd: ");
            buf.append(StringUtil.toBit(this.biasPd));
            buf.append(", reset: ");
            buf.append(StringUtil.toBit(this.resetN));
            CC1000Radio.this.radioPrinter.println(buf.toString());
        }
    }

    protected class DummyRegister
    extends RadioRegister {
        DummyRegister(int i) {
            super("Dummy " + Integer.toHexString(i), (byte)0);
        }

        protected void decode(byte val) {
        }
    }

    protected abstract class RadioRegister {
        protected final String id;
        protected byte value;

        RadioRegister(String id, byte def) {
            this.id = id;
            this.value = def;
        }

        public void write(byte val) {
            this.value = val;
            this.decode(this.value);
            if (CC1000Radio.this.radioPrinter.enabled) {
                this.printStatus();
            }
        }

        protected abstract void decode(byte var1);

        protected void printStatus() {
        }
    }
}

