/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform.sensors;

import avrora.Main;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.platform.sensors.SensorData;
import cck.util.Util;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public class ReplaySensorData
implements SensorData {
    final Clock clock;
    final File file;
    final FileReader fr;
    final StreamTokenizer st;
    final ChangeReading change;
    int currentReading;

    public ReplaySensorData(Microcontroller m, String fn) throws IOException {
        this.clock = m.getClockDomain().getMainClock();
        Main.checkFileExists(fn);
        this.file = new File(fn);
        this.fr = new FileReader(this.file);
        this.st = new StreamTokenizer(this.fr);
        this.change = new ChangeReading();
        this.getNextReading();
        this.scheduleNextChange();
    }

    private void getNextReading() throws IOException {
        int tt = this.st.nextToken();
        if (tt == -1) {
            return;
        }
        if (tt != -2) {
            throw Util.failure("sensor data format error: expected number as sensor reading");
        }
        this.currentReading = (int)this.st.nval & 0x3FF;
    }

    private void scheduleNextChange() throws IOException {
        int tt = this.st.nextToken();
        if (tt == -1) {
            return;
        }
        if (tt != -2) {
            throw Util.failure("sensor data format error: expected number as time value");
        }
        this.clock.insertEvent(this.change, (long)(this.st.nval * (double)this.clock.getHZ()));
    }

    public int reading() {
        return this.currentReading;
    }

    class ChangeReading
    implements Simulator.Event {
        ChangeReading() {
        }

        public void fire() {
            try {
                ReplaySensorData.this.getNextReading();
                ReplaySensorData.this.scheduleNextChange();
            }
            catch (IOException e) {
                throw Util.unexpected(e);
            }
        }
    }
}

