/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform.sensors;

import avrora.sim.FiniteStateMachine;
import avrora.sim.clock.Clock;
import avrora.sim.mcu.ADC;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.platform.sensors.Sensor;

public class LightSensor
extends Sensor {
    protected final AtmelMicrocontroller mcu;
    protected final int channel;
    protected final FiniteStateMachine fsm;
    protected static final String[] names = new String[]{"power down", "off", "on"};
    protected boolean power;
    protected boolean on;
    public ADC adcDevice;

    public LightSensor(AtmelMicrocontroller m, int adcChannel, String onPin, String powPin) {
        this.mcu = m;
        this.channel = adcChannel;
        this.mcu.getPin(onPin).connectOutput(new OnPin());
        this.mcu.getPin(powPin).connectOutput(new PowerPin());
        this.fsm = new FiniteStateMachine((Clock)this.mcu.getClockDomain().getMainClock(), 0, names, 0);
        this.adcDevice = (ADC)this.mcu.getDevice("adc");
        this.adcDevice.connectADCInput(new ADCInput(), this.channel);
    }

    private int state() {
        if (!this.power) {
            return 0;
        }
        if (!this.on) {
            return 1;
        }
        return 2;
    }

    class ADCInput
    implements ADC.ADCInput {
        ADCInput() {
        }

        public float getVoltage() {
            if (LightSensor.this.data == null) {
                return 0.0f;
            }
            if (!LightSensor.this.power || !LightSensor.this.on) {
                return 0.0f;
            }
            int read = LightSensor.this.data.reading();
            return LightSensor.this.adcDevice.getVoltageRef() * (float)read / 1023.0f;
        }
    }

    class PowerPin
    implements Microcontroller.Pin.Output {
        PowerPin() {
        }

        public void write(boolean val) {
            LightSensor.this.power = val;
            LightSensor.this.fsm.transition(LightSensor.this.state());
        }
    }

    class OnPin
    implements Microcontroller.Pin.Output {
        OnPin() {
        }

        public void write(boolean val) {
            LightSensor.this.on = !val;
            LightSensor.this.fsm.transition(LightSensor.this.state());
        }
    }
}

