/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.arch.msp430.mcu.F1611;
import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.platform.LED;
import avrora.sim.platform.Platform;
import avrora.sim.platform.PlatformFactory;

public class Telos
extends Platform {
    protected static final int MAIN_HZ = 8000000;
    protected static final int EXT_HZ = 32768;
    protected static final int RADIO_HZ = 0xE10000;
    protected final Simulator sim;

    protected Telos(Microcontroller m) {
        super(m);
        this.sim = m.getSimulator();
        this.addDevices();
    }

    protected void addDevices() {
        LED yellow = new LED(this.sim, 11, "Yellow");
        LED green = new LED(this.sim, 2, "Green");
        LED red = new LED(this.sim, 1, "Red");
        yellow.enablePrinting();
        green.enablePrinting();
        red.enablePrinting();
    }

    public static class Factory
    implements PlatformFactory {
        public Platform newPlatform(int id, Program p) {
            ClockDomain cd = new ClockDomain(8000000L);
            cd.newClock("external", 32768L);
            return new Telos(new F1611(id, cd, p));
        }
    }
}

