/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.ATMega128;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.platform.PinConnect;
import avrora.sim.platform.PinWire;
import avrora.sim.platform.Platform;
import avrora.sim.platform.PlatformFactory;

public class Superbot
extends Platform {
    protected final Microcontroller mcu;
    protected final Simulator sim;
    protected PinConnect pinConnect;

    private Superbot(Microcontroller m) {
        super(m);
        this.mcu = m;
        this.sim = m.getSimulator();
        this.addDevices();
    }

    protected void addDevices() {
        PinWire LED1PinTx = new PinWire(this.sim, 11, "LED1 Tx");
        PinWire LED2PinTx = new PinWire(this.sim, 2, "LED2 Tx");
        PinWire LED3PinTx = new PinWire(this.sim, 1, "LED3 Tx");
        PinWire LED4PinTx = new PinWire(this.sim, 4, "LED4 Tx");
        PinWire LED5PinTx = new PinWire(this.sim, 1, "LED5 Tx");
        PinWire LED6PinTx = new PinWire(this.sim, 4, "LED6 Tx");
        this.mcu.getPin("PC3").connectInput(LED1PinTx.wireInput);
        this.mcu.getPin("PC3").connectOutput(LED1PinTx.wireOutput);
        this.mcu.getPin("PC2").connectInput(LED2PinTx.wireInput);
        this.mcu.getPin("PC2").connectOutput(LED2PinTx.wireOutput);
        this.mcu.getPin("PC1").connectInput(LED3PinTx.wireInput);
        this.mcu.getPin("PC1").connectOutput(LED3PinTx.wireOutput);
        this.mcu.getPin("PC0").connectInput(LED4PinTx.wireInput);
        this.mcu.getPin("PC0").connectOutput(LED4PinTx.wireOutput);
        this.mcu.getPin("PD6").connectInput(LED5PinTx.wireInput);
        this.mcu.getPin("PD6").connectOutput(LED5PinTx.wireOutput);
        this.mcu.getPin("PD5").connectInput(LED6PinTx.wireInput);
        this.mcu.getPin("PD5").connectOutput(LED6PinTx.wireOutput);
        LED1PinTx.enableConnect();
        LED2PinTx.enableConnect();
        LED3PinTx.enableConnect();
        LED4PinTx.enableConnect();
        LED5PinTx.enableConnect();
        LED6PinTx.enableConnect();
        PinWire LED1PinRx = new PinWire(this.sim, 11, "LED1 Rx");
        PinWire LED2PinRx = new PinWire(this.sim, 2, "LED2 Rx");
        PinWire LED3PinRx = new PinWire(this.sim, 1, "LED3 Rx");
        PinWire LED4PinRx = new PinWire(this.sim, 4, "LED4 Rx");
        PinWire LED5PinRx = new PinWire(this.sim, 1, "LED5 Rx");
        PinWire LED6PinRx = new PinWire(this.sim, 4, "LED6 Rx");
        this.mcu.getPin("PF0").connectInput(LED1PinRx.wireInput);
        this.mcu.getPin("PF0").connectOutput(LED1PinRx.wireOutput);
        this.mcu.getPin("PF1").connectInput(LED2PinRx.wireInput);
        this.mcu.getPin("PF1").connectOutput(LED2PinRx.wireOutput);
        this.mcu.getPin("PF2").connectInput(LED3PinRx.wireInput);
        this.mcu.getPin("PF2").connectOutput(LED3PinRx.wireOutput);
        this.mcu.getPin("PF3").connectInput(LED4PinRx.wireInput);
        this.mcu.getPin("PF3").connectOutput(LED4PinRx.wireOutput);
        this.mcu.getPin("PF4").connectInput(LED5PinRx.wireInput);
        this.mcu.getPin("PF4").connectOutput(LED5PinRx.wireOutput);
        this.mcu.getPin("PF5").connectInput(LED6PinRx.wireInput);
        this.mcu.getPin("PF5").connectOutput(LED6PinRx.wireOutput);
        LED1PinRx.enableConnect();
        LED2PinRx.enableConnect();
        LED3PinRx.enableConnect();
        LED4PinRx.enableConnect();
        LED5PinRx.enableConnect();
        LED6PinRx.enableConnect();
        PinWire LED1PinInt = new PinWire(this.sim, 11, "LED1 Int", 3, this.mcu);
        PinWire LED2PinInt = new PinWire(this.sim, 2, "LED2 Int", 4, this.mcu);
        PinWire LED3PinInt = new PinWire(this.sim, 1, "LED3 Int", 5, this.mcu);
        PinWire LED4PinInt = new PinWire(this.sim, 4, "LED4 Int", 6, this.mcu);
        PinWire LED5PinInt = new PinWire(this.sim, 1, "LED5 Int", 7, this.mcu);
        PinWire LED6PinInt = new PinWire(this.sim, 4, "LED6 Int", 8, this.mcu);
        this.mcu.getPin("INT1").connectInput(LED1PinInt.wireInput);
        this.mcu.getPin("INT1").connectOutput(LED1PinInt.wireOutput);
        this.mcu.getPin("INT2").connectInput(LED2PinInt.wireInput);
        this.mcu.getPin("INT2").connectOutput(LED2PinInt.wireOutput);
        this.mcu.getPin("INT3").connectInput(LED3PinInt.wireInput);
        this.mcu.getPin("INT3").connectOutput(LED3PinInt.wireOutput);
        this.mcu.getPin("INT4").connectInput(LED4PinInt.wireInput);
        this.mcu.getPin("INT4").connectOutput(LED4PinInt.wireOutput);
        this.mcu.getPin("INT5").connectInput(LED5PinInt.wireInput);
        this.mcu.getPin("INT5").connectOutput(LED5PinInt.wireOutput);
        this.mcu.getPin("INT6").connectInput(LED6PinInt.wireInput);
        this.mcu.getPin("INT6").connectOutput(LED6PinInt.wireOutput);
        LED1PinInt.enableConnect();
        LED2PinInt.enableConnect();
        LED3PinInt.enableConnect();
        LED4PinInt.enableConnect();
        LED5PinInt.enableConnect();
        LED6PinInt.enableConnect();
        this.pinConnect = PinConnect.pinConnect;
        this.pinConnect.addSuperbotNode(this.mcu, LED1PinTx, LED2PinTx, LED3PinTx, LED4PinTx, LED5PinTx, LED6PinTx, LED1PinRx, LED2PinRx, LED3PinRx, LED4PinRx, LED5PinRx, LED6PinRx, LED1PinInt, LED2PinInt, LED3PinInt, LED4PinInt, LED5PinInt, LED6PinInt);
    }

    public static class Factory
    implements PlatformFactory {
        public Platform newPlatform(int id, Program p) {
            ClockDomain cd = new ClockDomain(0x708000L);
            cd.newClock("external", 32768L);
            return new Superbot(new ATMega128(id, cd, p));
        }
    }
}

