/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.mcu.USART;
import cck.text.Terminal;
import cck.util.Util;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;

public class SerialForwarder
implements USART.USARTDevice {
    public static final int BPS = 2400;
    private ServerSocket serverSocket;
    private Socket socket;
    private OutputStream out;
    private InputStream in;
    private USART usart;
    private SFTicker ticker;
    private byte[] data;
    protected int portNumber;

    public SerialForwarder(USART usart, int pn) {
        usart.connect(this);
        this.usart = usart;
        this.portNumber = pn;
        this.ticker = new SFTicker(usart.getClock(), 2400);
        this.ticker.start();
        this.data = new byte[1];
        try {
            this.serverSocket = new ServerSocket(this.portNumber);
            Terminal.print("Waiting for serial connection on port " + this.portNumber + "...");
            Terminal.flush();
            this.socket = this.serverSocket.accept();
            Terminal.println("connected to " + this.socket.getRemoteSocketAddress());
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
    }

    public SerialForwarder(USART usdv, String infile, String outfile) {
        this.usart = usdv;
        this.portNumber = 0;
        this.data = new byte[1];
        try {
            if (!infile.equals(outfile)) {
                this.in = new FileInputStream(infile);
                this.out = new FileOutputStream(outfile);
            } else {
                RandomAccessFile handle = new RandomAccessFile(infile, "rw");
                this.in = new FileInputStream(handle.getFD());
                this.out = new FileOutputStream(handle.getFD());
            }
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
        this.ticker = new SFTicker(usdv.getClock(), 2400);
        this.ticker.start();
        usdv.connect(this);
    }

    public SerialForwarder(USART usdv, String[] command) {
        this.usart = usdv;
        this.portNumber = 0;
        this.data = new byte[1];
        try {
            Process p = Runtime.getRuntime().exec(command);
            this.in = p.getInputStream();
            this.out = p.getOutputStream();
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
        this.ticker = new SFTicker(usdv.getClock(), 2400);
        this.ticker.start();
        usdv.connect(this);
    }

    public USART.Frame transmitFrame() {
        try {
            int len = this.in.read(this.data, 0, 1);
            return new USART.Frame(this.data[0], false, 8);
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
    }

    public void receiveFrame(USART.Frame frame) {
        try {
            this.out.write((byte)frame.value);
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
    }

    private class SFTicker
    implements Simulator.Event {
        private final long delta;
        private final Clock clock;

        SFTicker(Clock c, int bps) {
            this.delta = c.getHZ() / (long)bps;
            this.clock = c;
        }

        public void fire() {
            try {
                if (SerialForwarder.this.in.available() >= 1) {
                    SerialForwarder.this.usart.startReceive();
                }
            }
            catch (IOException e) {
                throw Util.unexpected(e);
            }
            this.clock.insertEvent(this, this.delta);
        }

        void start() {
            this.clock.insertEvent(this, this.delta);
        }
    }
}

