/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.ATMega128;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.platform.PinConnect;
import avrora.sim.platform.PinWire;
import avrora.sim.platform.Platform;
import avrora.sim.platform.PlatformFactory;

public class Seres
extends Platform {
    protected final Microcontroller mcu;
    protected final Simulator sim;
    protected PinConnect pinConnect;

    private Seres(Microcontroller m) {
        super(m);
        this.mcu = m;
        this.sim = m.getSimulator();
        this.addDevices();
    }

    protected void addDevices() {
        PinWire northPinTx = new PinWire(this.sim, 11, "North Tx");
        PinWire eastPinTx = new PinWire(this.sim, 2, "East Tx");
        PinWire southPinTx = new PinWire(this.sim, 1, "South Tx");
        PinWire westPinTx = new PinWire(this.sim, 4, "West Tx");
        this.mcu.getPin("PC0").connectInput(northPinTx.wireInput);
        this.mcu.getPin("PC0").connectOutput(northPinTx.wireOutput);
        this.mcu.getPin("PC1").connectInput(eastPinTx.wireInput);
        this.mcu.getPin("PC1").connectOutput(eastPinTx.wireOutput);
        this.mcu.getPin("PF5").connectInput(southPinTx.wireInput);
        this.mcu.getPin("PF5").connectOutput(southPinTx.wireOutput);
        this.mcu.getPin("PF6").connectInput(westPinTx.wireInput);
        this.mcu.getPin("PF6").connectOutput(westPinTx.wireOutput);
        northPinTx.enableConnect();
        eastPinTx.enableConnect();
        southPinTx.enableConnect();
        westPinTx.enableConnect();
        PinWire northPinRx = new PinWire(this.sim, 11, "North Rx");
        PinWire eastPinRx = new PinWire(this.sim, 2, "East Rx");
        PinWire southPinRx = new PinWire(this.sim, 1, "South Rx");
        PinWire westPinRx = new PinWire(this.sim, 4, "West Rx");
        this.mcu.getPin("PD1").connectInput(northPinRx.wireInput);
        this.mcu.getPin("PD1").connectOutput(northPinRx.wireOutput);
        this.mcu.getPin("PF2").connectInput(eastPinRx.wireInput);
        this.mcu.getPin("PF2").connectOutput(eastPinRx.wireOutput);
        this.mcu.getPin("PD0").connectInput(southPinRx.wireInput);
        this.mcu.getPin("PD0").connectOutput(southPinRx.wireOutput);
        this.mcu.getPin("PF3").connectInput(westPinRx.wireInput);
        this.mcu.getPin("PF3").connectOutput(westPinRx.wireOutput);
        northPinRx.enableConnect();
        eastPinRx.enableConnect();
        southPinRx.enableConnect();
        westPinRx.enableConnect();
        PinWire northPinInt = new PinWire(this.sim, 11, "North Int", 3, this.mcu);
        PinWire eastPinInt = new PinWire(this.sim, 2, "East Int", 4, this.mcu);
        PinWire southPinInt = new PinWire(this.sim, 1, "South Int", 2, this.mcu);
        PinWire westPinInt = new PinWire(this.sim, 4, "West Int", 8, this.mcu);
        this.mcu.getPin("INT1").connectInput(northPinInt.wireInput);
        this.mcu.getPin("INT1").connectOutput(northPinInt.wireOutput);
        this.mcu.getPin("INT2").connectInput(eastPinInt.wireInput);
        this.mcu.getPin("INT2").connectOutput(eastPinInt.wireOutput);
        this.mcu.getPin("INT0").connectInput(southPinInt.wireInput);
        this.mcu.getPin("INT0").connectOutput(southPinInt.wireOutput);
        this.mcu.getPin("INT6").connectInput(westPinInt.wireInput);
        this.mcu.getPin("INT6").connectOutput(westPinInt.wireOutput);
        northPinInt.enableConnect();
        eastPinInt.enableConnect();
        southPinInt.enableConnect();
        westPinInt.enableConnect();
        this.pinConnect = PinConnect.pinConnect;
        this.pinConnect.addSeresNode(this.mcu, northPinTx, eastPinTx, southPinTx, westPinTx, northPinRx, eastPinRx, southPinRx, westPinRx, northPinInt, eastPinInt, southPinInt, westPinInt);
    }

    public static class Factory
    implements PlatformFactory {
        public Platform newPlatform(int id, Program p) {
            ClockDomain cd = new ClockDomain(0x708000L);
            cd.newClock("external", 32768L);
            return new Seres(new ATMega128(id, cd, p));
        }
    }
}

