/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.mcu.SPI;
import avrora.sim.mcu.SPIDevice;
import cck.text.Terminal;
import cck.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class SPIForwarder
implements SPIDevice {
    public static final int BPS = 2400;
    private ServerSocket serverSocket;
    protected int portNumber;
    private Socket socket;
    private OutputStream out;
    private InputStream in;
    private SPI spi;
    private SFTicker ticker;
    private byte[] buffer;
    protected int bitsPerSecond;

    public SPIForwarder(SPI spdv, int pn, int bps, boolean master) {
        spdv.connect(this);
        this.spi = spdv;
        this.portNumber = pn;
        this.bitsPerSecond = bps;
        this.buffer = new byte[1];
        if (master) {
            this.ticker = new SFTicker(spdv.getClock());
            this.ticker.start();
        }
        try {
            this.serverSocket = new ServerSocket(this.portNumber);
            Terminal.print("Waiting for spi connection on port " + this.portNumber + "...");
            Terminal.flush();
            this.socket = this.serverSocket.accept();
            Terminal.println("connected to " + this.socket.getRemoteSocketAddress());
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
    }

    public SPI.Frame nextFrame() {
        try {
            byte data = 0;
            if (this.in.available() > 0 && this.in.read(this.buffer, 0, 1) > 0) {
                data = this.buffer[0];
            }
            return SPI.newFrame(data);
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
    }

    public SPI.Frame exchange(SPI.Frame frame) {
        try {
            this.receive(frame);
            return this.nextFrame();
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
    }

    private void receive(SPI.Frame frame) throws IOException {
        this.out.write(frame.data);
    }

    public void connect(SPIDevice d) {
    }

    private class SFTicker
    implements Simulator.Event {
        private final long delta;
        private final Clock clock;

        SFTicker(Clock c) {
            this.delta = c.getHZ() / (long)SPIForwarder.this.bitsPerSecond;
            this.clock = c;
        }

        public void fire() {
            try {
                if (SPIForwarder.this.in.available() >= 1) {
                    SPIForwarder.this.receive(SPIForwarder.this.spi.exchange(SPIForwarder.this.nextFrame()));
                }
            }
            catch (IOException e) {
                throw Util.unexpected(e);
            }
            this.clock.insertEvent(this, this.delta);
        }

        void start() {
            this.clock.insertEvent(this, this.delta);
        }
    }
}

