/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.MainClock;
import avrora.sim.mcu.ATMegaFamily;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.util.SimUtil;
import cck.text.Terminal;

public class PinWire {
    protected Simulator sim;
    protected final FiniteStateMachine state;
    protected final int colorNum;
    protected final String pinName;
    protected final ATMegaFamily atmel;
    private static final String[] modeName = new String[]{"low", "high"};
    private static final int startMode = 0;
    private boolean acceptsInput;
    private boolean acceptsOutput;
    private boolean isInterruptPin;
    private int interruptNum;
    public WireInput wireInput;
    public WireOutput wireOutput;
    protected final PinWireProbe probe;
    protected final long propDelay;

    protected PinWire(Simulator s, int colorNum, String pinName) {
        this.sim = s;
        MainClock clock = this.sim.getClock();
        this.state = new FiniteStateMachine((Clock)clock, 0, modeName, 0);
        this.wireOutput = new WireOutput();
        this.wireInput = new WireInput();
        this.acceptsInput = false;
        this.acceptsOutput = false;
        this.probe = new PinWireProbe();
        this.colorNum = colorNum;
        this.pinName = pinName;
        this.isInterruptPin = false;
        this.interruptNum = 0;
        this.atmel = null;
        this.propDelay = clock.millisToCycles(0.0014);
    }

    protected PinWire(Simulator s, int colorNum, String pinName, int interruptNum, Microcontroller mcu) {
        this.sim = s;
        MainClock clock = this.sim.getClock();
        this.state = new FiniteStateMachine((Clock)clock, 0, modeName, 0);
        this.wireOutput = new WireOutput();
        this.wireInput = new WireInput();
        this.acceptsInput = false;
        this.acceptsOutput = false;
        this.probe = new PinWireProbe();
        this.colorNum = colorNum;
        this.pinName = pinName;
        this.atmel = (ATMegaFamily)mcu;
        this.isInterruptPin = true;
        this.interruptNum = interruptNum;
        this.propDelay = clock.millisToCycles(0.0014);
    }

    public String readName() {
        return this.pinName;
    }

    public void enableConnect() {
        this.state.insertProbe(this.probe);
    }

    public void disableConnect() {
        this.state.removeProbe(this.probe);
    }

    public boolean inputReady() {
        return this.acceptsInput;
    }

    public boolean outputReady() {
        return this.acceptsOutput;
    }

    class WireOutput
    implements Microcontroller.Pin.Output {
        protected WireOutput() {
        }

        public void enableOutput() {
            PinWire.this.acceptsOutput = true;
            PinWire.this.acceptsInput = false;
        }

        public void write(boolean level) {
            if (level) {
                PinWire.this.state.transition(1);
            } else {
                PinWire.this.state.transition(0);
            }
        }

        protected class WirePropagationEvent
        implements Simulator.Event {
            private boolean value;

            public WirePropagationEvent(boolean value) {
                this.value = value;
            }

            public void fire() {
                if (this.value) {
                    PinWire.this.state.transition(1);
                } else {
                    PinWire.this.state.transition(0);
                }
            }
        }
    }

    class WireInput
    implements Microcontroller.Pin.Input {
        protected WireInput() {
        }

        public void enableInput() {
            PinWire.this.acceptsInput = true;
            PinWire.this.acceptsOutput = false;
        }

        public boolean read() {
            return PinWire.this.state.getCurrentState() == 1;
        }
    }

    class PinWireProbe
    implements FiniteStateMachine.Probe {
        PinWireProbe() {
        }

        public void fireBeforeTransition(int beforeState, int afterState) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireAfterTransition(int beforeState, int afterState) {
            if (beforeState == afterState) {
                return;
            }
            Class<Terminal> clazz = Terminal.class;
            synchronized (Terminal.class) {
                Terminal.print(SimUtil.getIDTimeString(PinWire.this.sim));
                Terminal.print(PinWire.this.colorNum, PinWire.this.pinName);
                Terminal.println(": " + modeName[afterState]);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (PinWire.this.isInterruptPin && beforeState == 0 && afterState == 1) {
                    ATMegaFamily.FlagRegister flag = PinWire.this.atmel.getEIFR_reg();
                    flag.flagBit(PinWire.this.interruptNum - 2);
                }
                return;
            }
        }
    }
}

