/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.sim.Simulator;
import avrora.sim.SimulatorThread;
import avrora.sim.clock.StepSynchronizer;
import avrora.sim.clock.Synchronizer;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.platform.PinWire;
import java.util.Iterator;
import java.util.LinkedList;

public class PinConnect {
    public static final PinConnect pinConnect = new PinConnect();
    private final PinEvent pinEvent;
    public final Synchronizer synchronizer;
    protected LinkedList pinNodes = new LinkedList();
    protected LinkedList pinConnections = new LinkedList();
    protected int numNodes = 0;
    public static final int NONE = -1;
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int LED1 = 0;
    public static final int LED2 = 1;
    public static final int LED3 = 2;
    public static final int LED4 = 3;
    public static final int LED5 = 4;
    public static final int LED6 = 5;

    public PinConnect() {
        this.pinEvent = new PinEvent();
        this.synchronizer = new StepSynchronizer(this.pinEvent);
    }

    public void addSeresNode(Microcontroller mcu, PinWire northTx, PinWire eastTx, PinWire southTx, PinWire westTx, PinWire northRx, PinWire eastRx, PinWire southRx, PinWire westRx, PinWire northInt, PinWire eastInt, PinWire southInt, PinWire westInt) {
        this.pinNodes.add(new PinNode(mcu, northTx, eastTx, southTx, westTx, northRx, eastRx, southRx, westRx, northInt, eastInt, southInt, westInt, this.numNodes));
        ++this.numNodes;
    }

    public void addSuperbotNode(Microcontroller mcu, PinWire LED1Tx, PinWire LED2Tx, PinWire LED3Tx, PinWire LED4Tx, PinWire LED5Tx, PinWire LED6Tx, PinWire LED1Rx, PinWire LED2Rx, PinWire LED3Rx, PinWire LED4Rx, PinWire LED5Rx, PinWire LED6Rx, PinWire LED1Int, PinWire LED2Int, PinWire LED3Int, PinWire LED4Int, PinWire LED5Int, PinWire LED6Int) {
        this.pinNodes.add(new PinNode(mcu, LED1Tx, LED2Tx, LED3Tx, LED4Tx, LED5Tx, LED6Tx, LED1Rx, LED2Rx, LED3Rx, LED4Rx, LED5Rx, LED6Rx, LED1Int, LED2Int, LED3Int, LED4Int, LED5Int, LED6Int, this.numNodes));
        ++this.numNodes;
    }

    public void addSimulatorThread(SimulatorThread simThread) {
        Simulator sim = simThread.getSimulator();
        Microcontroller currMCU = sim.getMicrocontroller();
        for (PinNode p : this.pinNodes) {
            if (currMCU != p.mcu) continue;
        }
    }

    public void initializeConnections() {
        Iterator i = this.pinNodes.iterator();
        if (!i.hasNext()) {
            return;
        }
        PinNode prevNode = (PinNode)i.next();
        while (i.hasNext()) {
            PinNode currNode = (PinNode)i.next();
            if ("SERES".equalsIgnoreCase(prevNode.platform)) {
                prevNode.connectNodes(currNode, 2, 2);
                prevNode.connectNodes(currNode, 0, 0);
                prevNode.connectNodes(currNode, 1, 1);
                prevNode.connectNodes(currNode, 3, 3);
            } else if ("Superbot".equalsIgnoreCase(prevNode.platform)) {
                prevNode.connectNodes(currNode, 0, 0);
                prevNode.connectNodes(currNode, 1, 1);
                prevNode.connectNodes(currNode, 2, 2);
                prevNode.connectNodes(currNode, 3, 3);
                prevNode.connectNodes(currNode, 4, 4);
                prevNode.connectNodes(currNode, 5, 5);
            } else {
                System.out.println("Unrecognized platform " + prevNode.platform);
            }
            prevNode = currNode;
        }
    }

    public LinkedList getPinNodes() {
        return this.pinNodes;
    }

    protected class PinEvent
    implements Simulator.Event {
        protected PinEvent() {
        }

        public void fire() {
            Iterator i = PinConnect.this.pinConnections.iterator();
            PinLink currLink = (PinLink)i.next();
            currLink.propagateSignals();
            while (i.hasNext()) {
                currLink = (PinLink)i.next();
                currLink.propagateSignals();
            }
        }
    }

    protected class PinLink {
        protected LinkedList pinWires = new LinkedList();
        protected int currentDelay;
        public PinNode outputNode;
        public int outputSide;
        public PinNode inputNode;
        public int inputSide;

        public PinLink(PinWire outputPin) {
            outputPin.wireOutput.enableOutput();
            this.pinWires.add(outputPin);
        }

        public void addInputPin(PinWire inputPin) {
            inputPin.wireInput.enableInput();
            this.pinWires.add(inputPin);
        }

        public void propagateSignals() {
            Iterator i = this.pinWires.iterator();
            PinWire currOutput = null;
            while (i.hasNext()) {
                PinWire curr = (PinWire)i.next();
                if (!curr.outputReady()) continue;
                if (currOutput != null) {
                    String s = "ERROR: More than one output wire on this PinLink";
                    System.out.println(s);
                    return;
                }
                currOutput = curr;
            }
            if (currOutput != null) {
                for (PinWire curr : this.pinWires) {
                    if (curr == currOutput) continue;
                    curr.wireOutput.write(currOutput.wireInput.read());
                }
            }
        }
    }

    protected class PinNode {
        public Microcontroller mcu;
        protected PinWire[] TxPins;
        protected PinWire[] RxPins;
        protected PinWire[] IntPins;
        private int localNode;
        public PinNode[] neighborNodes;
        public int[] neighborSides;
        public final String platform;

        public PinNode(Microcontroller mcu, PinWire northTx, PinWire eastTx, PinWire southTx, PinWire westTx, PinWire northRx, PinWire eastRx, PinWire southRx, PinWire westRx, PinWire northInt, PinWire eastInt, PinWire southInt, PinWire westInt, int node) {
            this.mcu = mcu;
            this.TxPins = new PinWire[]{northTx, eastTx, southTx, westTx};
            this.RxPins = new PinWire[]{northRx, eastRx, southRx, westRx};
            this.IntPins = new PinWire[]{northInt, eastInt, southInt, westInt};
            this.neighborNodes = new PinNode[]{null, null, null, null};
            this.neighborSides = new int[]{-1, -1, -1, -1};
            this.localNode = node;
            this.platform = "SERES";
        }

        public PinNode(Microcontroller mcu, PinWire LED1Tx, PinWire LED2Tx, PinWire LED3Tx, PinWire LED4Tx, PinWire LED5Tx, PinWire LED6Tx, PinWire LED1Rx, PinWire LED2Rx, PinWire LED3Rx, PinWire LED4Rx, PinWire LED5Rx, PinWire LED6Rx, PinWire LED1Int, PinWire LED2Int, PinWire LED3Int, PinWire LED4Int, PinWire LED5Int, PinWire LED6Int, int node) {
            this.mcu = mcu;
            this.TxPins = new PinWire[]{LED1Tx, LED2Tx, LED3Tx, LED4Tx, LED5Tx, LED6Tx};
            this.RxPins = new PinWire[]{LED1Rx, LED2Rx, LED3Rx, LED4Rx, LED5Rx, LED6Rx};
            this.IntPins = new PinWire[]{LED1Int, LED2Int, LED3Int, LED4Int, LED5Int, LED6Int};
            this.neighborNodes = new PinNode[]{null, null, null, null, null, null};
            this.neighborSides = new int[]{-1, -1, -1, -1, -1, -1};
            this.localNode = node;
            this.platform = "Superbot";
        }

        public void connectNodes(PinNode neighbor, int localSide, int neighborSide) {
            if (this.neighborNodes[localSide] != null || neighbor.neighborNodes[neighborSide] != null) {
                return;
            }
            this.neighborNodes[localSide] = neighbor;
            this.neighborSides[localSide] = neighborSide;
            neighbor.neighborNodes[neighborSide] = this;
            neighbor.neighborSides[neighborSide] = localSide;
            PinLink localToNeighbor = new PinLink(this.TxPins[localSide]);
            localToNeighbor.outputNode = this;
            localToNeighbor.outputSide = localSide;
            localToNeighbor.inputNode = neighbor;
            localToNeighbor.inputSide = neighborSide;
            localToNeighbor.addInputPin(neighbor.RxPins[neighborSide]);
            localToNeighbor.addInputPin(neighbor.IntPins[neighborSide]);
            PinLink neighborToLocal = new PinLink(neighbor.TxPins[neighborSide]);
            neighborToLocal.outputNode = neighbor;
            neighborToLocal.outputSide = neighborSide;
            neighborToLocal.inputNode = this;
            neighborToLocal.inputSide = localSide;
            neighborToLocal.addInputPin(this.RxPins[localSide]);
            neighborToLocal.addInputPin(this.IntPins[localSide]);
            PinConnect.this.pinConnections.add(localToNeighbor);
            PinConnect.this.pinConnections.add(neighborToLocal);
        }

        public void disconnectNodes(PinNode neighbor, int localSide, int neighborSide) {
            this.neighborNodes[localSide] = null;
            this.neighborSides[localSide] = -1;
            neighbor.neighborNodes[neighborSide] = null;
            neighbor.neighborSides[neighborSide] = -1;
            for (PinLink curr : PinConnect.this.pinConnections) {
                if (curr.outputNode != this || curr.outputSide != localSide || curr.inputNode != neighbor || curr.inputSide != neighborSide) continue;
                PinConnect.this.pinConnections.remove(curr);
            }
            for (PinLink curr : PinConnect.this.pinConnections) {
                if (curr.outputNode != neighbor || curr.outputSide != neighborSide || curr.inputNode != this || curr.inputSide != localSide) continue;
                PinConnect.this.pinConnections.remove(curr);
            }
        }
    }
}

