/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.ADC;
import avrora.sim.mcu.ATMega128;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.mcu.SPI;
import avrora.sim.mcu.Timer16Bit;
import avrora.sim.platform.ExternalFlash;
import avrora.sim.platform.LED;
import avrora.sim.platform.Platform;
import avrora.sim.platform.PlatformFactory;
import avrora.sim.platform.sensors.LightSensor;
import avrora.sim.platform.sensors.SensorBoard;
import avrora.sim.radio.CC2420Radio;

public class MicaZ
extends Platform {
    protected static final int MAIN_HZ = 0x708000;
    protected final Simulator sim;
    protected CC2420Radio radio;
    protected SensorBoard sensorboard;
    protected ExternalFlash externalFlash;
    protected LightSensor lightSensor;
    protected LED.LEDGroup ledGroup;

    private MicaZ(Microcontroller m) {
        super(m);
        this.sim = m.getSimulator();
        this.addDevices();
    }

    protected void addDevices() {
        LED yellow = new LED(this.sim, 11, "Yellow");
        LED green = new LED(this.sim, 2, "Green");
        LED red = new LED(this.sim, 1, "Red");
        this.ledGroup = new LED.LEDGroup(this.sim, new LED[]{yellow, green, red});
        this.addDevice("leds", this.ledGroup);
        AtmelMicrocontroller amcu = (AtmelMicrocontroller)this.mcu;
        this.mcu.getPin("PA0").connectOutput(yellow);
        this.mcu.getPin("PA1").connectOutput(green);
        this.mcu.getPin("PA2").connectOutput(red);
        CC2420Radio radio = new CC2420Radio(this.mcu, 0xE10000);
        this.mcu.getPin(11).connectOutput(radio.SCLK_pin);
        this.mcu.getPin(12).connectOutput(radio.MOSI_pin);
        this.mcu.getPin(13).connectInput(radio.MISO_pin);
        this.mcu.getPin(17).connectInput(radio.FIFO_pin);
        this.mcu.getPin(8).connectInput(radio.FIFOP_pin);
        this.mcu.getPin(31).connectInput(radio.CCA_pin);
        this.mcu.getPin(29).connectInput(radio.SFD_pin);
        this.mcu.getPin(10).connectOutput(radio.CS_pin);
        ADC adc = (ADC)amcu.getDevice("adc");
        adc.connectADCInput(radio.adcInterface, 0);
        SPI spi = (SPI)amcu.getDevice("spi");
        spi.connect(radio.spiInterface);
        this.addDevice("radio", radio);
        radio.FIFOP_interrupt = this.mcu.getProperties().getInterrupt("INT6");
        Timer16Bit timer1 = (Timer16Bit)amcu.getDevice("timer1");
        radio.setSFDView(timer1.getInputCapturePin());
        this.sensorboard = new SensorBoard(this.sim);
        this.externalFlash = new ExternalFlash(this.mcu);
        this.lightSensor = new LightSensor(amcu, 1, "PC2", "PE5");
        this.addDevice("light-sensor", this.lightSensor);
    }

    public static class Factory
    implements PlatformFactory {
        public Platform newPlatform(int id, Program p) {
            ClockDomain cd = new ClockDomain(0x708000L);
            cd.newClock("external", 32768L);
            return new MicaZ(new ATMega128(id, cd, p));
        }
    }
}

