/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.ATMega128;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.platform.ExternalFlash;
import avrora.sim.platform.LED;
import avrora.sim.platform.Platform;
import avrora.sim.platform.PlatformFactory;
import avrora.sim.platform.sensors.LightSensor;
import avrora.sim.platform.sensors.SensorBoard;
import avrora.sim.radio.CC1000Radio;

public class Mica2
extends Platform {
    protected static final int MAIN_HZ = 0x708000;
    protected static final int EXT_HZ = 32768;
    protected static final int RADIO_HZ = 0xE10000;
    protected final Simulator sim;
    protected CC1000Radio radio;
    protected SensorBoard sensorboard;
    protected ExternalFlash externalFlash;
    protected LightSensor lightSensor;
    protected LED.LEDGroup ledGroup;

    protected Mica2(Microcontroller m) {
        super(m);
        this.sim = m.getSimulator();
        this.addDevices();
    }

    protected void addDevices() {
        LED yellow = new LED(this.sim, 11, "Yellow");
        LED green = new LED(this.sim, 2, "Green");
        LED red = new LED(this.sim, 1, "Red");
        this.ledGroup = new LED.LEDGroup(this.sim, new LED[]{yellow, green, red});
        this.addDevice("leds", this.ledGroup);
        this.mcu.getPin("PA0").connectOutput(yellow);
        this.mcu.getPin("PA1").connectOutput(green);
        this.mcu.getPin("PA2").connectOutput(red);
        this.radio = new CC1000Radio(this.mcu, 0xE10000L);
        this.mcu.getPin(31).connectOutput(this.radio.config.PCLK_in);
        this.mcu.getPin(32).connectOutput(this.radio.config.PDATA_in);
        this.mcu.getPin(32).connectInput(this.radio.config.PDATA_out);
        this.mcu.getPin(29).connectOutput(this.radio.config.PALE_in);
        this.addDevice("radio", this.radio);
        this.sensorboard = new SensorBoard(this.sim);
        this.externalFlash = new ExternalFlash(this.mcu);
        AtmelMicrocontroller amcu = (AtmelMicrocontroller)this.mcu;
        this.lightSensor = new LightSensor(amcu, 1, "PC2", "PE5");
        this.addDevice("light-sensor", this.lightSensor);
    }

    public static class Factory
    implements PlatformFactory {
        public Platform newPlatform(int id, Program p) {
            ClockDomain cd = new ClockDomain(0x708000L);
            cd.newClock("external", 32768L);
            return new Mica2(new ATMega128(id, cd, p));
        }
    }
}

