/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.MainClock;
import avrora.sim.energy.Energy;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.util.SimUtil;
import cck.text.Terminal;

public class LED
implements Microcontroller.Pin.Output {
    public Simulator sim;
    public final int colornum;
    public final String color;
    public final FiniteStateMachine state;
    protected final LEDProbe probe;
    private static final String[] modeName = new String[]{"off", "on"};
    private static final double[] modeAmpere = new double[]{0.0, 0.0022};
    private static final int startMode = 0;

    protected LED(Simulator s, int n, String c) {
        this.sim = s;
        this.colornum = n;
        this.color = c;
        MainClock clk = this.sim.getClock();
        this.state = new FiniteStateMachine((Clock)clk, 0, modeName, 0);
        this.probe = new LEDProbe();
        new Energy(c, modeAmpere, this.state);
    }

    public void write(boolean level) {
        int snum = level ? 0 : 1;
        this.state.transition(snum);
    }

    public void enablePrinting() {
        this.state.insertProbe(this.probe);
    }

    public void disablePrinting() {
        this.state.removeProbe(this.probe);
    }

    public int getState() {
        return this.state.getCurrentState();
    }

    public FiniteStateMachine getFSM() {
        return this.state;
    }

    public static class LEDGroup {
        public final Simulator sim;
        public final LED[] leds;

        public LEDGroup(Simulator sim, LED[] nleds) {
            this.sim = sim;
            this.leds = nleds;
        }
    }

    class LEDProbe
    implements FiniteStateMachine.Probe {
        LEDProbe() {
        }

        public void fireBeforeTransition(int beforeState, int afterState) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireAfterTransition(int beforeState, int afterState) {
            if (beforeState == afterState) {
                return;
            }
            Class<Terminal> clazz = Terminal.class;
            synchronized (Terminal.class) {
                Terminal.print(SimUtil.getIDTimeString(LED.this.sim));
                Terminal.print(LED.this.colornum, LED.this.color);
                Terminal.println(": " + modeName[afterState]);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }
}

