/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.sim.mcu.USART;

public class LCDScreen
implements USART.USARTDevice {
    static final boolean MODE_DATA = false;
    static final boolean MODE_INSTRUCTION = true;
    static final int CLEAR_SCREEN = 1;
    static final int SCROLL_LEFT = 24;
    static final int SCROLL_RIGHT = 28;
    static final int HOME = 2;
    static final int CURSOR_UNDERLINE = 14;
    static final int CURSOR_BLOCK = 13;
    static final int CURSOR_INVIS = 12;
    static final int BLANK_DISPLAY = 8;
    static final int RESTORE_DISPLAY = 12;
    int cursor;
    boolean mode;
    final char[] line1 = new char[40];
    final char[] line2 = new char[40];

    public LCDScreen() {
        this.clearScreen();
    }

    public char memory(byte cursor) {
        if (cursor < 40) {
            return this.line1[cursor];
        }
        if (cursor < 80) {
            return this.line2[cursor - 40];
        }
        return 'c';
    }

    public USART.Frame transmitFrame() {
        return new USART.Frame(0, false, 8);
    }

    private void scrollRight() {
        char c1 = this.line1[39];
        System.arraycopy(this.line1, 0, this.line1, 1, 39);
        this.line1[0] = c1;
        char c2 = this.line2[39];
        System.arraycopy(this.line2, 0, this.line2, 1, 39);
        this.line2[0] = c2;
    }

    private void scrollLeft() {
        char c1 = this.line1[0];
        System.arraycopy(this.line1, 1, this.line1, 0, 39);
        this.line1[39] = c1;
        char c2 = this.line2[0];
        System.arraycopy(this.line2, 1, this.line2, 0, 39);
        this.line2[39] = c2;
    }

    private void clearScreen() {
        for (int i = 0; i < 40; ++i) {
            this.line1[i] = 32;
            this.line2[i] = 32;
        }
    }

    public void receiveFrame(USART.Frame frame) {
        int data = frame.value;
        if (this.mode) {
            switch (data) {
                case 1: {
                    this.clearScreen();
                    break;
                }
                case 24: {
                    this.scrollLeft();
                    break;
                }
                case 28: {
                    this.scrollRight();
                    break;
                }
                case 2: {
                    this.cursor = 0;
                    break;
                }
                default: {
                    if (data >= 192) {
                        this.cursor = data + 40 - 192;
                        break;
                    }
                    if (data < 128) break;
                    this.cursor = data - 128;
                }
            }
            this.mode = false;
        } else if (data == -2) {
            this.mode = true;
        } else {
            this.setCursor(frame.value);
            this.cursor = (this.cursor + 1) % 80;
        }
    }

    private void setCursor(int b) {
        if (this.cursor < 40) {
            this.line1[this.cursor] = (char)b;
        } else if (this.cursor < 80) {
            this.line2[this.cursor - 40] = (char)b;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(90);
        buf.append("\n|");
        buf.append(this.line1);
        buf.append("|\n");
        buf.append(this.line2);
        buf.append("|\n");
        return buf.toString();
    }
}

