/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.energy.Energy;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.util.SimUtil;
import cck.text.Terminal;
import cck.text.Verbose;

public class ExternalFlash {
    protected final Simulator sim;
    protected final Clock clock;
    protected Microcontroller mcu;
    private boolean isSelected;
    private boolean isReading;
    private int dfOpcode;
    private int dfPageAddress;
    private int dfByteOffset;
    private int dfTempByte;
    private short dfStatus;
    private long dfDelay;
    private double delay;
    private boolean so;
    private boolean si;
    private int icOffset;
    private int icPage;
    private boolean tick;
    private short step;
    private byte i;
    public static final int DF_STATUS_REGISTER_DENSITY = 24;
    public static final int DF_STATUS_READY = 128;
    public static final int DF_STATUS_COMPARE = 64;
    public static final int DF_TEP = 20;
    public static final int DF_TP = 14;
    public static final int DF_TPE = 8;
    public static final int DF_TBE = 12;
    public static final double DF_TXFR = 3.0E-4;
    public static final boolean ECHO_EVENT = Verbose.getVerbosePrinter((String)"mica2.flash").enabled;
    private static final String[] modeName = new String[]{"standby", "read", "write", "load"};
    private static final double[] modeAmpere = new double[]{2.0E-6, 0.004, 0.015, 2.0E-6};
    private static final int startMode = 0;
    public Memory memory = new Memory();
    protected final FiniteStateMachine stateMachine;

    public ExternalFlash(Microcontroller mcunit) {
        this.mcu = mcunit;
        this.sim = this.mcu.getSimulator();
        this.clock = this.sim.getClock();
        this.dfStatus = (short)152;
        this.tick = false;
        this.i = 0;
        this.step = 0;
        this.stateMachine = new FiniteStateMachine(this.clock, 0, modeName, 0);
        this.mcu.getPin("PA3").connectOutput(new PA3Output());
        this.mcu.getPin("PD3").connectOutput(new PD3Output());
        this.mcu.getPin("PD5").connectOutput(new PD5Output());
        this.mcu.getPin("PD2").connectInput(new PD2Input());
        new Energy("flash", modeAmpere, this.stateMachine);
    }

    private Page getMemoryPage(int num) {
        return this.memory.pages[num];
    }

    private short getMemoryPageAt(int num, int offset) {
        return this.memory.pages[num].bytes[offset];
    }

    private void setMemoryPage(int num, Page val) {
        this.memory.pages[num] = val;
        this.memory.pages[num].debug();
    }

    private Page getBuffer1() {
        return this.memory.buffer1;
    }

    private short getBuffer1(int offset) {
        return this.memory.buffer1.bytes[offset];
    }

    private void setBuffer1(Page value) {
        this.memory.buffer1 = value;
    }

    private void setBuffer1(int offset, short value) {
        this.memory.buffer1.bytes[offset] = value;
    }

    private Page getBuffer2() {
        return this.memory.buffer2;
    }

    private short getBuffer2(int offset) {
        return this.memory.buffer2.bytes[offset];
    }

    private void setBuffer2(Page value) {
        this.memory.buffer2 = value;
    }

    private void setBuffer2(int offset, short value) {
        this.memory.buffer2.bytes[offset] = value;
    }

    private void copyBuffer1toPage(int num) {
        this.setMemoryPage(num, this.getBuffer1());
    }

    private void copyBuffer2toPage(int num) {
        this.setMemoryPage(num, this.getBuffer2());
    }

    private void copyPageToBuffer1(int num) {
        this.setBuffer1(this.getMemoryPage(num));
    }

    private void copyPageToBuffer2(int num) {
        this.setBuffer2(this.getMemoryPage(num));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void echo(String str) {
        if (!ECHO_EVENT) return;
        Class<Terminal> clazz = Terminal.class;
        synchronized (Terminal.class) {
            Terminal.print(SimUtil.getIDTimeString(this.sim));
            Terminal.print(4, "Dataflash");
            Terminal.println(": " + str);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static /* synthetic */ byte access$1708(ExternalFlash x0) {
        byte by = x0.i;
        x0.i = (byte)(by + 1);
        return by;
    }

    static /* synthetic */ short access$1508(ExternalFlash x0) {
        short s = x0.step;
        x0.step = (short)(s + 1);
        return s;
    }

    protected class Delay
    implements Simulator.Event {
        protected Delay() {
        }

        public void fire() {
            ExternalFlash.this.dfStatus = (short)(ExternalFlash.this.dfStatus | 128);
        }
    }

    protected class PD2Input
    implements Microcontroller.Pin.Input {
        protected PD2Input() {
        }

        public boolean read() {
            return ExternalFlash.this.so;
        }
    }

    protected class PD5Output
    implements Microcontroller.Pin.Output {
        private short temp;

        protected PD5Output() {
        }

        public void write(boolean level) {
            if (ExternalFlash.this.isSelected && ExternalFlash.this.tick != level) {
                if (ExternalFlash.this.tick) {
                    if (ExternalFlash.this.isReading) {
                        this.setSO();
                        ExternalFlash.this.stateMachine.transition(1);
                        ExternalFlash.access$1708(ExternalFlash.this);
                        if (ExternalFlash.this.i > 7) {
                            ExternalFlash.this.echo("1 Byte of serial data was output on the SO: " + this.temp);
                            ExternalFlash.this.icOffset = ExternalFlash.this.dfByteOffset + 1;
                            if (ExternalFlash.this.icOffset > 263) {
                                ExternalFlash.this.icOffset -= 264;
                                ExternalFlash.this.icPage = ExternalFlash.this.dfPageAddress++;
                                if (ExternalFlash.this.icPage > 2047) {
                                    ExternalFlash.this.icPage -= 2048;
                                }
                            }
                            ExternalFlash.this.dfByteOffset = ExternalFlash.this.icOffset;
                            ExternalFlash.this.dfPageAddress = ExternalFlash.this.icPage;
                            ExternalFlash.this.i = (byte)0;
                        }
                    }
                } else if (!ExternalFlash.this.isReading) {
                    ExternalFlash.this.dfTempByte |= (ExternalFlash.this.si ? 1 : 0) << 7 - ExternalFlash.this.i;
                    ExternalFlash.access$1708(ExternalFlash.this);
                    if (ExternalFlash.this.i > 7) {
                        ExternalFlash.this.i = (byte)0;
                        ExternalFlash.access$1508(ExternalFlash.this);
                        this.doStep();
                        ExternalFlash.this.dfTempByte = 0;
                        if (ExternalFlash.this.step <= 4) {
                            ExternalFlash.this.stateMachine.transition(3);
                        } else {
                            ExternalFlash.this.stateMachine.transition(2);
                        }
                    }
                }
                ExternalFlash.this.tick = level;
            }
        }

        private void setSO() {
            switch (ExternalFlash.this.dfOpcode) {
                case 82: 
                case 84: 
                case 104: 
                case 210: 
                case 212: 
                case 232: {
                    this.temp = ExternalFlash.this.getBuffer1(ExternalFlash.this.dfByteOffset);
                    break;
                }
                case 86: 
                case 214: {
                    this.temp = ExternalFlash.this.getBuffer2(ExternalFlash.this.dfByteOffset);
                    break;
                }
                case 87: 
                case 215: {
                    this.temp = ExternalFlash.this.dfStatus;
                    break;
                }
                default: {
                    this.temp = ExternalFlash.this.getMemoryPageAt(ExternalFlash.this.dfPageAddress, ExternalFlash.this.dfByteOffset);
                }
            }
            ExternalFlash.this.so = (this.temp & 1 << 7 - ExternalFlash.this.i) > 0;
        }

        private void doStep() {
            switch (ExternalFlash.this.step) {
                case 1: {
                    ExternalFlash.this.dfOpcode = ExternalFlash.this.dfTempByte;
                    ExternalFlash.this.echo("Recieved Opcode: " + ExternalFlash.this.dfOpcode);
                    if (ExternalFlash.this.dfOpcode != 87 && ExternalFlash.this.dfOpcode != 215) break;
                    ExternalFlash.this.isReading = true;
                    break;
                }
                case 2: {
                    ExternalFlash.this.dfPageAddress = ExternalFlash.this.dfTempByte << 7 & 0x780;
                    ExternalFlash.this.echo("Received Address byte 1: " + ExternalFlash.this.dfTempByte);
                    break;
                }
                case 3: {
                    ExternalFlash.this.dfPageAddress |= ExternalFlash.this.dfTempByte >> 1;
                    ExternalFlash.this.dfByteOffset = ExternalFlash.this.dfTempByte & 0x100;
                    ExternalFlash.this.echo("Received Address byte 2: " + ExternalFlash.this.dfTempByte);
                    break;
                }
                case 4: {
                    ExternalFlash.this.dfByteOffset |= ExternalFlash.this.dfTempByte;
                    ExternalFlash.this.echo("Received Address byte 3: " + ExternalFlash.this.dfByteOffset);
                    break;
                }
                default: {
                    if (ExternalFlash.this.step <= 4) break;
                    this.doAction();
                }
            }
        }

        private void doAction() {
            if (ExternalFlash.this.dfByteOffset > 263) {
                ExternalFlash.this.dfByteOffset -= 264;
            }
            switch (ExternalFlash.this.dfOpcode) {
                case 104: 
                case 232: {
                    if (ExternalFlash.this.step != 8) break;
                    ExternalFlash.this.isReading = true;
                    break;
                }
                case 82: 
                case 210: {
                    if (ExternalFlash.this.step != 8) break;
                    ExternalFlash.this.isReading = true;
                    break;
                }
                case 84: 
                case 212: {
                    if (ExternalFlash.this.step != 5) break;
                    ExternalFlash.this.isReading = true;
                    break;
                }
                case 86: 
                case 214: {
                    if (ExternalFlash.this.step != 5) break;
                    ExternalFlash.this.isReading = true;
                    break;
                }
                case 87: 
                case 132: 
                case 215: {
                    ExternalFlash.this.setBuffer1(ExternalFlash.this.dfByteOffset, (short)ExternalFlash.this.dfTempByte);
                    ExternalFlash.this.echo("written Buffer 1 Byte: " + (short)ExternalFlash.this.dfByteOffset + ": " + ExternalFlash.this.dfTempByte);
                    ExternalFlash.this.dfByteOffset += 1;
                    break;
                }
                case 135: {
                    ExternalFlash.this.setBuffer2(ExternalFlash.this.dfByteOffset, (short)ExternalFlash.this.dfTempByte);
                    ExternalFlash.this.echo("written Buffer 2 Byte: " + (short)ExternalFlash.this.dfByteOffset + ": " + ExternalFlash.this.dfTempByte);
                    ExternalFlash.this.dfByteOffset += 1;
                    break;
                }
                case 131: {
                    break;
                }
                case 134: {
                    break;
                }
                case 136: {
                    break;
                }
                case 137: {
                    break;
                }
                case 129: {
                    break;
                }
                case 80: {
                    ExternalFlash.this.dfPageAddress >>= 3;
                    break;
                }
                case 130: {
                    ExternalFlash.this.setBuffer1(ExternalFlash.this.dfByteOffset, (short)ExternalFlash.this.dfTempByte);
                    ExternalFlash.this.echo("written Buffer 1 Byte: " + (short)ExternalFlash.this.dfByteOffset + ": " + ExternalFlash.this.dfTempByte);
                    ExternalFlash.this.dfByteOffset += 1;
                    break;
                }
                case 133: {
                    ExternalFlash.this.setBuffer2(ExternalFlash.this.dfByteOffset, (short)ExternalFlash.this.dfTempByte);
                    ExternalFlash.this.echo("written Buffer 2 Byte: " + (short)ExternalFlash.this.dfByteOffset + ": " + ExternalFlash.this.dfTempByte);
                    ExternalFlash.this.dfByteOffset += 1;
                }
            }
        }
    }

    protected class PD3Output
    implements Microcontroller.Pin.Output {
        protected PD3Output() {
        }

        public void write(boolean level) {
            ExternalFlash.this.si = level;
        }
    }

    protected class PA3Output
    implements Microcontroller.Pin.Output {
        protected PA3Output() {
        }

        public void write(boolean level) {
            if (!level && !ExternalFlash.this.isSelected) {
                if (ExternalFlash.this.clock.getCount() > 1500L) {
                    ExternalFlash.this.echo("Instruction started");
                }
                ExternalFlash.this.isSelected = true;
            } else if (level && ExternalFlash.this.isSelected) {
                if (ExternalFlash.this.clock.getCount() < 1500L) {
                    ExternalFlash.this.echo("initialized");
                } else {
                    ExternalFlash.this.echo("Instruction finished");
                }
                ExternalFlash.this.isSelected = false;
                switch (ExternalFlash.this.dfOpcode) {
                    case 82: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 104: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 232: {
                        break;
                    }
                    case 131: {
                        ExternalFlash.this.copyBuffer1toPage(ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.echo("copy Buffer1 to Memory Page " + ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.delay = 20.0;
                        break;
                    }
                    case 134: {
                        ExternalFlash.this.copyBuffer2toPage(ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.echo("copy Buffer2 to Memory Page " + ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.delay = 20.0;
                        break;
                    }
                    case 136: {
                        ExternalFlash.this.copyBuffer1toPage(ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.echo("copy Buffer1 to Memory Page " + ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.delay = 14.0;
                        break;
                    }
                    case 137: {
                        ExternalFlash.this.copyBuffer2toPage(ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.echo("copy Buffer2 to Memory Page " + ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.delay = 14.0;
                        break;
                    }
                    case 129: {
                        ExternalFlash.this.delay = 8.0;
                        break;
                    }
                    case 80: {
                        ExternalFlash.this.delay = 12.0;
                        break;
                    }
                    case 130: {
                        ExternalFlash.this.copyBuffer1toPage(ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.echo("copy Buffer1 to Memory Page " + ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.delay = 20.0;
                        break;
                    }
                    case 133: {
                        ExternalFlash.this.copyBuffer2toPage(ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.echo("copy Buffer2 to Memory Page " + ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.delay = 20.0;
                        break;
                    }
                    case 83: {
                        ExternalFlash.this.copyPageToBuffer1(ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.echo("copy Memory Page " + ExternalFlash.this.dfPageAddress + " to Buffer1");
                        ExternalFlash.this.delay = 3.0E-4;
                        break;
                    }
                    case 85: {
                        ExternalFlash.this.copyPageToBuffer2(ExternalFlash.this.dfPageAddress);
                        ExternalFlash.this.echo("copy Memory Page " + ExternalFlash.this.dfPageAddress + " to Buffer2");
                        ExternalFlash.this.delay = 3.0E-4;
                        break;
                    }
                    case 96: {
                        if (ExternalFlash.this.getBuffer1() == ExternalFlash.this.getMemoryPage(ExternalFlash.this.dfPageAddress)) {
                            ExternalFlash.this.dfStatus = (short)(ExternalFlash.this.dfStatus & -65);
                            ExternalFlash.this.echo("compare Memory Page " + ExternalFlash.this.dfPageAddress + " to Buffer1: identical");
                        } else {
                            ExternalFlash.this.dfStatus = (short)(ExternalFlash.this.dfStatus | 64);
                            ExternalFlash.this.echo("compare Memory Page " + ExternalFlash.this.dfPageAddress + " to Buffer1: different");
                        }
                        ExternalFlash.this.delay = 3.0E-4;
                        break;
                    }
                    case 97: {
                        if (ExternalFlash.this.getBuffer2() == ExternalFlash.this.getMemoryPage(ExternalFlash.this.dfPageAddress)) {
                            ExternalFlash.this.dfStatus = (short)(ExternalFlash.this.dfStatus & -65);
                            ExternalFlash.this.echo("compare Memory Page " + ExternalFlash.this.dfPageAddress + " to Buffer2: identical");
                        } else {
                            ExternalFlash.this.dfStatus = (short)(ExternalFlash.this.dfStatus | 64);
                            ExternalFlash.this.echo("compare Memory Page " + ExternalFlash.this.dfPageAddress + " to Buffer2: different");
                        }
                        ExternalFlash.this.delay = 3.0E-4;
                        break;
                    }
                    case 88: 
                    case 89: {
                        ExternalFlash.this.delay = 20.0;
                    }
                }
                ExternalFlash.this.dfStatus = (short)(ExternalFlash.this.dfStatus & -129);
                ExternalFlash.this.dfDelay = ExternalFlash.this.clock.millisToCycles(ExternalFlash.this.delay / 1000.0);
                ExternalFlash.this.clock.insertEvent(new Delay(), ExternalFlash.this.dfDelay);
                ExternalFlash.this.dfOpcode = 0;
                ExternalFlash.this.dfByteOffset = 0;
                ExternalFlash.this.dfPageAddress = 0;
                ExternalFlash.this.step = (short)0;
                ExternalFlash.this.isReading = false;
                ExternalFlash.this.i = (byte)0;
            }
        }
    }

    private class Page {
        public short[] bytes = new short[264];

        protected Page() {
        }

        void debug() {
            for (int i = 0; i < 264; ++i) {
                ExternalFlash.this.echo("Byte " + i + " = " + this.bytes[i]);
            }
        }
    }

    private class Memory {
        Page[] pages = new Page[2048];
        Page buffer1;
        Page buffer2;

        protected Memory() {
            this.buffer1 = new Page();
            this.buffer2 = new Page();
            for (int i = 0; i < 2048; ++i) {
                this.pages[i] = new Page();
            }
        }
    }
}

