/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.platform;

import avrora.core.Program;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.mcu.MicrocontrollerFactory;
import avrora.sim.platform.Platform;
import avrora.sim.platform.PlatformFactory;

public class DefaultPlatform
extends Platform {
    public final int id;

    DefaultPlatform(int id, Microcontroller mcu) {
        super(mcu);
        this.id = id;
    }

    public static class Factory
    implements PlatformFactory {
        public final MicrocontrollerFactory mcf;
        public final long mainClockSpeed;
        public final long extClockSpeed;

        public Factory(long mc, long ext, MicrocontrollerFactory mcf) {
            this.mcf = mcf;
            this.mainClockSpeed = mc;
            this.extClockSpeed = ext;
        }

        public Platform newPlatform(int id, Program p) {
            ClockDomain cd = new ClockDomain(this.mainClockSpeed);
            cd.newClock("external", this.extClockSpeed);
            return new DefaultPlatform(id, this.mcf.newMicrocontroller(id, cd, p));
        }
    }
}

